/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.core.application.DBeaverCommandLine;
import org.jkiss.dbeaver.core.application.DBeaverSettingsImporter;
import org.jkiss.dbeaver.core.application.DBeaverSplashHandler;
import org.jkiss.dbeaver.core.application.rpc.DBeaverInstanceServer;
import org.jkiss.dbeaver.core.application.rpc.IInstanceController;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.impl.app.DefaultSecureStorage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class DBeaverApplication
implements IApplication,
DBPApplication {
    private static final Log log = Log.getLog(DBeaverApplication.class);
    public static final String APPLICATION_PLUGIN_ID = "org.jkiss.dbeaver.core.application";
    public static final String WORKSPACE_DIR_LEGACY = ".dbeaver";
    public static final String WORKSPACE_DIR_4 = ".dbeaver4";
    public static final String WORKSPACE_DIR_CURRENT = ".dbeaver4";
    public static final String[] WORKSPACE_DIR_PREVIOUS = new String[]{".dbeaver"};
    static final String VERSION_PROP_PRODUCT_NAME = "product-name";
    static final String VERSION_PROP_PRODUCT_VERSION = "product-version";
    static boolean WORKSPACE_MIGRATED = false;
    static DBeaverApplication instance;
    boolean reuseWorkspace = false;
    private IInstanceController instanceServer;
    private OutputStream debugWriter;
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private Display display = null;

    public static DBeaverApplication getInstance() {
        return instance;
    }

    public Object start(IApplicationContext context) {
        BundleContext bundleContext;
        instance = this;
        Display.setAppName((String)GeneralUtils.getProductName());
        Location instanceLoc = Platform.getInstanceLocation();
        if (!instanceLoc.isSet() && !this.setDefaultWorkspacePath(instanceLoc)) {
            return IApplication.EXIT_OK;
        }
        this.getDisplay();
        DelayedEventsProcessor processor = new DelayedEventsProcessor(this.display);
        Bundle brandingBundle = context.getBrandingBundle();
        if (brandingBundle != null && (bundleContext = brandingBundle.getBundleContext()) != null) {
            bundleContext.addBundleListener((BundleListener)new BundleLoadListener());
        }
        Log.addListener((message, t) -> DBeaverSplashHandler.showMessage(CommonUtils.toString((Object)message)));
        Runtime runtime = Runtime.getRuntime();
        DBeaverCore.setApplication((DBPApplication)this);
        this.initDebugWriter();
        log.debug((Object)(String.valueOf(GeneralUtils.getProductName()) + " " + GeneralUtils.getProductVersion() + " is starting"));
        log.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        log.debug((Object)("Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + " (" + System.getProperty("sun.arch.data.model") + "bit)"));
        log.debug((Object)("Install path: '" + SystemVariablesResolver.getInstallPath() + "'"));
        log.debug((Object)("Instance path: '" + instanceLoc.getURL() + "'"));
        log.debug((Object)("Memory available " + runtime.totalMemory() / 0x100000L + "Mb/" + runtime.maxMemory() / 0x100000L + "Mb"));
        DBeaverApplication.writeWorkspaceInfo();
        this.instanceServer = DBeaverInstanceServer.startInstanceServer();
        PlatformUI.getPreferenceStore().setDefault("KEY_CONFIGURATION_ID", "org.jkiss.dbeaver.defaultKeyScheme");
        try {
            log.debug((Object)"Run workbench");
            int returnCode = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)this.createWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Throwable e) {
            log.debug((Object)"Internal error in workbench lifecycle", e);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            this.shutdown();
            this.display.dispose();
            this.display = null;
        }
    }

    private Display getDisplay() {
        if (this.display == null) {
            log.debug((Object)"Create display");
            this.display = PlatformUI.createDisplay();
        }
        return this.display;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setDefaultWorkspacePath(Location instanceLoc) {
        String defaultHomePath = DBeaverApplication.getDefaultWorkspaceLocation(".dbeaver4").getAbsolutePath();
        File homeDir = new File(defaultHomePath);
        try {
            if (!homeDir.exists()) {
                DBeaverSettingsImporter importer;
                File previousVersionWorkspaceDir = null;
                String[] stringArray = WORKSPACE_DIR_PREVIOUS;
                int n = WORKSPACE_DIR_PREVIOUS.length;
                int n2 = 0;
                while (n2 < n) {
                    String oldDir = stringArray[n2];
                    File oldWorkspaceDir = new File(DBeaverApplication.getDefaultWorkspaceLocation(oldDir).getAbsolutePath());
                    if (oldWorkspaceDir.exists() && GeneralUtils.getMetadataFolder((File)oldWorkspaceDir).exists()) {
                        previousVersionWorkspaceDir = oldWorkspaceDir;
                        break;
                    }
                    ++n2;
                }
                if (previousVersionWorkspaceDir != null && !(importer = new DBeaverSettingsImporter(this, this.getDisplay())).migrateFromPreviousVersion(previousVersionWorkspaceDir, homeDir)) {
                    return false;
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error migrating old workspace version", e);
        }
        if (DBeaverCommandLine.handleCommandLine(defaultHomePath)) {
            log.debug((Object)("Commands processed. Exit " + GeneralUtils.getProductName() + "."));
            return false;
        }
        try {
            URL defaultHomeURL = new URL("file", null, defaultHomePath);
            boolean keepTrying = true;
            while (keepTrying) {
                if (!instanceLoc.set(defaultHomeURL, true)) {
                    if (this.reuseWorkspace) {
                        instanceLoc.set(defaultHomeURL, false);
                        keepTrying = false;
                        continue;
                    }
                    int msgResult = this.showMessageBox("DBeaver - Can't lock workspace", "Can't lock workspace at " + defaultHomePath + ".\n" + "It seems that you have another DBeaver instance running.\n" + "You may ignore it and work without lock but it is recommended to shutdown previous instance otherwise you may corrupt workspace data.", 3592);
                    switch (msgResult) {
                        case 512: {
                            return false;
                        }
                        case 2048: {
                            instanceLoc.set(defaultHomeURL, false);
                            keepTrying = false;
                            break;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("Can't switch workspace to '" + defaultHomePath + "' - " + e.getMessage());
        }
        DBeaverCommandLine.handleCustomParameters();
        return true;
    }

    public static void writeWorkspaceInfo() {
        File metadataFolder = GeneralUtils.getMetadataFolder();
        Properties props = DBeaverCore.readWorkspaceInfo((File)metadataFolder);
        props.setProperty(VERSION_PROP_PRODUCT_NAME, GeneralUtils.getProductName());
        props.setProperty(VERSION_PROP_PRODUCT_VERSION, GeneralUtils.getProductVersion().toString());
        DBeaverCore.writeWorkspaceInfo((File)metadataFolder, (Properties)props);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new ApplicationWorkbenchAdvisor();
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    private void shutdown() {
        log.debug((Object)"DBeaver is stopping");
        try {
            try {
                this.instanceServer = null;
                DBeaverInstanceServer.stopInstanceServer();
            }
            catch (Throwable e) {
                log.error((Object)e);
                instance = null;
                this.stopDebugWriter();
            }
        }
        finally {
            instance = null;
            this.stopDebugWriter();
        }
    }

    private void initDebugWriter() {
        File debugLogFile;
        DBPPreferenceStore preferenceStore = DBeaverCore.getGlobalPreferenceStore();
        if (!preferenceStore.getBoolean("logs.debug.enabled")) {
            return;
        }
        String logLocation = preferenceStore.getString("logs.debug.location");
        if (CommonUtils.isEmpty((String)logLocation)) {
            logLocation = new File(GeneralUtils.getMetadataFolder(), "dbeaver-debug.log").getAbsolutePath();
        }
        if ((debugLogFile = new File(logLocation = GeneralUtils.replaceVariables((String)logLocation, (GeneralUtils.IVariableResolver)new SystemVariablesResolver()))).exists() && !debugLogFile.delete()) {
            System.err.println("Can't delete debug log file");
            return;
        }
        try {
            this.debugWriter = new FileOutputStream(debugLogFile);
            this.oldSystemOut = System.out;
            this.oldSystemErr = System.err;
            System.setOut(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemOut)));
            System.setErr(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemErr)));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void stopDebugWriter() {
        if (this.oldSystemOut != null) {
            System.setOut(this.oldSystemOut);
        }
        if (this.oldSystemErr != null) {
            System.setErr(this.oldSystemErr);
        }
        if (this.debugWriter != null) {
            IOUtils.close((Closeable)this.debugWriter);
            this.debugWriter = null;
        }
    }

    IInstanceController getInstanceServer() {
        return this.instanceServer;
    }

    private static File getDefaultWorkspaceLocation(String path) {
        return new File(System.getProperty("user.home"), path);
    }

    public boolean isStandalone() {
        return true;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return DefaultSecureStorage.INSTANCE;
    }

    public String getInfoDetails() {
        return null;
    }

    private int showMessageBox(String title, String message, int style) {
        Shell shell = new Shell(this.getDisplay(), 16384);
        shell.setText(GeneralUtils.getProductTitle());
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        int msgResult = messageBox.open();
        shell.dispose();
        return msgResult;
    }

    private static class BundleLoadListener
    implements BundleListener {
        private BundleLoadListener() {
        }

        public void bundleChanged(BundleEvent event) {
            String message = null;
            if (event.getType() == 2) {
                message = "> Start " + event.getBundle().getSymbolicName() + " [" + event.getBundle().getVersion() + "]";
            } else if (event.getType() == 4) {
                message = "< Stop " + event.getBundle().getSymbolicName() + " [" + event.getBundle().getVersion() + "]";
            }
            if (message != null) {
                log.debug(message);
            }
        }
    }

    private class ProxyPrintStream
    extends OutputStream {
        private final OutputStream debugWriter;
        private final OutputStream stdOut;

        ProxyPrintStream(OutputStream debugWriter, OutputStream stdOut) {
            this.debugWriter = debugWriter;
            this.stdOut = stdOut;
        }

        @Override
        public void write(int b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }
    }
}

