/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPRegistryDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferProcessorDescriptor
extends AbstractDescriptor
implements DBPRegistryDescriptor<IDataTransferProcessor> {
    private final DataTransferNodeDescriptor node;
    private final String id;
    private final AbstractDescriptor.ObjectType processorType;
    private final List<AbstractDescriptor.ObjectType> sourceTypes = new ArrayList<AbstractDescriptor.ObjectType>();
    private final String name;
    private final String description;
    private final String appFileExtension;
    private final String appName;
    private final int order;
    @NotNull
    private final DBPImage icon;
    private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private boolean isBinary;
    private transient ProgramInfo program;

    DataTransferProcessorDescriptor(DataTransferNodeDescriptor node, IConfigurationElement config) {
        super(config);
        this.node = node;
        this.id = config.getAttribute("id");
        this.processorType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"), (DBPImage)DBIcon.TYPE_UNKNOWN);
        this.isBinary = CommonUtils.getBoolean((String)config.getAttribute("binary"), (boolean)false);
        this.appFileExtension = config.getAttribute("appFileExtension");
        this.appName = config.getAttribute("appName");
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        for (IConfigurationElement typeCfg : ArrayUtils.safeArray((Object[])config.getChildren("sourceType"))) {
            this.sourceTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, typeCfg.getAttribute("type")));
        }
        for (IConfigurationElement prop : ArrayUtils.safeArray((Object[])config.getChildren("propertyGroup"))) {
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAppFileExtension() {
        return this.appFileExtension;
    }

    public String getAppName() {
        return this.appName;
    }

    public ProgramInfo getOpenWithApplication() {
        if (this.program == null && !CommonUtils.isEmpty((String)this.appFileExtension)) {
            this.program = ProgramInfo.getProgram((String)this.appFileExtension);
        }
        return this.program;
    }

    public int getOrder() {
        return this.order;
    }

    @NotNull
    public DBPImage getIcon() {
        return this.icon;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public DBPPropertyDescriptor getProperty(String name) {
        for (DBPPropertyDescriptor prop : this.properties) {
            if (!prop.getId().equals(name)) continue;
            return prop;
        }
        return null;
    }

    boolean appliesToType(Class objectType) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
            if (!sourceType.matchesType(objectType)) continue;
            return true;
        }
        return false;
    }

    public boolean adaptsToType(IAdaptable adaptable) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
            if (adaptable.getAdapter(sourceType.getObjectClass()) == null) continue;
            return true;
        }
        return false;
    }

    public IDataTransferProcessor getInstance() {
        try {
            this.processorType.checkObjectClass(IDataTransferProcessor.class);
            Class clazz = this.processorType.getObjectClass(IDataTransferProcessor.class);
            return (IDataTransferProcessor)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't instantiate data exporter", e);
        }
    }

    public DataTransferNodeDescriptor getNode() {
        return this.node;
    }

    public boolean isBinaryFormat() {
        return this.isBinary;
    }

    public String getFullId() {
        return String.valueOf(this.node.getId()) + ":" + this.getId();
    }
}

