/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.utils.CommonUtils;

public class DatabaseMappingAttribute
implements DatabaseMappingObject {
    private static final Log log = Log.getLog(DatabaseMappingAttribute.class);
    public static final String TARGET_NAME_SKIP = "[skip]";
    private final DatabaseMappingContainer parent;
    private DBSAttributeBase source;
    private DBSEntityAttribute target;
    private String targetName;
    private String targetType;
    private DatabaseMappingType mappingType;

    DatabaseMappingAttribute(DatabaseMappingContainer parent, DBSAttributeBase source) {
        this.parent = parent;
        this.source = source;
        this.mappingType = DatabaseMappingType.unspecified;
    }

    public DatabaseMappingContainer getParent() {
        return this.parent;
    }

    @Override
    public DBPImage getIcon() {
        return DBValueFormatting.getObjectImage((DBPObject)this.source);
    }

    public DBSAttributeBase getSource() {
        return this.source;
    }

    public String getSourceType() {
        String typeName = this.source.getTypeName();
        if (this.source.getDataKind() == DBPDataKind.STRING) {
            typeName = String.valueOf(typeName) + "(" + this.source.getMaxLength() + ")";
        }
        return typeName;
    }

    @Override
    public String getTargetName() {
        switch (this.mappingType) {
            case existing: {
                if (this.target != null) {
                    return DBUtils.getObjectFullName((DBPNamedObject)this.target, (DBPEvaluationContext)DBPEvaluationContext.UI);
                }
                return this.targetName;
            }
            case create: {
                return this.targetName;
            }
            case skip: {
                return TARGET_NAME_SKIP;
            }
        }
        return "?";
    }

    @Override
    public DatabaseMappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(DatabaseMappingType mappingType) {
        this.mappingType = mappingType;
        switch (mappingType) {
            case create: {
                this.targetName = this.getSource().getName();
            }
        }
    }

    public void updateMappingType(DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer container;
        switch (this.parent.getMappingType()) {
            case existing: {
                this.mappingType = DatabaseMappingType.unspecified;
                if (!(this.parent.getTarget() instanceof DBSEntity)) break;
                if (CommonUtils.isEmpty((String)this.targetName)) {
                    this.targetName = this.source.getName();
                }
                this.target = (DBSEntityAttribute)DBUtils.findObject((Collection)((DBSEntity)this.parent.getTarget()).getAttributes(monitor), (String)this.targetName);
                if (this.target != null) {
                    this.mappingType = DatabaseMappingType.existing;
                    break;
                }
                this.mappingType = DatabaseMappingType.create;
                break;
            }
            case create: {
                this.mappingType = DatabaseMappingType.create;
                if (!CommonUtils.isEmpty((String)this.targetName)) break;
                this.targetName = this.source.getName();
                break;
            }
            case skip: {
                this.mappingType = DatabaseMappingType.skip;
                break;
            }
            default: {
                this.mappingType = DatabaseMappingType.unspecified;
            }
        }
        if (this.mappingType == DatabaseMappingType.create && !CommonUtils.isEmpty((String)this.targetName) && (container = this.parent.getSettings().getContainer()) != null) {
            this.targetName = DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)this.targetName);
        }
    }

    public DBSEntityAttribute getTarget() {
        return this.target;
    }

    public void setTarget(DBSEntityAttribute target) {
        this.target = target;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetType(DBPDataSource targetDataSource) {
        SQLDialect dialect;
        String modifiers;
        if (!CommonUtils.isEmpty((String)this.targetType)) {
            return this.targetType;
        }
        String typeName = this.source.getTypeName();
        DBPDataKind dataKind = this.source.getDataKind();
        if (targetDataSource instanceof DBPDataTypeProvider) {
            DBPDataTypeProvider dataTypeProvider = (DBPDataTypeProvider)targetDataSource;
            DBSDataType dataType = dataTypeProvider.getLocalDataType(typeName);
            if (dataType == null && typeName.equals("DOUBLE") && (dataType = dataTypeProvider.getLocalDataType("DOUBLE PRECISION")) != null) {
                typeName = dataType.getTypeName();
            }
            if (dataType != null && !DBPDataKind.canConsume((DBPDataKind)dataKind, (DBPDataKind)dataType.getDataKind())) {
                dataType = null;
            }
            if (dataType == null) {
                ArrayList<DBSDataType> possibleTypes = new ArrayList<DBSDataType>();
                for (DBSDataType type : dataTypeProvider.getLocalDataTypes()) {
                    if (type.getDataKind() != dataKind) continue;
                    possibleTypes.add(type);
                }
                DBSDataType targetType = null;
                if (!possibleTypes.isEmpty()) {
                    for (DBSDataType type : possibleTypes) {
                        if (!type.getName().contains(typeName) && !typeName.contains(type.getName())) continue;
                        targetType = type;
                        break;
                    }
                }
                if (targetType == null) {
                    typeName = DBUtils.getDefaultDataTypeName((DBPDataSource)targetDataSource, (DBPDataKind)dataKind);
                    if (!possibleTypes.isEmpty()) {
                        for (DBSDataType type : possibleTypes) {
                            if (!type.getName().equalsIgnoreCase(typeName)) continue;
                            targetType = type;
                            break;
                        }
                    }
                }
                if (targetType == null && !possibleTypes.isEmpty()) {
                    targetType = (DBSDataType)possibleTypes.get(0);
                }
                if (targetType != null) {
                    typeName = targetType.getTypeName();
                }
            }
            if (dataType != null) {
                dataKind = dataType.getDataKind();
            }
        }
        if (this.source != null && targetDataSource instanceof SQLDataSource && (modifiers = (dialect = ((SQLDataSource)targetDataSource).getSQLDialect()).getColumnTypeModifiers(targetDataSource, (DBSTypedObject)this.source, typeName, dataKind)) != null) {
            typeName = String.valueOf(typeName) + modifiers;
        }
        return typeName;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    void saveSettings(IDialogSettings settings) {
        if (this.targetName != null) {
            settings.put("targetName", this.targetName);
        }
        if (this.targetType != null) {
            settings.put("targetType", this.targetType);
        }
        if (this.mappingType != null) {
            settings.put("mappingType", this.mappingType.name());
        }
    }

    public void loadSettings(IDialogSettings settings) {
        this.targetName = settings.get("targetName");
        this.targetType = settings.get("targetType");
        if (settings.get("mappingType") != null) {
            try {
                DBSDataManipulator targetEntity;
                DatabaseMappingType newMappingType = DatabaseMappingType.valueOf(settings.get("mappingType"));
                if (!CommonUtils.isEmpty((String)this.targetName) && (targetEntity = this.parent.getTarget()) instanceof DBSEntity) {
                    this.target = ((DBSEntity)targetEntity).getAttribute((DBRProgressMonitor)new VoidProgressMonitor(), this.targetName);
                }
                if (this.target != null && newMappingType == DatabaseMappingType.create) {
                    newMappingType = DatabaseMappingType.existing;
                } else if (this.target == null && newMappingType == DatabaseMappingType.existing) {
                    newMappingType = DatabaseMappingType.create;
                }
                this.setMappingType(newMappingType);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public String toString() {
        return DBUtils.getObjectFullName((DBPNamedObject)this.source, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }
}

