/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndexColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;

public class SQLServerTableIndex
extends JDBCTableIndex<SQLServerSchema, SQLServerTableBase>
implements SQLServerObject,
DBPNamedObject2 {
    private boolean unique;
    private boolean primary;
    private String indexComment;
    private List<SQLServerTableIndexColumn> columns;
    private long objectId;

    public SQLServerTableIndex(SQLServerTableBase table, boolean unique, boolean primary, String indexName, DBSIndexType indexType, String comment, boolean persisted) {
        super((DBSObjectContainer)((SQLServerSchema)table.getContainer()), (JDBCTable)table, indexName, indexType, persisted);
        this.unique = unique;
        this.primary = primary;
        this.indexComment = comment;
    }

    SQLServerTableIndex(DBRProgressMonitor monitor, SQLServerTable table, DBSTableIndex source) throws DBException {
        super((DBSObjectContainer)((SQLServerSchema)table.getContainer()), (JDBCTable)table, source, false);
        this.unique = source.isUnique();
        this.primary = source.isPrimary();
        this.indexComment = source.getDescription();
        boolean cfr_ignored_0 = source instanceof SQLServerTableIndex;
        List columns = source.getAttributeReferences(monitor);
        if (columns != null) {
            this.columns = new ArrayList<SQLServerTableIndexColumn>(columns.size());
            for (DBSTableIndexColumn sourceColumn : columns) {
                this.columns.add(new SQLServerTableIndexColumn(monitor, this, sourceColumn));
            }
        }
    }

    public SQLServerTableIndex(SQLServerTableBase parent, String indexName, DBSIndexType indexType, ResultSet dbResult) {
        super((DBSObjectContainer)((SQLServerSchema)parent.getContainer()), (JDBCTable)parent, indexName, indexType, true);
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"index_id");
        this.unique = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_unique") != 0;
        this.primary = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_primary_key") != 0;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)((SQLServerTableBase)this.getTable()).getDataSource();
    }

    @Property(viewable=false, order=50)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=5)
    public boolean isUnique() {
        return this.unique;
    }

    @Property(viewable=false, order=6)
    public boolean isPrimary() {
        return this.primary;
    }

    @Property(viewable=true, multiline=true, order=100)
    @Nullable
    public String getDescription() {
        return this.indexComment;
    }

    public List<SQLServerTableIndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public SQLServerTableIndexColumn getColumn(String columnName) {
        return (SQLServerTableIndexColumn)DBUtils.findObject(this.columns, (String)columnName);
    }

    void setColumns(List<SQLServerTableIndexColumn> columns) {
        this.columns = columns;
    }

    public void addColumn(SQLServerTableIndexColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<SQLServerTableIndexColumn>();
        }
        this.columns.add(column);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{((SQLServerTableBase)this.getTable()).getContainer(), this});
    }
}

