/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.tokenized;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.tokenized.FormatterToken;
import org.jkiss.dbeaver.model.sql.format.tokenized.SQLFormatterTokenized;
import org.jkiss.dbeaver.model.sql.format.tokenized.TokenType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

class IndentFormatter {
    private static final Log log = Log.getLog(SQLFormatterTokenized.class);
    private final SQLFormatterConfiguration formatterCfg;
    private final boolean isCompact;
    private List<String> statementDelimiters = new LinkedList<String>();
    private String delimiterRedefiner;
    private int indent = 0;
    private int bracketsDepth = 0;
    private boolean encounterBetween = false;
    private List<Boolean> functionBracket = new ArrayList<Boolean>();
    private static final String[] JOIN_BEGIN = new String[]{"LEFT", "RIGHT", "INNER", "OUTER", "FULL", "CROSS", "JOIN"};

    IndentFormatter(SQLFormatterConfiguration formatterCfg, boolean isCompact) {
        this.formatterCfg = formatterCfg;
        this.delimiterRedefiner = formatterCfg.getSyntaxManager().getDialect().getScriptDelimiterRedefiner();
        if (this.delimiterRedefiner != null) {
            this.delimiterRedefiner = this.delimiterRedefiner.toUpperCase(Locale.ENGLISH);
        }
        String[] stringArray = formatterCfg.getSyntaxManager().getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String delim = stringArray[n2];
            this.statementDelimiters.add(delim.toUpperCase(Locale.ENGLISH));
            ++n2;
        }
        this.isCompact = isCompact;
    }

    private int formatSymbol(String tokenString, List<Integer> bracketIndent, List<FormatterToken> argList, Integer index, FormatterToken prev) {
        int result = index;
        switch (tokenString) {
            case "(": {
                this.functionBracket.add(this.formatterCfg.isFunction(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                bracketIndent.add(this.indent);
                ++this.bracketsDepth;
                if (this.isCompact || !this.formatterCfg.getPreferenceStore().getBoolean("sql.format.break.before.close.bracket")) break;
                ++this.indent;
                index = index + this.insertReturnAndIndent(argList, index + 1, this.indent);
                break;
            }
            case ")": {
                if (bracketIndent.isEmpty() || this.functionBracket.isEmpty()) break;
                this.indent = bracketIndent.remove(bracketIndent.size() - 1);
                if (!this.isCompact && this.formatterCfg.getPreferenceStore().getBoolean("sql.format.break.before.close.bracket")) {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                }
                this.functionBracket.remove(this.functionBracket.size() - 1);
                --this.bracketsDepth;
                break;
            }
            case ",": {
                if (this.isCompact) break;
                boolean lfBeforeComma = this.formatterCfg.getPreferenceStore().getBoolean("sql.format.lf.before.comma");
                result += this.insertReturnAndIndent(argList, lfBeforeComma ? index : index + 1, this.indent);
                break;
            }
            default: {
                if (!this.statementDelimiters.contains(tokenString)) break;
                this.indent = 0;
                result += this.insertReturnAndIndent(argList, index, this.indent);
            }
        }
        return result;
    }

    private int formatKeyword(List<FormatterToken> argList, String tokenString, int index) {
        int result;
        block105: {
            block104: {
                result = index;
                if (!this.statementDelimiters.contains(tokenString)) break block104;
                this.indent = 0;
                if (index > 0) {
                    result += this.insertReturnAndIndent(argList, index - 1, this.indent);
                }
                result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                break block105;
            }
            switch (tokenString) {
                case "CREATE": {
                    int nextIndex;
                    if (!this.isCompact && (nextIndex = IndentFormatter.getNextKeyword(argList, index)) > 0 && "OR".equals(argList.get(nextIndex).getString().toUpperCase(Locale.ENGLISH)) && (nextIndex = IndentFormatter.getNextKeyword(argList, nextIndex)) > 0 && "REPLACE".equals(argList.get(nextIndex).getString().toUpperCase(Locale.ENGLISH))) {
                        this.insertReturnAndIndent(argList, nextIndex + 1, this.indent);
                        break;
                    }
                }
                case "INSERT": 
                case "SELECT": 
                case "UPDATE": 
                case "TRUNCATE": 
                case "DROP": 
                case "INTO": 
                case "TABLE": 
                case "DELETE": {
                    if (this.isCompact) break;
                    if (this.bracketsDepth > 0) {
                        result += this.insertReturnAndIndent(argList, index, this.indent);
                    }
                    ++this.indent;
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "CASE": {
                    if (this.isCompact) break;
                    result += this.insertReturnAndIndent(argList, index - 1, this.indent);
                    ++this.indent;
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "START WITH": 
                case "CONNECT BY": 
                case "FROM": 
                case "BEGIN": 
                case "WHERE": 
                case "GROUP BY": 
                case "ORDER BY": 
                case "HAVING": {
                    result += this.insertReturnAndIndent(argList, index, this.indent - 1);
                    if (this.isCompact) break;
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "FULL": 
                case "JOIN": 
                case "LEFT": 
                case "CROSS": 
                case "INNER": 
                case "OUTER": 
                case "RIGHT": {
                    if (this.isJoinStart(argList, index)) {
                        result += this.insertReturnAndIndent(argList, index, this.indent - 1);
                    }
                    tokenString.equals("JOIN");
                    break;
                }
                case "VALUES": 
                case "END": 
                case "LIMIT": {
                    --this.indent;
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    break;
                }
                case "OR": 
                case "ELSE": 
                case "WHEN": {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    break;
                }
                case "SET": {
                    if (index > 1 && "UPDATE".equalsIgnoreCase(this.getPrevKeyword(argList, index))) {
                        result += this.insertReturnAndIndent(argList, index, this.indent - 1);
                    }
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "ON": {
                    result += this.insertReturnAndIndent(argList, index + 1, this.indent);
                    break;
                }
                case "USING": {
                    result += this.insertReturnAndIndent(argList, index, this.indent + 1);
                    break;
                }
                case "TOP": {
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    if (argList.size() >= index + 3) break;
                    result += this.insertReturnAndIndent(argList, index + 3, this.indent);
                    break;
                }
                case "INTERSECT": 
                case "UNION": 
                case "EXCEPT": {
                    this.indent -= 2;
                    result += this.insertReturnAndIndent(argList, index, this.indent);
                    ++this.indent;
                    break;
                }
                case "BETWEEN": {
                    this.encounterBetween = true;
                    break;
                }
                case "AND": {
                    if (!this.encounterBetween) {
                        result += this.insertReturnAndIndent(argList, index, this.indent);
                    }
                    this.encounterBetween = false;
                }
            }
        }
        return result;
    }

    public void format(List<FormatterToken> argList) {
        ArrayList<Integer> bracketIndent = new ArrayList<Integer>();
        FormatterToken prev = new FormatterToken(TokenType.SPACE, " ");
        int index = 0;
        while (index < argList.size()) {
            FormatterToken token = argList.get(index);
            String tokenString = token.getString().toUpperCase(Locale.ENGLISH);
            switch (token.getType()) {
                case SYMBOL: {
                    index = this.formatSymbol(tokenString, bracketIndent, argList, index, prev);
                    break;
                }
                case KEYWORD: {
                    index = this.formatKeyword(argList, tokenString, index);
                    break;
                }
                case COMMENT: {
                    index = this.formatComment(argList, index, token);
                    break;
                }
                case COMMAND: {
                    index = this.formatCommand(argList, index, token);
                    break;
                }
                default: {
                    if (!this.statementDelimiters.contains(tokenString)) break;
                    this.indent = 0;
                    index += this.insertReturnAndIndent(argList, index + 1, this.indent);
                }
            }
            prev = token;
            ++index;
        }
    }

    private int formatCommand(List<FormatterToken> argList, int index, FormatterToken token) {
        String delimiter;
        String command;
        int divPos;
        this.indent = 0;
        if (index > 0) {
            index += this.insertReturnAndIndent(argList, index, 0);
        }
        index += this.insertReturnAndIndent(argList, index + 1, 0);
        if (!CommonUtils.isEmpty((String)this.delimiterRedefiner) && token.getString().startsWith(this.delimiterRedefiner) && (divPos = (command = token.getString().trim().toUpperCase(Locale.ENGLISH)).lastIndexOf(32)) > 0 && !CommonUtils.isEmpty((String)(delimiter = command.substring(divPos).trim()))) {
            this.statementDelimiters.clear();
            this.statementDelimiters.add(delimiter);
        }
        return index;
    }

    private int formatComment(List<FormatterToken> argList, int index, FormatterToken token) {
        Pair<String, String> mlComments;
        boolean isComment = false;
        String[] slComments = this.formatterCfg.getSyntaxManager().getDialect().getSingleLineComments();
        if (slComments != null) {
            String[] stringArray = slComments;
            int n = slComments.length;
            int n2 = 0;
            while (n2 < n) {
                String slc = stringArray[n2];
                if (token.getString().startsWith(slc)) {
                    index += this.insertReturnAndIndent(argList, index, this.indent);
                    isComment = true;
                    break;
                }
                ++n2;
            }
        }
        if (!isComment && (mlComments = this.formatterCfg.getSyntaxManager().getDialect().getMultiLineComments()) != null && token.getString().startsWith((String)mlComments.getFirst())) {
            index += this.insertReturnAndIndent(argList, index + 1, this.indent);
        }
        return index;
    }

    private int insertReturnAndIndent(List<FormatterToken> argList, int argIndex, int argIndent) {
        boolean isDelimiter;
        String s;
        block14: {
            FormatterToken token;
            block13: {
                if (argIndex >= argList.size()) {
                    return 0;
                }
                if (this.functionBracket.contains(Boolean.TRUE)) {
                    return 0;
                }
                try {
                    FormatterToken prevToken;
                    s = GeneralUtils.getDefaultLineSeparator();
                    if (argIndex > 0 && (prevToken = argList.get(argIndex - 1)).getType() == TokenType.COMMENT && SQLUtils.isCommentLine(this.formatterCfg.getSyntaxManager().getDialect(), prevToken.getString())) {
                        s = "";
                    }
                    int index = 0;
                    while (index < argIndent) {
                        s = String.valueOf(s) + this.formatterCfg.getIndentString();
                        ++index;
                    }
                    token = argList.get(argIndex);
                    if (token.getType() != TokenType.SPACE) break block13;
                    token.setString(s);
                    return 0;
                }
                catch (IndexOutOfBoundsException e) {
                    log.debug(e);
                    return 0;
                }
            }
            isDelimiter = this.statementDelimiters.contains(token.getString().toUpperCase());
            if (isDelimiter || argIndex <= 0 || (token = argList.get(argIndex - 1)).getType() != TokenType.SPACE) break block14;
            token.setString(s);
            return 0;
        }
        if (isDelimiter) {
            if (argList.size() > argIndex + 1) {
                FormatterToken lineFeed = new FormatterToken(TokenType.SPACE, String.valueOf(s) + s);
                if (argList.get(argIndex + 1).getType() == TokenType.SPACE) {
                    argList.set(argIndex + 1, lineFeed);
                } else {
                    argList.add(argIndex + 1, lineFeed);
                }
            }
        } else {
            argList.add(argIndex, new FormatterToken(TokenType.SPACE, s));
        }
        return 1;
    }

    private boolean isJoinStart(List<FormatterToken> argList, int index) {
        FormatterToken token;
        if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)argList.get(index).getString().toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        int i = index - 1;
        while (i >= 0) {
            token = argList.get(i);
            if (token.getType() != TokenType.SPACE && token.getType() != TokenType.SYMBOL) {
                if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) break;
                return false;
            }
            --i;
        }
        i = index;
        while (i < argList.size()) {
            token = argList.get(i);
            if (token.getType() != TokenType.SPACE && token.getType() != TokenType.SYMBOL) {
                if (token.getString().toUpperCase(Locale.ENGLISH).equals("JOIN")) {
                    return true;
                }
                if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private String getPrevKeyword(List<FormatterToken> argList, int index) {
        int i = index - 1;
        while (i >= 0) {
            FormatterToken token = argList.get(i);
            if (token.getType() == TokenType.KEYWORD) {
                return token.getString();
            }
            --i;
        }
        return null;
    }

    private static int getNextKeyword(List<FormatterToken> argList, int index) {
        int i = index + 1;
        while (i < argList.size()) {
            if (argList.get(i).getType() == TokenType.KEYWORD) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

