/*
 * Copyright © 2012 - 2014 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef __OCL_COMMON_H__
#define __OCL_COMMON_H__

#include "ocl_types.h"

/////////////////////////////////////////////////////////////////////////////
// Common Functions
/////////////////////////////////////////////////////////////////////////////
OVERLOADABLE float step(float edge, float x);
OVERLOADABLE float max(float a, float b);
OVERLOADABLE float min(float a, float b);
OVERLOADABLE float mix(float x, float y, float a);
OVERLOADABLE float clamp(float v, float l, float u);

OVERLOADABLE float degrees(float radians);
OVERLOADABLE float radians(float degrees);
OVERLOADABLE float smoothstep(float e0, float e1, float x);

OVERLOADABLE float sign(float x);

// Half half version.
OVERLOADABLE half step(half edge, half x);
OVERLOADABLE half max(half a, half b);
OVERLOADABLE half min(half a, half b);
OVERLOADABLE half mix(half x, half y, half a);
OVERLOADABLE half clamp(half v, half l, half u);

OVERLOADABLE half degrees(half radians);
OVERLOADABLE half radians(half degrees);
OVERLOADABLE half smoothstep(half e0, half e1, half x);

OVERLOADABLE half sign(half x);

OVERLOADABLE double step(double edge, double x);
OVERLOADABLE double max(double a, double b);
OVERLOADABLE double min(double a, double b);
OVERLOADABLE double mix(double x, double y, double a);
OVERLOADABLE double clamp(double v, double l, double u);
OVERLOADABLE double degrees(double radians);
OVERLOADABLE double radians(double degrees);
OVERLOADABLE double smoothstep(double e0, double e1, double x);
OVERLOADABLE double sign(double x);

//Begin from this part is autogenerated.
//Don't modify it manually.
//common builtin functions
//gentype clamp (gentype x, gentype minval, gentype maxval)

OVERLOADABLE float2 clamp (float2 param0, float2 param1, float2 param2);
OVERLOADABLE float3 clamp (float3 param0, float3 param1, float3 param2);
OVERLOADABLE float4 clamp (float4 param0, float4 param1, float4 param2);
OVERLOADABLE float8 clamp (float8 param0, float8 param1, float8 param2);
OVERLOADABLE float16 clamp (float16 param0, float16 param1, float16 param2);
OVERLOADABLE double2 clamp (double2 param0, double2 param1, double2 param2);
OVERLOADABLE double3 clamp (double3 param0, double3 param1, double3 param2);
OVERLOADABLE double4 clamp (double4 param0, double4 param1, double4 param2);
OVERLOADABLE double8 clamp (double8 param0, double8 param1, double8 param2);
OVERLOADABLE double16 clamp (double16 param0, double16 param1, double16 param2);
OVERLOADABLE half2 clamp (half2 param0, half2 param1, half2 param2);
OVERLOADABLE half3 clamp (half3 param0, half3 param1, half3 param2);
OVERLOADABLE half4 clamp (half4 param0, half4 param1, half4 param2);
OVERLOADABLE half8 clamp (half8 param0, half8 param1, half8 param2);
OVERLOADABLE half16 clamp (half16 param0, half16 param1, half16 param2);

//gentypef clamp (gentypef x, float minval, float maxval)

OVERLOADABLE float2 clamp (float2 param0, float param1, float param2);
OVERLOADABLE float3 clamp (float3 param0, float param1, float param2);
OVERLOADABLE float4 clamp (float4 param0, float param1, float param2);
OVERLOADABLE float8 clamp (float8 param0, float param1, float param2);
OVERLOADABLE float16 clamp (float16 param0, float param1, float param2);

//gentypeh clamp (gentypeh x, half minval, half maxval)

OVERLOADABLE half2 clamp (half2 param0, half param1, half param2);
OVERLOADABLE half3 clamp (half3 param0, half param1, half param2);
OVERLOADABLE half4 clamp (half4 param0, half param1, half param2);
OVERLOADABLE half8 clamp (half8 param0, half param1, half param2);
OVERLOADABLE half16 clamp (half16 param0, half param1, half param2);

//gentyped clamp (gentyped x, double minval, double maxval)

OVERLOADABLE double2 clamp (double2 param0, double param1, double param2);
OVERLOADABLE double3 clamp (double3 param0, double param1, double param2);
OVERLOADABLE double4 clamp (double4 param0, double param1, double param2);
OVERLOADABLE double8 clamp (double8 param0, double param1, double param2);
OVERLOADABLE double16 clamp (double16 param0, double param1, double param2);

//gentype degrees (gentype radians)

OVERLOADABLE float2 degrees (float2 param0);
OVERLOADABLE float3 degrees (float3 param0);
OVERLOADABLE float4 degrees (float4 param0);
OVERLOADABLE float8 degrees (float8 param0);
OVERLOADABLE float16 degrees (float16 param0);
OVERLOADABLE double2 degrees (double2 param0);
OVERLOADABLE double3 degrees (double3 param0);
OVERLOADABLE double4 degrees (double4 param0);
OVERLOADABLE double8 degrees (double8 param0);
OVERLOADABLE double16 degrees (double16 param0);
OVERLOADABLE half2 degrees (half2 param0);
OVERLOADABLE half3 degrees (half3 param0);
OVERLOADABLE half4 degrees (half4 param0);
OVERLOADABLE half8 degrees (half8 param0);
OVERLOADABLE half16 degrees (half16 param0);

//gentype max (gentype x,  gentype y)

OVERLOADABLE float2 max (float2 param0, float2 param1);
OVERLOADABLE float3 max (float3 param0, float3 param1);
OVERLOADABLE float4 max (float4 param0, float4 param1);
OVERLOADABLE float8 max (float8 param0, float8 param1);
OVERLOADABLE float16 max (float16 param0, float16 param1);
OVERLOADABLE double2 max (double2 param0, double2 param1);
OVERLOADABLE double3 max (double3 param0, double3 param1);
OVERLOADABLE double4 max (double4 param0, double4 param1);
OVERLOADABLE double8 max (double8 param0, double8 param1);
OVERLOADABLE double16 max (double16 param0, double16 param1);
OVERLOADABLE half2 max (half2 param0, half2 param1);
OVERLOADABLE half3 max (half3 param0, half3 param1);
OVERLOADABLE half4 max (half4 param0, half4 param1);
OVERLOADABLE half8 max (half8 param0, half8 param1);
OVERLOADABLE half16 max (half16 param0, half16 param1);

//gentypef max (gentypef x, float y)

OVERLOADABLE float2 max (float2 param0, float param1);
OVERLOADABLE float3 max (float3 param0, float param1);
OVERLOADABLE float4 max (float4 param0, float param1);
OVERLOADABLE float8 max (float8 param0, float param1);
OVERLOADABLE float16 max (float16 param0, float param1);

//gentypeh max (gentypeh x, half y)

OVERLOADABLE half2 max (half2 param0, half param1);
OVERLOADABLE half3 max (half3 param0, half param1);
OVERLOADABLE half4 max (half4 param0, half param1);
OVERLOADABLE half8 max (half8 param0, half param1);
OVERLOADABLE half16 max (half16 param0, half param1);

//gentyped max (gentyped x, double y)

OVERLOADABLE double2 max (double2 param0, double param1);
OVERLOADABLE double3 max (double3 param0, double param1);
OVERLOADABLE double4 max (double4 param0, double param1);
OVERLOADABLE double8 max (double8 param0, double param1);
OVERLOADABLE double16 max (double16 param0, double param1);

//gentype min (gentype x,  gentype y)

OVERLOADABLE float2 min (float2 param0, float2 param1);
OVERLOADABLE float3 min (float3 param0, float3 param1);
OVERLOADABLE float4 min (float4 param0, float4 param1);
OVERLOADABLE float8 min (float8 param0, float8 param1);
OVERLOADABLE float16 min (float16 param0, float16 param1);
OVERLOADABLE double2 min (double2 param0, double2 param1);
OVERLOADABLE double3 min (double3 param0, double3 param1);
OVERLOADABLE double4 min (double4 param0, double4 param1);
OVERLOADABLE double8 min (double8 param0, double8 param1);
OVERLOADABLE double16 min (double16 param0, double16 param1);
OVERLOADABLE half2 min (half2 param0, half2 param1);
OVERLOADABLE half3 min (half3 param0, half3 param1);
OVERLOADABLE half4 min (half4 param0, half4 param1);
OVERLOADABLE half8 min (half8 param0, half8 param1);
OVERLOADABLE half16 min (half16 param0, half16 param1);

//gentypef min (gentypef x,  float y)

OVERLOADABLE float2 min (float2 param0, float param1);
OVERLOADABLE float3 min (float3 param0, float param1);
OVERLOADABLE float4 min (float4 param0, float param1);
OVERLOADABLE float8 min (float8 param0, float param1);
OVERLOADABLE float16 min (float16 param0, float param1);

//gentypeh min (gentypeh x,  half y)

OVERLOADABLE half2 min (half2 param0, half param1);
OVERLOADABLE half3 min (half3 param0, half param1);
OVERLOADABLE half4 min (half4 param0, half param1);
OVERLOADABLE half8 min (half8 param0, half param1);
OVERLOADABLE half16 min (half16 param0, half param1);

//gentyped min (gentyped x,  double y)

OVERLOADABLE double2 min (double2 param0, double param1);
OVERLOADABLE double3 min (double3 param0, double param1);
OVERLOADABLE double4 min (double4 param0, double param1);
OVERLOADABLE double8 min (double8 param0, double param1);
OVERLOADABLE double16 min (double16 param0, double param1);

//gentype mix (gentype x, gentype y, gentype a)

OVERLOADABLE float2 mix (float2 param0, float2 param1, float2 param2);
OVERLOADABLE float3 mix (float3 param0, float3 param1, float3 param2);
OVERLOADABLE float4 mix (float4 param0, float4 param1, float4 param2);
OVERLOADABLE float8 mix (float8 param0, float8 param1, float8 param2);
OVERLOADABLE float16 mix (float16 param0, float16 param1, float16 param2);
OVERLOADABLE double2 mix (double2 param0, double2 param1, double2 param2);
OVERLOADABLE double3 mix (double3 param0, double3 param1, double3 param2);
OVERLOADABLE double4 mix (double4 param0, double4 param1, double4 param2);
OVERLOADABLE double8 mix (double8 param0, double8 param1, double8 param2);
OVERLOADABLE double16 mix (double16 param0, double16 param1, double16 param2);
OVERLOADABLE half2 mix (half2 param0, half2 param1, half2 param2);
OVERLOADABLE half3 mix (half3 param0, half3 param1, half3 param2);
OVERLOADABLE half4 mix (half4 param0, half4 param1, half4 param2);
OVERLOADABLE half8 mix (half8 param0, half8 param1, half8 param2);
OVERLOADABLE half16 mix (half16 param0, half16 param1, half16 param2);

//gentypef mix (gentypef x, gentypef y, float a)

OVERLOADABLE float2 mix (float2 param0, float2 param1, float param2);
OVERLOADABLE float3 mix (float3 param0, float3 param1, float param2);
OVERLOADABLE float4 mix (float4 param0, float4 param1, float param2);
OVERLOADABLE float8 mix (float8 param0, float8 param1, float param2);
OVERLOADABLE float16 mix (float16 param0, float16 param1, float param2);

//gentypeh mix (gentypeh x, gentypeh y, half a)

OVERLOADABLE half2 mix (half2 param0, half2 param1, half param2);
OVERLOADABLE half3 mix (half3 param0, half3 param1, half param2);
OVERLOADABLE half4 mix (half4 param0, half4 param1, half param2);
OVERLOADABLE half8 mix (half8 param0, half8 param1, half param2);
OVERLOADABLE half16 mix (half16 param0, half16 param1, half param2);

//gentyped mix (gentyped x, gentyped y, double a)

OVERLOADABLE double2 mix (double2 param0, double2 param1, double param2);
OVERLOADABLE double3 mix (double3 param0, double3 param1, double param2);
OVERLOADABLE double4 mix (double4 param0, double4 param1, double param2);
OVERLOADABLE double8 mix (double8 param0, double8 param1, double param2);
OVERLOADABLE double16 mix (double16 param0, double16 param1, double param2);

//gentype radians (gentype degrees)

OVERLOADABLE float2 radians (float2 param0);
OVERLOADABLE float3 radians (float3 param0);
OVERLOADABLE float4 radians (float4 param0);
OVERLOADABLE float8 radians (float8 param0);
OVERLOADABLE float16 radians (float16 param0);
OVERLOADABLE double2 radians (double2 param0);
OVERLOADABLE double3 radians (double3 param0);
OVERLOADABLE double4 radians (double4 param0);
OVERLOADABLE double8 radians (double8 param0);
OVERLOADABLE double16 radians (double16 param0);
OVERLOADABLE half2 radians (half2 param0);
OVERLOADABLE half3 radians (half3 param0);
OVERLOADABLE half4 radians (half4 param0);
OVERLOADABLE half8 radians (half8 param0);
OVERLOADABLE half16 radians (half16 param0);

//gentype step (gentype edge, gentype x)

OVERLOADABLE float2 step (float2 param0, float2 param1);
OVERLOADABLE float3 step (float3 param0, float3 param1);
OVERLOADABLE float4 step (float4 param0, float4 param1);
OVERLOADABLE float8 step (float8 param0, float8 param1);
OVERLOADABLE float16 step (float16 param0, float16 param1);
OVERLOADABLE double2 step (double2 param0, double2 param1);
OVERLOADABLE double3 step (double3 param0, double3 param1);
OVERLOADABLE double4 step (double4 param0, double4 param1);
OVERLOADABLE double8 step (double8 param0, double8 param1);
OVERLOADABLE double16 step (double16 param0, double16 param1);
OVERLOADABLE half2 step (half2 param0, half2 param1);
OVERLOADABLE half3 step (half3 param0, half3 param1);
OVERLOADABLE half4 step (half4 param0, half4 param1);
OVERLOADABLE half8 step (half8 param0, half8 param1);
OVERLOADABLE half16 step (half16 param0, half16 param1);

//gentypef step (float edge, gentypef x)

OVERLOADABLE float2 step (float param0, float2 param1);
OVERLOADABLE float3 step (float param0, float3 param1);
OVERLOADABLE float4 step (float param0, float4 param1);
OVERLOADABLE float8 step (float param0, float8 param1);
OVERLOADABLE float16 step (float param0, float16 param1);

//gentypeh step (half edge, gentypeh x)

OVERLOADABLE half2 step (half param0, half2 param1);
OVERLOADABLE half3 step (half param0, half3 param1);
OVERLOADABLE half4 step (half param0, half4 param1);
OVERLOADABLE half8 step (half param0, half8 param1);
OVERLOADABLE half16 step (half param0, half16 param1);

//gentyped step (double edge, gentyped x)

OVERLOADABLE double2 step (double param0, double2 param1);
OVERLOADABLE double3 step (double param0, double3 param1);
OVERLOADABLE double4 step (double param0, double4 param1);
OVERLOADABLE double8 step (double param0, double8 param1);
OVERLOADABLE double16 step (double param0, double16 param1);

//gentype smoothstep (gentype edge0, gentype edge1, gentype x)

OVERLOADABLE float2 smoothstep (float2 param0, float2 param1, float2 param2);
OVERLOADABLE float3 smoothstep (float3 param0, float3 param1, float3 param2);
OVERLOADABLE float4 smoothstep (float4 param0, float4 param1, float4 param2);
OVERLOADABLE float8 smoothstep (float8 param0, float8 param1, float8 param2);
OVERLOADABLE float16 smoothstep (float16 param0, float16 param1, float16 param2);
OVERLOADABLE double2 smoothstep (double2 param0, double2 param1, double2 param2);
OVERLOADABLE double3 smoothstep (double3 param0, double3 param1, double3 param2);
OVERLOADABLE double4 smoothstep (double4 param0, double4 param1, double4 param2);
OVERLOADABLE double8 smoothstep (double8 param0, double8 param1, double8 param2);
OVERLOADABLE double16 smoothstep (double16 param0, double16 param1, double16 param2);
OVERLOADABLE half2 smoothstep (half2 param0, half2 param1, half2 param2);
OVERLOADABLE half3 smoothstep (half3 param0, half3 param1, half3 param2);
OVERLOADABLE half4 smoothstep (half4 param0, half4 param1, half4 param2);
OVERLOADABLE half8 smoothstep (half8 param0, half8 param1, half8 param2);
OVERLOADABLE half16 smoothstep (half16 param0, half16 param1, half16 param2);

//gentypef smoothstep (float edge0, float edge1, gentypef x)

OVERLOADABLE float2 smoothstep (float param0, float param1, float2 param2);
OVERLOADABLE float3 smoothstep (float param0, float param1, float3 param2);
OVERLOADABLE float4 smoothstep (float param0, float param1, float4 param2);
OVERLOADABLE float8 smoothstep (float param0, float param1, float8 param2);
OVERLOADABLE float16 smoothstep (float param0, float param1, float16 param2);

//gentypeh smoothstep (half edge0, half edge1, gentypeh x)

OVERLOADABLE half2 smoothstep (half param0, half param1, half2 param2);
OVERLOADABLE half3 smoothstep (half param0, half param1, half3 param2);
OVERLOADABLE half4 smoothstep (half param0, half param1, half4 param2);
OVERLOADABLE half8 smoothstep (half param0, half param1, half8 param2);
OVERLOADABLE half16 smoothstep (half param0, half param1, half16 param2);

//gentyped smoothstep (double edge0, double edge1, gentyped x)

OVERLOADABLE double2 smoothstep (double param0, double param1, double2 param2);
OVERLOADABLE double3 smoothstep (double param0, double param1, double3 param2);
OVERLOADABLE double4 smoothstep (double param0, double param1, double4 param2);
OVERLOADABLE double8 smoothstep (double param0, double param1, double8 param2);
OVERLOADABLE double16 smoothstep (double param0, double param1, double16 param2);

//gentype sign (gentype x)

OVERLOADABLE float2 sign (float2 param0);
OVERLOADABLE float3 sign (float3 param0);
OVERLOADABLE float4 sign (float4 param0);
OVERLOADABLE float8 sign (float8 param0);
OVERLOADABLE float16 sign (float16 param0);
OVERLOADABLE double2 sign (double2 param0);
OVERLOADABLE double3 sign (double3 param0);
OVERLOADABLE double4 sign (double4 param0);
OVERLOADABLE double8 sign (double8 param0);
OVERLOADABLE double16 sign (double16 param0);
OVERLOADABLE half2 sign (half2 param0);
OVERLOADABLE half3 sign (half3 param0);
OVERLOADABLE half4 sign (half4 param0);
OVERLOADABLE half8 sign (half8 param0);
OVERLOADABLE half16 sign (half16 param0);

#endif
