/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.truth.Platform;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.junit.runner.Runner;
import org.junit.runners.model.Statement;

@GwtIncompatible
final class StackTraceCleaner {
    static final String CLEANER_LINK = "https://goo.gl/aH3UyP";
    private final Throwable throwable;
    private final List<StackTraceElementWrapper> cleanedStackTrace = new ArrayList<StackTraceElementWrapper>();
    private StackTraceElementWrapper lastStackFrameElementWrapper = null;
    private StackFrameType currentStreakType = null;
    private int currentStreakLength = 0;
    private static final ImmutableSet<Class<?>> TRUTH_ENTRANCE_CLASSES = ImmutableSet.of(Subject.class, StandardSubjectBuilder.class);
    private static final ImmutableSet<Class<?>> JUNIT_INFRASTRUCTURE_CLASSES = ImmutableSet.of(Runner.class, Statement.class);

    static void cleanStackTrace(Throwable throwable) {
        new StackTraceCleaner(throwable).clean(Sets.newIdentityHashSet());
    }

    private StackTraceCleaner(Throwable throwable) {
        this.throwable = throwable;
    }

    private void clean(Set<Throwable> seenThrowables) {
        StackTraceElementWrapper stackTraceElementWrapper;
        int endIndex;
        int stackIndex;
        if (StackTraceCleaner.isStackTraceCleaningDisabled()) {
            return;
        }
        if (seenThrowables.contains(this.throwable)) {
            return;
        }
        seenThrowables.add(this.throwable);
        StackTraceElement[] stackFrames = this.throwable.getStackTrace();
        for (stackIndex = stackFrames.length - 1; stackIndex >= 0 && !StackTraceCleaner.isTruthEntrance(stackFrames[stackIndex]); --stackIndex) {
        }
        ++stackIndex;
        for (endIndex = 0; endIndex < stackFrames.length && !StackTraceCleaner.isJUnitIntrastructure(stackFrames[endIndex]); ++endIndex) {
        }
        while (stackIndex < endIndex) {
            StackTraceElementWrapper stackTraceElementWrapper2 = new StackTraceElementWrapper(stackFrames[stackIndex]);
            if (stackTraceElementWrapper2.getStackFrameType() == StackFrameType.NEVER_REMOVE) {
                this.endStreak();
                this.cleanedStackTrace.add(stackTraceElementWrapper2);
            } else {
                this.addToStreak(stackTraceElementWrapper2);
                this.lastStackFrameElementWrapper = stackTraceElementWrapper2;
            }
            ++stackIndex;
        }
        this.endStreak();
        ListIterator<StackTraceElementWrapper> iterator = this.cleanedStackTrace.listIterator(this.cleanedStackTrace.size());
        while (iterator.hasPrevious() && ((stackTraceElementWrapper = iterator.previous()).getStackFrameType() == StackFrameType.TEST_FRAMEWORK || stackTraceElementWrapper.getStackFrameType() == StackFrameType.REFLECTION)) {
            iterator.remove();
        }
        StackTraceElement[] result = new StackTraceElement[this.cleanedStackTrace.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.cleanedStackTrace.get(i).getStackTraceElement();
        }
        this.throwable.setStackTrace(result);
        if (this.throwable.getCause() != null) {
            new StackTraceCleaner(this.throwable.getCause()).clean(seenThrowables);
        }
        for (Throwable suppressed : Platform.getSuppressed(this.throwable)) {
            new StackTraceCleaner(suppressed).clean(seenThrowables);
        }
    }

    private void addToStreak(StackTraceElementWrapper stackTraceElementWrapper) {
        if (stackTraceElementWrapper.getStackFrameType() != this.currentStreakType) {
            this.endStreak();
            this.currentStreakType = stackTraceElementWrapper.getStackFrameType();
            this.currentStreakLength = 1;
        } else {
            ++this.currentStreakLength;
        }
    }

    private void endStreak() {
        if (this.currentStreakLength == 0) {
            return;
        }
        if (this.currentStreakLength == 1) {
            this.cleanedStackTrace.add(this.lastStackFrameElementWrapper);
        } else {
            this.cleanedStackTrace.add(StackTraceCleaner.createStreakReplacementFrame(this.currentStreakType, this.currentStreakLength));
        }
        this.clearStreak();
    }

    private void clearStreak() {
        this.currentStreakType = null;
        this.currentStreakLength = 0;
    }

    private static boolean isTruthEntrance(StackTraceElement stackTraceElement) {
        return StackTraceCleaner.isFromClass(stackTraceElement, TRUTH_ENTRANCE_CLASSES);
    }

    private static boolean isJUnitIntrastructure(StackTraceElement stackTraceElement) {
        return StackTraceCleaner.isFromClass(stackTraceElement, JUNIT_INFRASTRUCTURE_CLASSES);
    }

    private static boolean isFromClass(StackTraceElement stackTraceElement, ImmutableSet<Class<?>> classes) {
        Class<?> stackClass;
        try {
            stackClass = Class.forName(stackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        for (Class knownEntranceClass : classes) {
            if (!knownEntranceClass.isAssignableFrom(stackClass)) continue;
            return true;
        }
        return false;
    }

    private static StackTraceElementWrapper createStreakReplacementFrame(StackFrameType stackFrameType, int length) {
        return new StackTraceElementWrapper(new StackTraceElement("[[" + stackFrameType.getName() + ": " + length + " frames collapsed (" + CLEANER_LINK + ")]]", "", "", 0), stackFrameType);
    }

    private static boolean isStackTraceCleaningDisabled() {
        return Boolean.parseBoolean(System.getProperty("com.google.common.truth.disable_stack_trace_cleaning"));
    }

    private static enum StackFrameType {
        NEVER_REMOVE("N/A", new String[0]),
        TEST_FRAMEWORK("Testing framework", "junit", "org.junit", "com.google.testing.junit", "com.google.testing.testsize", "com.google.testing.util"),
        REFLECTION("Reflective call", "java.lang.reflect", "sun.reflect"),
        CONCURRENT_FRAMEWORK("Concurrent framework", "com.google.tracing.CurrentContext", "com.google.common.util.concurrent", "java.util.concurrent.ForkJoin");

        private final String name;
        private final ImmutableList<String> prefixes;

        private static StackFrameType forClassName(String fullyQualifiedClassName) {
            if (fullyQualifiedClassName.endsWith("Test")) {
                return NEVER_REMOVE;
            }
            for (StackFrameType stackFrameType : StackFrameType.values()) {
                if (!stackFrameType.belongsToType(fullyQualifiedClassName)) continue;
                return stackFrameType;
            }
            return NEVER_REMOVE;
        }

        private StackFrameType(String name, String ... prefixes) {
            this.name = name;
            this.prefixes = ImmutableList.copyOf((Object[])prefixes);
        }

        String getName() {
            return this.name;
        }

        boolean belongsToType(String fullyQualifiedClassName) {
            for (String prefix : this.prefixes) {
                if (!fullyQualifiedClassName.equals(prefix) && !fullyQualifiedClassName.startsWith(prefix + ".")) continue;
                return true;
            }
            return false;
        }
    }

    private static class StackTraceElementWrapper {
        private final StackTraceElement stackTraceElement;
        private final StackFrameType stackFrameType;

        StackTraceElementWrapper(StackTraceElement stackTraceElement) {
            this(stackTraceElement, StackFrameType.forClassName(stackTraceElement.getClassName()));
        }

        StackTraceElementWrapper(StackTraceElement stackTraceElement, StackFrameType stackFrameType) {
            this.stackTraceElement = stackTraceElement;
            this.stackFrameType = stackFrameType;
        }

        StackFrameType getStackFrameType() {
            return this.stackFrameType;
        }

        StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }
    }
}

