(function() {
  var CommandLogger, ignoredCommands, tenMinutes;

  ignoredCommands = {
    'show.bs.tooltip': true,
    'shown.bs.tooltip': true,
    'hide.bs.tooltip': true,
    'hidden.bs.tooltip': true,
    'editor:display-updated': true,
    'mousewheel': true
  };

  tenMinutes = 10 * 60 * 1000;

  module.exports = CommandLogger = (function() {
    CommandLogger.instance = function() {
      return this._instance != null ? this._instance : this._instance = new CommandLogger;
    };

    CommandLogger.start = function() {
      return this.instance().start();
    };

    CommandLogger.prototype.logSize = 16;

    function CommandLogger() {
      this.initLog();
    }

    CommandLogger.prototype.start = function() {
      return atom.commands.onWillDispatch((function(_this) {
        return function(event) {
          return _this.logCommand(event);
        };
      })(this));
    };

    CommandLogger.prototype.getText = function(externalData) {
      var lastTime, lines;
      lines = [];
      lastTime = Date.now();
      this.eachEvent((function(_this) {
        return function(event) {
          if (event.time > lastTime) {
            return;
          }
          if (!event.name || lastTime - event.time >= tenMinutes) {
            return;
          }
          return lines.push(_this.formatEvent(event, lastTime));
        };
      })(this));
      if (externalData) {
        lines.push("     " + (this.formatTime(0)) + " " + externalData.title);
      }
      lines.unshift('```');
      lines.push('```');
      return lines.join("\n");
    };

    CommandLogger.prototype.latestEvent = function() {
      return this.eventLog[this.logIndex];
    };

    CommandLogger.prototype.logCommand = function(command) {
      var event, name, ref, target, time;
      name = command.type, target = command.target, time = command.time;
      if ((ref = command.detail) != null ? ref.jQueryTrigger : void 0) {
        return;
      }
      if (name in ignoredCommands) {
        return;
      }
      event = this.latestEvent();
      if (event.name === name) {
        return event.count++;
      } else {
        this.logIndex = (this.logIndex + 1) % this.logSize;
        event = this.latestEvent();
        event.name = name;
        event.targetNodeName = target.nodeName;
        event.targetClassName = target.className;
        event.targetId = target.id;
        event.count = 1;
        return event.time = time != null ? time : Date.now();
      }
    };

    CommandLogger.prototype.calculateLastEventTime = function(data) {
      var lastTime;
      if (data) {
        return data.time;
      }
      lastTime = null;
      this.eachEvent(function(event) {
        return lastTime = event.time;
      });
      return lastTime;
    };

    CommandLogger.prototype.eachEvent = function(fn) {
      var j, offset, ref;
      for (offset = j = 1, ref = this.logSize; 1 <= ref ? j <= ref : j >= ref; offset = 1 <= ref ? ++j : --j) {
        fn(this.eventLog[(this.logIndex + offset) % this.logSize]);
      }
    };

    CommandLogger.prototype.formatCount = function(count) {
      switch (false) {
        case !(count < 2):
          return '    ';
        case !(count < 10):
          return "  " + count + "x";
        case !(count < 100):
          return " " + count + "x";
      }
    };

    CommandLogger.prototype.formatEvent = function(event, lastTime) {
      var classText, count, idText, j, klass, len, name, nodeText, ref, targetClassName, targetId, targetNodeName, time;
      count = event.count, time = event.time, name = event.name, targetNodeName = event.targetNodeName, targetClassName = event.targetClassName, targetId = event.targetId;
      nodeText = targetNodeName.toLowerCase();
      idText = targetId ? "#" + targetId : '';
      classText = '';
      if (targetClassName != null) {
        ref = targetClassName.split(" ");
        for (j = 0, len = ref.length; j < len; j++) {
          klass = ref[j];
          classText += "." + klass;
        }
      }
      return (this.formatCount(count)) + " " + (this.formatTime(lastTime - time)) + " " + name + " (" + nodeText + idText + classText + ")";
    };

    CommandLogger.prototype.formatTime = function(time) {
      var minutes, seconds;
      minutes = Math.floor(time / 60000);
      seconds = Math.floor(((time % 60000) / 1000) * 10) / 10;
      if (seconds < 10) {
        seconds = "0" + seconds;
      }
      if (Math.floor(seconds) !== seconds) {
        seconds = seconds + ".0";
      }
      return "-" + minutes + ":" + seconds;
    };

    CommandLogger.prototype.initLog = function() {
      var i;
      this.logIndex = 0;
      return this.eventLog = (function() {
        var j, ref, results;
        results = [];
        for (i = j = 0, ref = this.logSize; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
          results.push({
            name: null,
            count: 0,
            targetNodeName: null,
            targetClassName: null,
            targetId: null,
            time: null
          });
        }
        return results;
      }).call(this);
    };

    return CommandLogger;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
