'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarePrStatusContextView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _prStatusesView = require('../views/pr-statuses-view');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BarePrStatusContextView extends _react2.default.Component {

  render() {
    const { context, description, state, targetUrl } = this.props.context;
    const { icon, style } = _prStatusesView.stateToIconAndStyle[state];
    return _react2.default.createElement(
      'li',
      { className: 'github-PrStatuses-list-item' },
      _react2.default.createElement(
        'span',
        { className: 'github-PrStatuses-list-item-icon' },
        _react2.default.createElement(_octicon2.default, { icon: icon, className: style })
      ),
      _react2.default.createElement(
        'span',
        { className: 'github-PrStatuses-list-item-context' },
        _react2.default.createElement(
          'strong',
          null,
          context
        ),
        ' ',
        description
      ),
      _react2.default.createElement(
        'span',
        { className: 'github-PrStatuses-list-item-details-link' },
        _react2.default.createElement(
          'a',
          { href: targetUrl },
          'Details'
        )
      )
    );
  }
}

exports.BarePrStatusContextView = BarePrStatusContextView;
BarePrStatusContextView.propTypes = {
  context: _propTypes2.default.shape({
    context: _propTypes2.default.string.isRequired,
    description: _propTypes2.default.string,
    state: _propTypes2.default.string.isRequired,
    targetUrl: _propTypes2.default.string,
    creator: _propTypes2.default.shape({
      avatarUrl: _propTypes2.default.string.isRequired,
      login: _propTypes2.default.string.isRequired
    })
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BarePrStatusContextView, {
  context: function () {
    const node = require('./__generated__/prStatusContextView_context.graphql');

    if (node.hash && node.hash !== 'e729074e494e07b59b4a177416eb7a3c') {
      console.error('The definition of \'prStatusContextView_context\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/prStatusContextView_context.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByLXN0YXR1cy1jb250ZXh0LXZpZXcuanMiXSwibmFtZXMiOlsiQmFyZVByU3RhdHVzQ29udGV4dFZpZXciLCJSZWFjdCIsIkNvbXBvbmVudCIsInJlbmRlciIsImNvbnRleHQiLCJkZXNjcmlwdGlvbiIsInN0YXRlIiwidGFyZ2V0VXJsIiwicHJvcHMiLCJpY29uIiwic3R5bGUiLCJzdGF0ZVRvSWNvbkFuZFN0eWxlIiwicHJvcFR5cGVzIiwiUHJvcFR5cGVzIiwic2hhcGUiLCJzdHJpbmciLCJpc1JlcXVpcmVkIiwiY3JlYXRvciIsImF2YXRhclVybCIsImxvZ2luIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7Ozs7QUFDQTs7QUFDQTs7OztBQUVBOzs7O0FBQ0E7Ozs7QUFFTyxNQUFNQSx1QkFBTixTQUFzQ0MsZ0JBQU1DLFNBQTVDLENBQXNEOztBQWMzREMsV0FBUztBQUNQLFVBQU0sRUFBQ0MsT0FBRCxFQUFVQyxXQUFWLEVBQXVCQyxLQUF2QixFQUE4QkMsU0FBOUIsS0FBMkMsS0FBS0MsS0FBTCxDQUFXSixPQUE1RDtBQUNBLFVBQU0sRUFBQ0ssSUFBRCxFQUFPQyxLQUFQLEtBQWdCQyxvQ0FBb0JMLEtBQXBCLENBQXRCO0FBQ0EsV0FDRTtBQUFBO0FBQUEsUUFBSSxXQUFVLDZCQUFkO0FBQ0U7QUFBQTtBQUFBLFVBQU0sV0FBVSxrQ0FBaEI7QUFDRSxzQ0FBQyxpQkFBRCxJQUFTLE1BQU1HLElBQWYsRUFBcUIsV0FBV0MsS0FBaEM7QUFERixPQURGO0FBSUU7QUFBQTtBQUFBLFVBQU0sV0FBVSxxQ0FBaEI7QUFDRTtBQUFBO0FBQUE7QUFBU047QUFBVCxTQURGO0FBQUE7QUFDOEJDO0FBRDlCLE9BSkY7QUFPRTtBQUFBO0FBQUEsVUFBTSxXQUFVLDBDQUFoQjtBQUNFO0FBQUE7QUFBQSxZQUFHLE1BQU1FLFNBQVQ7QUFBQTtBQUFBO0FBREY7QUFQRixLQURGO0FBYUQ7QUE5QjBEOztRQUFoRFAsdUIsR0FBQUEsdUI7QUFBQUEsdUIsQ0FDSlksUyxHQUFZO0FBQ2pCUixXQUFTUyxvQkFBVUMsS0FBVixDQUFnQjtBQUN2QlYsYUFBU1Msb0JBQVVFLE1BQVYsQ0FBaUJDLFVBREg7QUFFdkJYLGlCQUFhUSxvQkFBVUUsTUFGQTtBQUd2QlQsV0FBT08sb0JBQVVFLE1BQVYsQ0FBaUJDLFVBSEQ7QUFJdkJULGVBQVdNLG9CQUFVRSxNQUpFO0FBS3ZCRSxhQUFTSixvQkFBVUMsS0FBVixDQUFnQjtBQUN2QkksaUJBQVdMLG9CQUFVRSxNQUFWLENBQWlCQyxVQURMO0FBRXZCRyxhQUFPTixvQkFBVUUsTUFBVixDQUFpQkM7QUFGRCxLQUFoQjtBQUxjLEdBQWhCLEVBU05BO0FBVmMsQztrQkFnQ04seUNBQXdCaEIsdUJBQXhCLEVBQWlEO0FBQzlESTtBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUFBO0FBRDhELENBQWpELEMiLCJmaWxlIjoicHItc3RhdHVzLWNvbnRleHQtdmlldy5qcyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM1LjEvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViL2xpYi92aWV3cyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQge2NyZWF0ZUZyYWdtZW50Q29udGFpbmVyLCBncmFwaHFsfSBmcm9tICdyZWFjdC1yZWxheSc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuXG5pbXBvcnQgT2N0aWNvbiBmcm9tICcuLi9hdG9tL29jdGljb24nO1xuaW1wb3J0IHtzdGF0ZVRvSWNvbkFuZFN0eWxlfSBmcm9tICcuLi92aWV3cy9wci1zdGF0dXNlcy12aWV3JztcblxuZXhwb3J0IGNsYXNzIEJhcmVQclN0YXR1c0NvbnRleHRWaWV3IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBjb250ZXh0OiBQcm9wVHlwZXMuc2hhcGUoe1xuICAgICAgY29udGV4dDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgZGVzY3JpcHRpb246IFByb3BUeXBlcy5zdHJpbmcsXG4gICAgICBzdGF0ZTogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgdGFyZ2V0VXJsOiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgY3JlYXRvcjogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgYXZhdGFyVXJsOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIGxvZ2luOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICB9KSxcbiAgICB9KS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHtjb250ZXh0LCBkZXNjcmlwdGlvbiwgc3RhdGUsIHRhcmdldFVybH0gPSB0aGlzLnByb3BzLmNvbnRleHQ7XG4gICAgY29uc3Qge2ljb24sIHN0eWxlfSA9IHN0YXRlVG9JY29uQW5kU3R5bGVbc3RhdGVdO1xuICAgIHJldHVybiAoXG4gICAgICA8bGkgY2xhc3NOYW1lPVwiZ2l0aHViLVByU3RhdHVzZXMtbGlzdC1pdGVtXCI+XG4gICAgICAgIDxzcGFuIGNsYXNzTmFtZT1cImdpdGh1Yi1QclN0YXR1c2VzLWxpc3QtaXRlbS1pY29uXCI+XG4gICAgICAgICAgPE9jdGljb24gaWNvbj17aWNvbn0gY2xhc3NOYW1lPXtzdHlsZX0gLz5cbiAgICAgICAgPC9zcGFuPlxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUHJTdGF0dXNlcy1saXN0LWl0ZW0tY29udGV4dFwiPlxuICAgICAgICAgIDxzdHJvbmc+e2NvbnRleHR9PC9zdHJvbmc+IHtkZXNjcmlwdGlvbn1cbiAgICAgICAgPC9zcGFuPlxuICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJnaXRodWItUHJTdGF0dXNlcy1saXN0LWl0ZW0tZGV0YWlscy1saW5rXCI+XG4gICAgICAgICAgPGEgaHJlZj17dGFyZ2V0VXJsfT5EZXRhaWxzPC9hPlxuICAgICAgICA8L3NwYW4+XG4gICAgICA8L2xpPlxuICAgICk7XG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgY3JlYXRlRnJhZ21lbnRDb250YWluZXIoQmFyZVByU3RhdHVzQ29udGV4dFZpZXcsIHtcbiAgY29udGV4dDogZ3JhcGhxbGBcbiAgICBmcmFnbWVudCBwclN0YXR1c0NvbnRleHRWaWV3X2NvbnRleHQgb24gU3RhdHVzQ29udGV4dCB7XG4gICAgICBjb250ZXh0IGRlc2NyaXB0aW9uIHN0YXRlIHRhcmdldFVybFxuICAgIH1cbiAgYCxcbn0pO1xuIl19