'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _nodeEmoji = require('node-emoji');

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _multiFilePatchController = require('../controllers/multi-file-patch-controller');

var _multiFilePatchController2 = _interopRequireDefault(_multiFilePatchController);

var _commands = require('../atom/commands');

var _commands2 = _interopRequireDefault(_commands);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CommitDetailView extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.refRoot = new _refHolder2.default();
  }

  render() {
    const commit = this.props.commit;

    return _react2.default.createElement(
      'div',
      { className: 'github-CommitDetailView', ref: this.refRoot.setter },
      this.renderCommands(),
      _react2.default.createElement(
        'div',
        { className: 'github-CommitDetailView-header native-key-bindings', tabIndex: '-1' },
        _react2.default.createElement(
          'div',
          { className: 'github-CommitDetailView-commit' },
          _react2.default.createElement(
            'h3',
            { className: 'github-CommitDetailView-title' },
            (0, _nodeEmoji.emojify)(commit.getMessageSubject())
          ),
          _react2.default.createElement(
            'div',
            { className: 'github-CommitDetailView-meta' },
            this.renderAuthors(),
            _react2.default.createElement(
              'span',
              { className: 'github-CommitDetailView-metaText' },
              this.getAuthorInfo(),
              ' committed ',
              this.humanizeTimeSince(commit.getAuthorDate())
            ),
            _react2.default.createElement(
              'div',
              { className: 'github-CommitDetailView-sha' },
              this.renderDotComLink()
            )
          ),
          this.renderShowMoreButton(),
          this.renderCommitMessageBody()
        )
      ),
      _react2.default.createElement(_multiFilePatchController2.default, _extends({
        multiFilePatch: commit.getMultiFileDiff(),
        surface: this.props.surfaceCommit
      }, this.props))
    );
  }

  renderCommands() {
    return _react2.default.createElement(
      _commands2.default,
      { registry: this.props.commands, target: this.refRoot },
      _react2.default.createElement(_commands.Command, { command: 'github:surface', callback: this.props.surfaceCommit })
    );
  }

  renderCommitMessageBody() {
    const collapsed = this.props.messageCollapsible && !this.props.messageOpen;

    return _react2.default.createElement(
      'pre',
      { className: 'github-CommitDetailView-moreText' },
      collapsed ? this.props.commit.abbreviatedBody() : this.props.commit.getMessageBody()
    );
  }

  renderShowMoreButton() {
    if (!this.props.messageCollapsible) {
      return null;
    }

    const buttonText = this.props.messageOpen ? 'Show Less' : 'Show More';
    return _react2.default.createElement(
      'button',
      { className: 'github-CommitDetailView-moreButton', onClick: this.props.toggleMessage },
      buttonText
    );
  }

  humanizeTimeSince(date) {
    return (0, _moment2.default)(date * 1000).fromNow();
  }

  renderDotComLink() {
    const remote = this.props.currentRemote;
    const sha = this.props.commit.getSha();
    if (remote.isGithubRepo() && this.props.isCommitPushed) {
      const repoUrl = `https://github.com/${remote.getOwner()}/${remote.getRepo()}`;
      return _react2.default.createElement(
        'a',
        { href: `${repoUrl}/commit/${sha}`,
          title: `open commit ${sha} on GitHub.com` },
        sha
      );
    } else {
      return _react2.default.createElement(
        'span',
        null,
        sha
      );
    }
  }

  getAuthorInfo() {
    const commit = this.props.commit;
    const coAuthorCount = commit.getCoAuthors().length;
    if (coAuthorCount === 0) {
      return commit.getAuthorEmail();
    } else if (coAuthorCount === 1) {
      return `${commit.getAuthorEmail()} and ${commit.getCoAuthors()[0].email}`;
    } else {
      return `${commit.getAuthorEmail()} and ${coAuthorCount} others`;
    }
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);

    let avatarUrl;
    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react2.default.createElement('img', { className: 'github-CommitDetailView-avatar github-RecentCommit-avatar',
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];

    return _react2.default.createElement(
      'span',
      { className: 'github-CommitDetailView-authors github-RecentCommit-authors' },
      authorEmails.map(this.renderAuthor)
    );
  }
}
exports.default = CommitDetailView;
CommitDetailView.drilledPropTypes = {
  // Model properties
  repository: _propTypes2.default.object.isRequired,
  commit: _propTypes2.default.object.isRequired,
  currentRemote: _propTypes2.default.object.isRequired,
  isCommitPushed: _propTypes2.default.bool.isRequired,
  itemType: _propTypes2.default.func.isRequired,

  // Atom environment
  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  // Action functions
  destroy: _propTypes2.default.func.isRequired,
  surfaceCommit: _propTypes2.default.func.isRequired
};
CommitDetailView.propTypes = _extends({}, CommitDetailView.drilledPropTypes, {

  // Controller state
  messageCollapsible: _propTypes2.default.bool.isRequired,
  messageOpen: _propTypes2.default.bool.isRequired,

  // Action functions
  toggleMessage: _propTypes2.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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