'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareIssueishDetailController = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _gitShellOutStrategy = require('../git-shell-out-strategy');

var _enableableOperation = require('../models/enableable-operation');

var _enableableOperation2 = _interopRequireDefault(_enableableOperation);

var _prDetailView = require('../views/pr-detail-view');

var _prDetailView2 = _interopRequireDefault(_prDetailView);

var _issueDetailView = require('../views/issue-detail-view');

var _issueDetailView2 = _interopRequireDefault(_issueDetailView);

var _commitDetailItem = require('../items/commit-detail-item');

var _commitDetailItem2 = _interopRequireDefault(_commitDetailItem);

var _reporterProxy = require('../reporter-proxy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareIssueishDetailController extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.openCommit = async ({ sha }) => {
      /* istanbul ignore if */
      if (!this.props.workdirPath) {
        return;
      }

      const uri = _commitDetailItem2.default.buildURI(this.props.workdirPath, sha);
      await this.props.workspace.open(uri, { pending: true });
      (0, _reporterProxy.addEvent)('open-commit-in-pane', { package: 'github', from: this.constructor.name });
    };

    this.state = {
      checkoutInProgress: false,
      typename: null
    };

    this.checkoutOp = new _enableableOperation2.default(() => this.checkout().catch(e => {
      if (!(e instanceof _gitShellOutStrategy.GitError)) {
        throw e;
      }
    }));
    this.checkoutOp.toggleState(this, 'checkoutInProgress');
  }

  //  storing `typename` in state to avoid having to do ugly long chained lookups in several places.
  // note that whether we're rendering an Issue or a PullRequest,
  // relay returns both issue and pull request data.
  // So a pullRequest can have a __typename of `Issue` or `PullRequest`, which is // then set in state here.
  static getDerivedStateFromProps(nextProps, prevState) {
    const { repository } = nextProps;
    const typename = repository && repository.pullRequest && repository.pullRequest.__typename ? repository.pullRequest.__typename : null;
    if (typename && prevState.typename !== typename) {
      return { typename };
    } else {
      return null;
    }
  }

  componentDidMount() {
    this.updateTitle();
  }

  componentDidUpdate() {
    this.updateTitle();
  }

  updateTitle() {
    const { repository } = this.props;
    if (repository && (repository.issue || repository.pullRequest)) {
      let prefix, issueish;
      if (this.state.typename === 'PullRequest') {
        prefix = 'PR:';
        issueish = repository.pullRequest;
      } else {
        prefix = 'Issue:';
        issueish = repository.issue;
      }
      const title = `${prefix} ${repository.owner.login}/${repository.name}#${issueish.number} — ${issueish.title}`;
      this.props.onTitleChange(title);
    }
  }

  render() {
    const { repository } = this.props;
    if (!repository || !repository.issue || !repository.pullRequest) {
      return _react2.default.createElement(
        'div',
        null,
        'Issue/PR #',
        this.props.issueishNumber,
        ' not found'
      ); // TODO: no PRs
    }

    this.checkoutOp = this.nextCheckoutOp();
    if (this.state.typename === 'PullRequest') {
      return _react2.default.createElement(_prDetailView2.default, {
        localRepository: this.props.localRepository,
        repository: repository,
        pullRequest: repository.pullRequest,
        checkoutOp: this.checkoutOp,
        switchToIssueish: this.props.switchToIssueish,

        endpoint: this.props.endpoint,
        token: this.props.token,

        workspace: this.props.workspace,
        commands: this.props.commands,
        keymaps: this.props.keymaps,
        tooltips: this.props.tooltips,
        config: this.props.config,

        openCommit: this.openCommit,

        itemType: this.props.itemType,
        destroy: this.props.destroy
      });
    } else {
      return _react2.default.createElement(_issueDetailView2.default, {
        repository: repository,
        issue: repository.issue,
        switchToIssueish: this.props.switchToIssueish
      });
    }
  }

  nextCheckoutOp() {
    const { repository } = this.props;
    const { pullRequest } = repository;

    if (this.state.typename !== 'PullRequest') {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.HIDDEN, 'Cannot check out an issue');
    }

    if (this.props.isAbsent) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.HIDDEN, 'No repository found');
    }

    if (this.props.isLoading) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Loading');
    }

    if (!this.props.isPresent) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'No repository found');
    }

    if (this.props.isMerging) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Merge in progress');
    }

    if (this.props.isRebasing) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Rebase in progress');
    }

    if (this.state.checkoutInProgress) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Checking out...');
    }

    // determine if pullRequest.headRepository is null
    // this can happen if a repository has been deleted.
    if (!pullRequest.headRepository) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.DISABLED, 'Pull request head repository does not exist');
    }

    // Determine if we already have this PR checked out.

    const headPush = this.props.branches.getHeadBranch().getPush();
    const headRemote = this.props.remotes.withName(headPush.getRemoteName());

    // (detect checkout from pull/### refspec)
    const fromPullRefspec = headRemote.getOwner() === repository.owner.login && headRemote.getRepo() === repository.name && headPush.getShortRemoteRef() === `pull/${pullRequest.number}/head`;

    // (detect checkout from head repository)
    const fromHeadRepo = headRemote.getOwner() === pullRequest.headRepository.owner.login && headRemote.getRepo() === pullRequest.headRepository.name && headPush.getShortRemoteRef() === pullRequest.headRefName;

    if (fromPullRefspec || fromHeadRepo) {
      return this.checkoutOp.disable(_prDetailView.checkoutStates.CURRENT, 'Current');
    }

    return this.checkoutOp.enable();
  }

  async checkout() {
    const { repository } = this.props;
    const { pullRequest } = repository;
    const { headRepository } = pullRequest;

    const fullHeadRef = `refs/heads/${pullRequest.headRefName}`;

    let sourceRemoteName, localRefName;

    // Discover or create a remote pointing to the repo containing the pull request's head ref.
    // If the local repository already has the head repository specified as a remote, that remote will be used, so
    // that any related configuration is picked up for the fetch. Otherwise, the head repository fetch URL is used
    // directly.
    const headRemotes = this.props.remotes.matchingGitHubRepository(headRepository.owner.login, headRepository.name);
    if (headRemotes.length > 0) {
      sourceRemoteName = headRemotes[0].getName();
    } else {
      const url = {
        https: headRepository.url + '.git',
        ssh: headRepository.sshUrl
      }[this.props.remotes.mostUsedProtocol(['https', 'ssh'])];

      // This will throw if a remote with this name already exists (and points somewhere else, or we would have found
      // it above). ¯\_(ツ)_/¯
      const remote = await this.props.addRemote(headRepository.owner.login, url);
      sourceRemoteName = remote.getName();
    }

    // Identify an existing local ref that already corresponds to the pull request, if one exists. Otherwise, generate
    // a new local ref name.
    const pullTargets = this.props.branches.getPullTargets(sourceRemoteName, fullHeadRef);
    if (pullTargets.length > 0) {
      localRefName = pullTargets[0].getName();

      // Check out the existing local ref.
      await this.props.checkout(localRefName);
      try {
        await this.props.pull(fullHeadRef, { remoteName: sourceRemoteName, ffOnly: true });
      } finally {
        (0, _reporterProxy.incrementCounter)('checkout-pr');
      }

      return;
    }

    await this.props.fetch(fullHeadRef, { remoteName: sourceRemoteName });

    // Check out the local ref and set it up to track the head ref.
    await this.props.checkout(`pr-${pullRequest.number}/${headRepository.owner.login}/${pullRequest.headRefName}`, {
      createNew: true,
      track: true,
      startPoint: `refs/remotes/${sourceRemoteName}/${pullRequest.headRefName}`
    });

    (0, _reporterProxy.incrementCounter)('checkout-pr');
  }

}

exports.BareIssueishDetailController = BareIssueishDetailController;
BareIssueishDetailController.propTypes = {
  // Relay response
  repository: _propTypes2.default.shape({
    name: _propTypes2.default.string.isRequired,
    owner: _propTypes2.default.shape({
      login: _propTypes2.default.string.isRequired
    }).isRequired,
    pullRequest: _propTypes2.default.any,
    issue: _propTypes2.default.any
  }),
  issueishNumber: _propTypes2.default.number.isRequired,

  // Local Repository model properties
  localRepository: _propTypes2.default.object.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  isMerging: _propTypes2.default.bool.isRequired,
  isRebasing: _propTypes2.default.bool.isRequired,
  isAbsent: _propTypes2.default.bool.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,
  isPresent: _propTypes2.default.bool.isRequired,
  workdirPath: _propTypes2.default.string,

  // Connection information
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Atom environment
  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  // Action methods
  fetch: _propTypes2.default.func.isRequired,
  checkout: _propTypes2.default.func.isRequired,
  pull: _propTypes2.default.func.isRequired,
  addRemote: _propTypes2.default.func.isRequired,
  onTitleChange: _propTypes2.default.func.isRequired,
  switchToIssueish: _propTypes2.default.func.isRequired,
  destroy: _propTypes2.default.func.isRequired,

  // Item context
  itemType: _propTypes3.ItemTypePropType.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareIssueishDetailController, {
  repository: function () {
    const node = require('./__generated__/issueishDetailController_repository.graphql');

    if (node.hash && node.hash !== '616ab785cf6824cb91ed3002553abb70') {
      console.error('The definition of \'issueishDetailController_repository\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueishDetailController_repository.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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