/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;

public class StringReplacer {
    public static void checkIfRequiredKeyIsMissingOrExcept(String key, String src, PreferencesMap inDict) throws PreferencesMapException {
        String res;
        String tag;
        String checkedValue = (String)inDict.get(key);
        if (checkedValue != null && !checkedValue.isEmpty()) {
            return;
        }
        PreferencesMap dict = new PreferencesMap(inDict);
        while (src.contains(tag = UUID.randomUUID().toString()) || dict.values().contains(tag) || dict.keySet().contains(tag)) {
        }
        dict.put(key, tag);
        for (int i = 0; i < 10 && !(res = StringReplacer.replaceFromMapping(src, dict)).equals(src); ++i) {
            src = res;
        }
        if (src.contains(tag)) {
            throw new PreferencesMapException(key);
        }
    }

    public static String[] formatAndSplit(String src, Map<String, String> dict) throws Exception {
        String res;
        for (int i = 0; i < 10 && !(res = StringReplacer.replaceFromMapping(src, dict)).equals(src); ++i) {
            src = res;
        }
        return StringReplacer.quotedSplit(src, "\"'", false);
    }

    public static String[] quotedSplit(String src, String quoteChars, boolean acceptEmptyArguments) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        String escapedArg = null;
        String escapingChar = null;
        for (String i : src.split(" ")) {
            if (escapingChar == null) {
                String first = null;
                if (i.length() > 0) {
                    first = i.substring(0, 1);
                }
                if (first == null || !quoteChars.contains(first)) {
                    if (i.trim().length() == 0 && !acceptEmptyArguments) continue;
                    res.add(i);
                    continue;
                }
                escapingChar = first;
                i = i.substring(1);
                escapedArg = "";
            }
            if (!i.endsWith(escapingChar)) {
                escapedArg = escapedArg + i + " ";
                continue;
            }
            if ((escapedArg = escapedArg + i.substring(0, i.length() - 1)).trim().length() != 0 || acceptEmptyArguments) {
                res.add(escapedArg);
            }
            escapingChar = null;
        }
        if (escapingChar != null) {
            throw new Exception("Invalid quoting: no closing [" + escapingChar + "] char found.");
        }
        return res.toArray(new String[0]);
    }

    public static String replaceFromMapping(String src, Map<String, String> map) {
        return StringReplacer.replaceFromMapping(src, map, "{", "}");
    }

    public static String replaceFromMapping(String src, Map<String, String> map, String leftDelimiter, String rightDelimiter) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String keyword = leftDelimiter + entry.getKey() + rightDelimiter;
            if (entry.getValue() == null || keyword == null) continue;
            src = src.replace(keyword, entry.getValue());
        }
        return src;
    }
}

