/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.custom;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.custom.ConfigImportWizardCustom;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ConfigImportWizardPageCustomConnections
extends ConfigImportWizardPage {
    protected ConfigImportWizardPageCustomConnections() {
        super("Connections");
        this.setTitle("Connections");
        this.setDescription("Import connections");
    }

    @Override
    protected void loadConnections(ImportData importData) throws DBException {
        this.setErrorMessage(null);
        ConfigImportWizardCustom wizard = (ConfigImportWizardCustom)this.getWizard();
        DBPDriver driver = wizard.getDriver();
        ImportDriverInfo driverInfo = new ImportDriverInfo(driver.getId(), driver.getName(), driver.getSampleURL(), driver.getDriverClassName());
        importData.addDriver(driverInfo);
        File inputFile = wizard.getInputFile();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileInputStream is = new FileInputStream(inputFile);){
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (InputStreamReader reader = new InputStreamReader((InputStream)is, wizard.getInputFileEncoding());){
                    if (wizard.getImportType() == ConfigImportWizardCustom.ImportType.CSV) {
                        this.importCSV(importData, driverInfo, reader);
                    } else {
                        this.importXML(importData, driverInfo, reader);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void importCSV(ImportData importData, ImportDriverInfo driver, Reader reader) throws IOException {
        Object[] line;
        CSVReader csvReader = new CSVReader(reader);
        Object[] header = csvReader.readNext();
        if (ArrayUtils.isEmpty((Object[])header)) {
            this.setErrorMessage("No connection found");
            return;
        }
        while (!ArrayUtils.isEmpty((Object[])(line = csvReader.readNext()))) {
            HashMap<String, String> conProps = new HashMap<String, String>();
            int i = 0;
            while (i < line.length) {
                if (i >= header.length) break;
                conProps.put((String)header[i], (String)line[i]);
                ++i;
            }
            this.makeConnectionFromProps(importData, driver, conProps);
        }
    }

    private void importXML(ImportData importData, ImportDriverInfo driver, Reader reader) throws XMLException {
        Document document = XMLUtils.parseDocument((Reader)reader);
        for (Element conElement : XMLUtils.getChildElementList((Element)document.getDocumentElement())) {
            HashMap<String, String> conProps = new HashMap<String, String>();
            NamedNodeMap attrs = conElement.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Attr attr = (Attr)attrs.item(i);
                conProps.put(attr.getName(), attr.getValue());
                ++i;
            }
            this.makeConnectionFromProps(importData, driver, conProps);
        }
    }

    private void makeConnectionFromProps(ImportData importData, ImportDriverInfo driver, Map<String, String> conProps) {
        String name = conProps.get("name");
        if (CommonUtils.isEmpty((String)name)) {
            return;
        }
        importData.addConnection(new ImportConnectionInfo(driver, conProps.get("id"), name, conProps.get("url"), conProps.get("host"), conProps.get("port"), conProps.get("database"), conProps.get("user"), conProps.get("password")));
    }
}

