/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.perspective;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectObjectDialog;
import org.jkiss.dbeaver.ui.perspective.PerspectiveMessages;
import org.jkiss.utils.CommonUtils;

class SelectDatabaseDialog
extends SelectObjectDialog<DBNDatabaseNode> {
    private static final Log log = Log.getLog(SelectDatabaseDialog.class);
    private final DBPDataSourceContainer dataSourceContainer;
    private String currentInstanceName;
    private Collection<? extends DBSObject> instanceObjects;

    SelectDatabaseDialog(Shell parentShell, DBPDataSourceContainer dataSourceContainer, String currentInstanceName, Collection<DBNDatabaseNode> objects, Collection<DBNDatabaseNode> selected) {
        super(parentShell, PerspectiveMessages.label_choose_catalog, true, "SchemaSelector", objects, selected);
        this.dataSourceContainer = dataSourceContainer;
        this.currentInstanceName = currentInstanceName;
    }

    protected void createUpperControls(Composite dialogArea) {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (this.currentInstanceName != null && dataSource != null) {
            DBSObjectSelector instanceSelector = (DBSObjectSelector)DBUtils.getAdapter(DBSObjectSelector.class, (Object)dataSource);
            DBSObjectContainer instanceContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
            if (instanceSelector != null && instanceContainer != null) {
                Composite instancePanel = UIUtils.createComposite((Composite)dialogArea, (int)3);
                instancePanel.setLayoutData((Object)new GridData(768));
                UIUtils.createLabel((Composite)instancePanel, (DBPImage)this.dataSourceContainer.getDriver().getIcon());
                Combo instanceCombo = UIUtils.createLabelCombo((Composite)instancePanel, (String)PerspectiveMessages.label_instance, (String)PerspectiveMessages.label_active_service_instance, (int)12);
                instanceCombo.setLayoutData((Object)new GridData(768));
                try {
                    this.instanceObjects = instanceContainer.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                    if (this.instanceObjects != null) {
                        for (DBSObject dBSObject : this.instanceObjects) {
                            instanceCombo.add(dBSObject.getName());
                        }
                        instanceCombo.setText(this.currentInstanceName);
                    }
                }
                catch (DBException dBException) {
                    log.error((Object)PerspectiveMessages.label_error_list, (Throwable)dBException);
                }
                instanceCombo.addModifyListener(e -> {
                    String instanceName = instanceCombo.getText();
                    if (!CommonUtils.equalObjects((Object)instanceName, (Object)this.currentInstanceName)) {
                        this.currentInstanceName = instanceName;
                        this.objectList.loadData();
                    }
                });
                this.closeOnFocusLost(new Control[]{instanceCombo});
            }
        }
    }

    protected Collection<DBNDatabaseNode> getObjects(DBRProgressMonitor monitor) throws DBException {
        DBSObject newInstance;
        if (this.instanceObjects != null && this.currentInstanceName != null && (newInstance = (DBSObject)DBUtils.findObject(this.instanceObjects, (String)this.currentInstanceName)) instanceof DBSObjectContainer) {
            Collection databaseList = ((DBSObjectContainer)newInstance).getChildren(monitor);
            if (databaseList == null) {
                return Collections.emptyList();
            }
            ArrayList<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>(databaseList.size());
            for (DBSObject database : databaseList) {
                DBNDatabaseNode databaseNode = NavigatorUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)database, (boolean)false);
                if (databaseNode == null) continue;
                nodeList.add(databaseNode);
            }
            return nodeList;
        }
        return this.objects;
    }

    public String getCurrentInstanceName() {
        return this.currentInstanceName;
    }
}

