/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.CommonUtils;

public class DriverFileSource {
    private static final Log log = Log.getLog(DriverFileSource.class);
    private final String url;
    private final String name;
    private final String instructions;
    private final List<FileInfo> files = new ArrayList<FileInfo>();

    DriverFileSource(IConfigurationElement config) {
        this.url = config.getAttribute("url");
        this.name = config.getAttribute("name");
        this.instructions = config.getAttribute("instructions");
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("file");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            this.files.add(new FileInfo(cfg));
            ++n2;
        }
    }

    public DriverFileSource(DriverFileSource copyFrom) {
        this.url = copyFrom.url;
        this.name = copyFrom.name;
        this.instructions = copyFrom.instructions;
        this.files.addAll(copyFrom.files);
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public String toString() {
        return this.url;
    }

    public static class FileInfo {
        private final String name;
        private final String description;
        private final boolean optional;

        FileInfo(IConfigurationElement config) {
            this.name = config.getAttribute("name");
            this.description = config.getAttribute("description");
            this.optional = CommonUtils.getBoolean((String)config.getAttribute("optional"), (boolean)false);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

