/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.objectweb.asm.ClassReader;

public class DriverClassFindJob
implements IRunnableWithProgress {
    private static final Log log = Log.getLog(DriverClassFindJob.class);
    public static final String OBJECT_CLASS_NAME = "java/lang/Object";
    public static final String CLASS_FILE_EXT = ".class";
    private List<String> driverClassNames = new ArrayList<String>();
    private final DriverDescriptor driver;
    private final String interfaceName;
    private final boolean isInterface;

    public DriverClassFindJob(DBPDriver driver, String interfaceName, boolean isInterface) {
        this.driver = (DriverDescriptor)driver;
        this.interfaceName = interfaceName;
        this.isInterface = isInterface;
    }

    public List<String> getDriverClassNames() {
        return this.driverClassNames;
    }

    public void run(IProgressMonitor monitor) {
        this.findDriverClasses(monitor);
    }

    private void findDriverClasses(IProgressMonitor monitor) {
        ArrayList<File> libFiles = new ArrayList<File>();
        ArrayList<URL> libURLs = new ArrayList<URL>();
        for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
            File libFile = dBPDriverLibrary.getLocalFile();
            if (libFile != null && libFile.exists() && !libFile.isDirectory() && dBPDriverLibrary.getType() == DBPDriverLibrary.FileType.jar) {
                libFiles.add(libFile);
                try {
                    libURLs.add(libFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    log.debug((Object)e);
                }
                continue;
            }
            Collection<DriverDescriptor.DriverFileInfo> files = this.driver.getLibraryFiles(dBPDriverLibrary);
            if (files == null) continue;
            for (DriverDescriptor.DriverFileInfo file : files) {
                if (file.getFile() == null || !file.getFile().exists()) continue;
                libFiles.add(file.getFile());
            }
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(libURLs.toArray(new URL[libURLs.size()]));
        for (File libFile : libFiles) {
            if (monitor.isCanceled()) break;
            this.findDriverClasses(monitor, uRLClassLoader, libFile);
        }
    }

    private void findDriverClasses(IProgressMonitor monitor, ClassLoader findCL, File libFile) {
        try {
            JarFile currentFile = new JarFile(libFile, false);
            monitor.beginTask(libFile.getName(), currentFile.size());
            Enumeration<JarEntry> e = currentFile.entries();
            while (e.hasMoreElements()) {
                if (monitor.isCanceled()) break;
                JarEntry current = e.nextElement();
                String fileName = current.getName();
                if (!fileName.endsWith(CLASS_FILE_EXT) || fileName.contains("$")) continue;
                String className = fileName.replaceAll("/", ".").replace(CLASS_FILE_EXT, "");
                monitor.subTask(className);
                try {
                    if (this.implementsInterface(currentFile, current, 0)) {
                        this.driverClassNames.add(className);
                    }
                }
                catch (Throwable throwable) {}
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean implementsInterface(JarFile currentFile, JarEntry current, int depth) throws IOException {
        block22: {
            var4_4 = null;
            var5_6 = null;
            try {
                classStream = currentFile.getInputStream(current);
                try {
                    cr = new ClassReader(classStream);
                    access = cr.getAccess();
                    if (depth == 0 && ((access & 1) == 0 || (access & 1024) != 0)) {
                        return false;
                    }
                    superName = cr.getSuperName();
                    if (this.isInterface) {
                        interfaces = cr.getInterfaces();
                        if (ArrayUtils.contains((Object[])interfaces, (Object)this.interfaceName)) {
                            return true;
                        }
                        if (!CommonUtils.isEmpty((String)superName) && !superName.equals("java/lang/Object") && (jarEntry = currentFile.getJarEntry(String.valueOf(superName) + ".class")) != null) {
                            return this.implementsInterface(currentFile, jarEntry, depth + 1);
                        }
                        var14_15 = interfaces;
                        var13_16 = interfaces.length;
                        var12_17 = 0;
                        while (var12_17 < var13_16) {
                            intName = var14_15[var12_17];
                            jarEntry = currentFile.getJarEntry(String.valueOf(intName) + ".class");
                            if (jarEntry != null && this.implementsInterface(currentFile, jarEntry, depth + 1)) {
                                return true;
                            }
                            ++var12_17;
                        }
                        break block22;
                    }
                    if (superName == null) break block22;
                    if (this.interfaceName.equals(superName)) {
                        return true;
                    }
                    jarEntry = currentFile.getJarEntry(String.valueOf(superName) + ".class");
                    if (jarEntry == null || !this.implementsInterface(currentFile, jarEntry, depth + 1)) break block22;
                    return true;
                }
                catch (Throwable var4_5) {
                    throw var4_5;
                }
                finally {
                    if (classStream == null) ** continue;
                    classStream.close();
                }
            }
            catch (Throwable var5_7) {
                if (var4_4 == null) {
                    var4_4 = var5_7;
                } else if (var4_4 != var5_7) {
                    var4_4.addSuppressed(var5_7);
                }
                throw var4_4;
            }
        }
        return false;
    }
}

