/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.utils.CommonUtils;

public abstract class SQLServerTableBase
extends JDBCTable<SQLServerDataSource, SQLServerSchema>
implements SQLServerObject,
DBPNamedObject2,
DBPRefreshableObject,
DBSObjectWithScript,
DBPSystemObject {
    private static final Log log = Log.getLog(SQLServerTableBase.class);
    private static final String CAT_STATISTICS = "Statistics";
    private long objectId;
    private String type;
    private String description;
    private Long rowCount;

    protected SQLServerTableBase(SQLServerSchema schema) {
        super((DBSObjectContainer)schema, false);
    }

    protected SQLServerTableBase(DBRProgressMonitor monitor, SQLServerSchema catalog, SQLServerTableBase source) throws DBException {
        super((DBSObjectContainer)catalog, (DBSEntity)source, false);
    }

    protected SQLServerTableBase(SQLServerSchema catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name"), true);
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.type = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type");
    }

    public SQLServerDatabase getDatabase() {
        return this.getSchema().getDatabase();
    }

    public SQLServerSchema getSchema() {
        return (SQLServerSchema)this.getContainer();
    }

    public JDBCStructCache<SQLServerSchema, ? extends JDBCTable, ? extends JDBCTableColumn> getCache() {
        return ((SQLServerSchema)this.getContainer()).getTableCache();
    }

    @Property(viewable=false, editable=false, order=5)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(order=6)
    public String getType() {
        return this.type;
    }

    public boolean isSystem() {
        return SQLServerObjectType.S.name().equals(this.type);
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<SQLServerTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List childColumns = ((SQLServerSchema)this.getContainer()).getTableCache().getChildren(monitor, (DBSObject)((SQLServerSchema)this.getContainer()), (DBSObject)this);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<SQLServerTableColumn> columns = new ArrayList<SQLServerTableColumn>(childColumns);
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (SQLServerTableColumn)((SQLServerSchema)this.getContainer()).getTableCache().getChild(monitor, (DBSObject)((SQLServerSchema)this.getContainer()), (DBSObject)this, attributeName);
    }

    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull long columnId) throws DBException {
        for (SQLServerTableColumn col : this.getAttributes(monitor)) {
            if (col.getObjectId() != columnId) continue;
            return col;
        }
        log.error((Object)("Column '" + columnId + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    @Association
    public Collection<SQLServerTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getIndexCache().getObjects(monitor, (DBSObject)this.getSchema(), (DBSObject)this);
    }

    public SQLServerTableIndex getIndex(DBRProgressMonitor monitor, long indexId) throws DBException {
        for (SQLServerTableIndex index : this.getIndexes(monitor)) {
            if (index.getObjectId() != indexId) continue;
            return index;
        }
        log.error((Object)("Index '" + indexId + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    public SQLServerTableIndex getIndex(DBRProgressMonitor monitor, String name) throws DBException {
        for (SQLServerTableIndex index : this.getIndexes(monitor)) {
            if (!CommonUtils.equalObjects((Object)name, (Object)index.getName())) continue;
            return index;
        }
        log.error((Object)("Index '" + name + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=23)
    public Long getRowCount(DBRProgressMonitor monitor) {
        if (this.rowCount != null || !this.isPersisted()) {
            return this.rowCount;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                this.rowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.rowCount == null) {
            this.rowCount = -1L;
        }
        return this.rowCount;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.isView() && context == DBPEvaluationContext.DDL) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getDatabase(), this.getSchema(), this});
    }
}

