/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.utils.CommonUtils;

public class SQLServerDialect
extends JDBCSQLDialect {
    private static final String[][] TSQL_BEGIN_END_BLOCK = new String[0][];
    public static final String[][] SQLSERVER_QUOTE_STRINGS = new String[][]{{"[", "]"}, {"\"", "\""}};
    private static String[] EXEC_KEYWORDS = new String[]{"CALL", "EXEC"};
    private JDBCDataSource dataSource;

    public SQLServerDialect() {
        super("SQLServer");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        this.addSQLKeyword("TOP");
        this.dataSource = dataSource;
    }

    public String getScriptDelimiter() {
        return "GO";
    }

    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public boolean isDelimiterAfterQuery() {
        return SQLServerUtils.isDriverSqlServer(this.dataSource.getContainer().getDriver());
    }

    public boolean supportsSubqueries() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        return SQLSERVER_QUOTE_STRINGS;
    }

    public String[][] getBlockBoundStrings() {
        return TSQL_BEGIN_END_BLOCK;
    }

    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        if (SQLServerUtils.isDriverSqlServer(this.dataSource.getContainer().getDriver())) {
            if (this.dataSource.isServerVersionAtLeast(10, 0)) {
                return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
            }
            return super.getMultiValueInsertMode();
        }
        return super.getMultiValueInsertMode();
    }

    public String getColumnTypeModifiers(DBPDataSource dataSource, DBSTypedObject column, String typeName, DBPDataKind dataKind) {
        block21: {
            block20: {
                Integer scale;
                if (dataKind != DBPDataKind.DATETIME) break block20;
                if ("datetime2".equalsIgnoreCase(typeName) && (scale = column.getScale()) != null && scale != 0) {
                    return "(" + scale + ')';
                }
                break block21;
            }
            if (dataKind != DBPDataKind.STRING) break block21;
            switch (typeName) {
                case "nvarchar": 
                case "char": 
                case "text": 
                case "nchar": 
                case "ntext": 
                case "varchar": {
                    long maxLength = column.getMaxLength();
                    if (maxLength == 0L) {
                        return null;
                    }
                    if (maxLength == -1L) {
                        return "(MAX)";
                    }
                    return "(" + maxLength + ")";
                }
            }
            return null;
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters) {
        ArrayList inParameters = new ArrayList();
        int maxParamLength = this.getMaxParameterLength(parameters, inParameters);
        String schemaName = proc.getContainer().getParentObject().getName();
        sql.append("USE [").append(schemaName).append("]\n");
        sql.append("GO\n\n");
        sql.append("DECLARE\t@return_value int\n\n");
        sql.append("EXEC\t@return_value = [").append(proc.getContainer().getName()).append("].[").append(proc.getName()).append("]\n");
        int i = 0;
        while (i < inParameters.size()) {
            String name = ((DBSProcedureParameter)inParameters.get(i)).getName();
            sql.append("\t\t").append(name).append(" = :").append(CommonUtils.escapeIdentifier((String)name));
            if (i < inParameters.size() - 1) {
                sql.append(", ");
            } else {
                sql.append(" ");
            }
            int width = maxParamLength + 70 - name.length() / 2;
            String typeName = ((DBSProcedureParameter)inParameters.get(i)).getParameterType().getFullTypeName();
            sql.append(CommonUtils.fixedLengthString((String)("-- put the " + name + " parameter value instead of '?' (" + typeName + ")\n"), (int)width));
            ++i;
        }
        sql.append("\nSELECT\t'Return Value' = @return_value\n\n");
        sql.append("GO\n\n");
    }
}

