/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferErrorJob;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferJob
extends AbstractJob {
    private DataTransferSettings settings;

    public DataTransferJob(DataTransferSettings settings) {
        super(DTMessages.data_transfer_wizard_job_name);
        this.settings = settings;
        this.setUser(true);
    }

    public boolean belongsTo(Object family) {
        return family == this.settings;
    }

    protected IStatus run(DBRProgressMonitor monitor) {
        DataTransferPipe transferPipe;
        boolean hasErrors = false;
        long startTime = System.currentTimeMillis();
        while ((transferPipe = this.settings.acquireDataPipe(monitor)) != null) {
            if (this.transferData(monitor, transferPipe)) continue;
            hasErrors = true;
        }
        this.showResult(System.currentTimeMillis() - startTime, hasErrors);
        return Status.OK_STATUS;
    }

    private void showResult(long time, boolean hasErrors) {
        UIUtils.asyncExec(() -> {
            Display.getCurrent().beep();
            DBPPlatformUI platformUI = DBWorkbench.getPlatformUI();
            if (time > platformUI.getLongOperationTimeout() * 1000L) {
                platformUI.notifyAgent("Data transfer completed", !hasErrors ? 1 : 4);
            }
            if (this.settings.isShowFinalMessage()) {
                UIUtils.showMessageBox(null, (String)DTMessages.data_transfer_wizard_name, (String)("Data transfer completed " + (hasErrors ? "with errors " : "") + "(" + RuntimeUtils.formatExecutionTime((long)time) + ")"), (int)(hasErrors ? 1 : 2));
            }
        });
    }

    private boolean transferData(DBRProgressMonitor monitor, DataTransferPipe transferPipe) {
        IDataTransferProducer producer = transferPipe.getProducer();
        IDataTransferConsumer consumer = transferPipe.getConsumer();
        this.settings.getNodeSettings(consumer);
        this.setName(NLS.bind((String)DTMessages.data_transfer_wizard_job_container_name, (Object)CommonUtils.truncateString((String)producer.getObjectName(), (int)200), (Object)CommonUtils.truncateString((String)consumer.getObjectName(), (int)200)));
        IDataTransferSettings nodeSettings = this.settings.getNodeSettings(producer);
        try {
            IDataTransferProcessor processor = this.settings.getProcessor() == null ? null : this.settings.getProcessor().getInstance();
            producer.transferData(monitor, consumer, processor, nodeSettings);
            consumer.finishTransfer(monitor, false);
            return true;
        }
        catch (Exception e) {
            new DataTransferErrorJob(e).schedule();
            return false;
        }
    }
}

