/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.autorefresh;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.autorefresh.RefreshSettings;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class AutoRefreshConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.AutoRefreshConfigDialog";
    private RefreshSettings refreshSettings;

    AutoRefreshConfigDialog(Shell parentShell, RefreshSettings settings) {
        super(parentShell, "Auto-refresh configuration", (DBPImage)UIIcon.RS_SCHED_START);
        this.refreshSettings = new RefreshSettings(settings);
    }

    public RefreshSettings getRefreshSettings() {
        return this.refreshSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group settingsGroup = UIUtils.createControlGroup(composite, "Settings", 2, 1808, 0);
        final Spinner intervalSpinner = UIUtils.createLabelSpinner((Composite)settingsGroup, "Interval (sec)", "Auto-refresh interval in seconds", this.refreshSettings.getRefreshInterval(), 1, Integer.MAX_VALUE);
        intervalSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoRefreshConfigDialog.this.refreshSettings.setRefreshInterval(intervalSpinner.getSelection());
            }
        });
        final Button stopOnErrorCheck = UIUtils.createCheckbox((Composite)settingsGroup, "Stop on error", "Stop auto-refresh if error happens", this.refreshSettings.isStopOnError(), 2);
        stopOnErrorCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutoRefreshConfigDialog.this.refreshSettings.setStopOnError(stopOnErrorCheck.getSelection());
            }
        });
        return composite;
    }
}

