/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CComboContentAdapter;
import org.jkiss.utils.CommonUtils;

public class CustomComboBoxCellEditor
extends ComboBoxCellEditor {
    private SimpleContentProposalProvider proposalProvider;

    public CustomComboBoxCellEditor(Composite parent, String[] items) {
        super(parent, items);
    }

    public CustomComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, items, style);
    }

    public CustomComboBoxCellEditor(ColumnViewer columnViewer, Composite parent, String[] items, int style) {
        super(parent, items, style);
        this.init(columnViewer);
    }

    private void init(final ColumnViewer columnViewer) {
        CCombo combo = (CCombo)this.getControl();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                columnViewer.applyEditorValue();
            }
        });
    }

    public void setItems(String[] items) {
        super.setItems(items);
        if (this.proposalProvider != null) {
            this.proposalProvider.setProposals(items);
        }
    }

    protected Control createControl(Composite parent) {
        CCombo comboBox = (CCombo)super.createControl(parent);
        comboBox.setVisibleItemCount(15);
        comboBox.setFont(parent.getFont());
        comboBox.setBackground(parent.getDisplay().getSystemColor(25));
        if ((this.getStyle() & 8) == 0) {
            this.proposalProvider = new SimpleContentProposalProvider(comboBox.getItems());
            this.proposalProvider.setFiltering(true);
            UIUtils.installContentProposal((Control)comboBox, new CComboContentAdapter(), (IContentProposalProvider)this.proposalProvider, true, true);
        }
        return comboBox;
    }

    protected Object doGetValue() {
        CCombo comboBox = (CCombo)this.getControl();
        if (comboBox == null || comboBox.isDisposed()) {
            return null;
        }
        return comboBox.getText();
    }

    protected void doSetValue(Object value) {
        CCombo comboBox = (CCombo)this.getControl();
        if (comboBox == null || comboBox.isDisposed()) {
            return;
        }
        if (value == null) {
            comboBox.setText("");
        } else if (value instanceof DBPNamedObject) {
            comboBox.setText(((DBPNamedObject)value).getName());
        } else if (value instanceof Enum) {
            comboBox.setText(((Enum)value).name());
        } else {
            comboBox.setText(CommonUtils.toString((Object)value));
        }
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }
}

