/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.action.DiagramLayoutAction;
import org.jkiss.dbeaver.ext.erd.action.DiagramRefreshAction;
import org.jkiss.dbeaver.ext.erd.action.DiagramToggleGridAction;
import org.jkiss.dbeaver.ext.erd.directedit.StatusLineValidationMessageHandler;
import org.jkiss.dbeaver.ext.erd.dnd.DataEditDropTargetListener;
import org.jkiss.dbeaver.ext.erd.dnd.NodeDropTargetListener;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorContextMenuProvider;
import org.jkiss.dbeaver.ext.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ext.erd.editor.ERDOutlinePage;
import org.jkiss.dbeaver.ext.erd.editor.ERDPalettePreferences;
import org.jkiss.dbeaver.ext.erd.editor.ERDPaletteViewerProvider;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.editor.tools.ChangeZOrderAction;
import org.jkiss.dbeaver.ext.erd.editor.tools.ResetPartColorAction;
import org.jkiss.dbeaver.ext.erd.editor.tools.SetPartColorAction;
import org.jkiss.dbeaver.ext.erd.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.ext.erd.export.ERDExportFormatRegistry;
import org.jkiss.dbeaver.ext.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ext.erd.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectSearcher;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ERDEditorPart
extends GraphicalEditorWithFlyoutPalette
implements DBPDataSourceTask,
ISearchContextProvider,
IRefreshablePart {
    @Nullable
    protected ProgressControl progressControl;
    private PropertySheetPage undoablePropertySheetPage;
    private ScalableFreeformRootEditPart rootPart;
    private List<String> editPartActionIDs = new ArrayList<String>();
    private ERDOutlinePage outlinePage;
    private DefaultEditDomain editDomain;
    private boolean isDirty;
    private boolean isLoaded;
    protected LoadingJob<EntityDiagram> diagramLoadingJob;
    private IPropertyChangeListener configPropertyListener;
    private PaletteRoot paletteRoot;
    private volatile String errorMessage;
    private ERDDecorator decorator;
    private ZoomComboContributionItem zoomCombo;

    protected ERDEditorPart() {
    }

    public ERDDecorator getDecorator() {
        if (this.decorator == null) {
            this.decorator = this.createDecorator();
        }
        return this.decorator;
    }

    protected ERDDecorator createDecorator() {
        return new ERDDecoratorDefault();
    }

    protected ERDGraphicalViewer getGraphicalViewer() {
        return (ERDGraphicalViewer)super.getGraphicalViewer();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.rootPart = new ScalableFreeformRootEditPart();
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(this.editDomain);
        super.init(site, input);
        this.configPropertyListener = new ConfigPropertyListener();
        ERDActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.configPropertyListener);
    }

    public void createPartControl(Composite parent) {
        Composite contentContainer = parent;
        if (this.hasProgressControl()) {
            this.progressControl = new ProgressControl(parent, 0x10000000);
            this.progressControl.setShowDivider(true);
            contentContainer = this.progressControl.createContentContainer();
        } else {
            this.isLoaded = true;
        }
        super.createPartControl(contentContainer);
        if (this.hasProgressControl()) {
            this.progressControl.createProgressPanel();
        }
    }

    public void commandStackChanged(EventObject event) {
        ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.ext.erd.editor.canUndo");
        ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.ext.erd.editor.canRedo");
        this.setDirty(this.getCommandStack().isDirty());
        super.commandStackChanged(event);
    }

    public void dispose() {
        ERDActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.configPropertyListener);
        if (this.diagramLoadingJob != null) {
            this.diagramLoadingJob.cancel();
            this.diagramLoadingJob = null;
        }
        this.getActionRegistry().dispose();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == CommandStack.class) {
            return this.getCommandStack();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        if (adapter == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "ERD Editor";
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        this.saveDiagramAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return !this.isReadOnly() && this.isDirty;
    }

    public abstract boolean isReadOnly();

    protected boolean hasProgressControl() {
        return true;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public EntityDiagram getDiagram() {
        return this.getDiagramPart().getDiagram();
    }

    public DiagramPart getDiagramPart() {
        return this.rootPart == null ? null : (DiagramPart)this.rootPart.getContents();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new ERDPaletteViewerProvider((EditDomain)this.editDomain);
    }

    public GraphicalViewer getViewer() {
        return super.getGraphicalViewer();
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalViewer viewer = this.createViewer(parent);
        this.setGraphicalViewer(viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        viewer.setContents((Object)new EntityDiagram(this.getDecorator(), null, "empty"));
        ERDEditorContextMenuProvider provider = new ERDEditorContextMenuProvider(this);
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(String.valueOf(ERDEditorPart.class.getName()) + ".EditorContext", (MenuManager)provider, (ISelectionProvider)viewer);
    }

    private GraphicalViewer createViewer(Composite parent) {
        StatusLineValidationMessageHandler validationMessageHandler = new StatusLineValidationMessageHandler(this.getEditorSite());
        ERDGraphicalViewer viewer = new ERDGraphicalViewer(this, validationMessageHandler);
        viewer.createControl(parent);
        viewer.getControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        viewer.setRootEditPart((RootEditPart)this.rootPart);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)viewer));
        this.registerDropTargetListeners((GraphicalViewer)viewer);
        viewer.setEditPartFactory(this.getDecorator().createPartFactory());
        return viewer;
    }

    protected void registerDropTargetListeners(GraphicalViewer viewer) {
        viewer.addDropTargetListener((TransferDropTargetListener)new DataEditDropTargetListener((EditPartViewer)viewer));
        viewer.addDropTargetListener((TransferDropTargetListener)new NodeDropTargetListener((EditPartViewer)viewer));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        ERDGraphicalViewer graphicalViewer = this.getGraphicalViewer();
        IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
        graphicalViewer.setProperty("SnapToGrid.isEnabled", store.getBoolean("erd.grid.enabled"));
        graphicalViewer.setProperty("SnapToGrid.isVisible", store.getBoolean("erd.grid.enabled"));
        graphicalViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(store.getInt("erd.grid.width"), store.getInt("erd.grid.height")));
        this.createActions();
        ZoomManager zoomManager = this.rootPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        zoomManager.setZoomLevels(new double[]{0.1, 0.1, 0.2, 0.3, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.5, 3.0, 4.0});
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        this.addAction((IAction)zoomIn);
        this.addAction((IAction)zoomOut);
        graphicalViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            String status = selection.isEmpty() ? "" : (selection.size() == 1 ? CommonUtils.toString((Object)selection.getFirstElement()) : String.valueOf(String.valueOf(selection.size())) + " objects");
            if (this.progressControl != null) {
                this.progressControl.setInfo(status);
            }
            this.updateActions(this.editPartActionIDs);
        });
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
        UIUtils.registerKeyBinding((IServiceLocator)this.getSite(), (IAction)action);
    }

    protected void updateActions(List actionIds) {
        for (Object actionId : actionIds) {
            IAction action = this.getActionRegistry().getAction(actionId);
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected ERDOutlinePage getOverviewOutlinePage() {
        RootEditPart rootEditPart;
        if (this.outlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.outlinePage = new ERDOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.outlinePage;
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            this.undoablePropertySheetPage.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(this.getCommandStack()));
        }
        return this.undoablePropertySheetPage;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new ERDPalettePreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.setLabel("Entity Diagram");
        this.getDecorator().fillPalette(paletteRoot, this.isReadOnly());
        return paletteRoot;
    }

    protected FlyoutPaletteComposite createPaletteComposite(Composite parent) {
        FlyoutPaletteComposite paletteComposite = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
        paletteComposite.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        return paletteComposite;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void refreshDiagram(boolean force, boolean refreshMetadata) {
        if (this.isLoaded && force) {
            this.loadDiagram(refreshMetadata);
        }
    }

    public void refreshPart(Object source, boolean force) {
        this.refreshDiagram(force, true);
    }

    public void saveDiagramAs() {
        List<ERDExportFormatRegistry.FormatDescriptor> allFormats = ERDExportFormatRegistry.getInstance().getFormats();
        String[] extensions = new String[allFormats.size()];
        String[] filterNames = new String[allFormats.size()];
        int i = 0;
        while (i < allFormats.size()) {
            extensions[i] = "*." + allFormats.get(i).getExtension();
            filterNames[i] = String.valueOf(allFormats.get(i).getLabel()) + " (" + extensions[i] + ")";
            ++i;
        }
        Shell shell = this.getSite().getShell();
        FileDialog saveDialog = new FileDialog(shell, 8192);
        saveDialog.setFilterExtensions(extensions);
        saveDialog.setFilterNames(filterNames);
        String filePath = DialogUtils.openFileDialog((FileDialog)saveDialog);
        if (filePath == null || filePath.trim().length() == 0) {
            return;
        }
        File outFile = new File(filePath);
        if (outFile.exists() && !UIUtils.confirmAction((Shell)shell, (String)"Overwrite file", (String)("File '" + filePath + "' already exists.\nOverwrite?"))) {
            return;
        }
        int divPos = filePath.lastIndexOf(46);
        if (divPos == -1) {
            DBWorkbench.getPlatformUI().showError("ERD export", "No file extension was specified");
            return;
        }
        String ext = filePath.substring(divPos + 1);
        ERDExportFormatRegistry.FormatDescriptor targetFormat = null;
        for (ERDExportFormatRegistry.FormatDescriptor format : allFormats) {
            if (!format.getExtension().equals(ext)) continue;
            targetFormat = format;
            break;
        }
        if (targetFormat == null) {
            DBWorkbench.getPlatformUI().showError("ERD export", "No export format correspond to file extension '" + ext + "'");
            return;
        }
        try {
            ERDExportFormatHandler formatHandler = targetFormat.getInstance();
            IFigure figure = this.rootPart.getLayer((Object)"Printable Layers");
            formatHandler.exportDiagram(this.getDiagram(), figure, this.getDiagramPart(), outFile);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("ERD export failed", null, (Throwable)e);
        }
    }

    public void fillAttributeVisibilityMenu(IMenuManager menu) {
        MenuManager asMenu = new MenuManager(ERDMessages.menu_view_style);
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDViewStyle.ICONS));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDViewStyle.TYPES));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDViewStyle.NULLABILITY));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDViewStyle.COMMENTS));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDViewStyle.ENTITY_FQN));
        menu.add((IContributionItem)asMenu);
        if (this.getDiagram().getDecorator().supportsAttributeVisibility()) {
            MenuManager avMenu = new MenuManager(ERDMessages.menu_attribute_visibility);
            avMenu.add((IAction)new EmptyAction(ERDMessages.menu_attribute_visibility_default));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.ALL));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.KEYS));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.PRIMARY));
            avMenu.add((IAction)new ChangeAttributeVisibilityAction(true, ERDAttributeVisibility.NONE));
            ISelection selection = this.getGraphicalViewer().getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                int totalEntities = 0;
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof EntityPart) {
                        ++totalEntities;
                    }
                    ++n2;
                }
                if (totalEntities > 0) {
                    avMenu.add((IContributionItem)new Separator());
                    String avaTitle = ERDMessages.menu_attribute_visibility_entity;
                    avaTitle = ((IStructuredSelection)selection).size() == 1 ? String.valueOf(avaTitle) + " (" + ((IStructuredSelection)selection).getFirstElement() + ")" : String.valueOf(avaTitle) + " (" + totalEntities + ")";
                    avMenu.add((IAction)new EmptyAction(avaTitle));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.ALL));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.KEYS));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.PRIMARY));
                    avMenu.add((IAction)new ChangeAttributeVisibilityAction(false, ERDAttributeVisibility.NONE));
                }
            }
            menu.add((IContributionItem)avMenu);
        }
    }

    public void fillPartContextMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        menu.add((IAction)new ChangeZOrderAction(this, selection, true));
        menu.add((IAction)new ChangeZOrderAction(this, selection, false));
        menu.add((IAction)new SetPartColorAction(this, selection));
        ResetPartColorAction resetPartColorAction = new ResetPartColorAction(this, selection);
        if (resetPartColorAction.isEnabled()) {
            menu.add((IAction)resetPartColorAction);
        }
    }

    public void printDiagram() {
        IFigure rootFigure;
        ERDGraphicalViewer viewer = this.getGraphicalViewer();
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null && (rootFigure = this.rootPart.getLayer((Object)"Printable Layers")) != null) {
            PrintFigureOperation printOp = new PrintFigureOperation(new Printer(data), rootFigure);
            IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
            printOp.setPrintMode(store.getInt("erd.print.page-mode"));
            printOp.setPrintMargin(new Insets(store.getInt("erd.print.margin-top"), store.getInt("erd.print.margin-left"), store.getInt("erd.print.margin-bottom"), store.getInt("erd.print.margin-right")));
            printOp.run("Print ER diagram");
        }
    }

    public boolean isSearchPossible() {
        return true;
    }

    public boolean isSearchEnabled() {
        return this.progressControl != null && this.progressControl.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        return this.progressControl != null && this.progressControl.performSearch(searchType);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected void fillDefaultEditorContributions(IContributionManager toolBarManager) {
        ZoomManager zoomManager = this.rootPart.getZoomManager();
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        this.zoomCombo = new ZoomComboContributionItem(new IPartService(){

            public void addPartListener(IPartListener listener) {
            }

            public void addPartListener(IPartListener2 listener) {
            }

            public IWorkbenchPart getActivePart() {
                return ERDEditorPart.this;
            }

            public IWorkbenchPartReference getActivePartReference() {
                return null;
            }

            public void removePartListener(IPartListener listener) {
            }

            public void removePartListener(IPartListener2 listener) {
            }
        }, zoomStrings);
        this.zoomCombo.setZoomManager(zoomManager);
        toolBarManager.add((IContributionItem)this.zoomCombo);
        ZoomInAction zoomInAction = new ZoomInAction(zoomManager);
        zoomInAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_IN));
        ZoomOutAction zoomOutAction = new ZoomOutAction(zoomManager);
        zoomOutAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.ZOOM_OUT));
        toolBarManager.add((IAction)zoomInAction);
        toolBarManager.add((IAction)zoomOutAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new DiagramLayoutAction(this));
        toolBarManager.add((IAction)new DiagramToggleGridAction());
        toolBarManager.add((IAction)new DiagramRefreshAction(this));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.file.saveAs", (String)ERDMessages.erd_editor_control_action_save_external_format, (DBPImage)UIIcon.PICTURE_SAVE));
        toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.eclipse.ui.file.print", (String)ERDMessages.erd_editor_control_action_print_diagram, (DBPImage)UIIcon.PRINT));
        Action configAction = new Action(ERDMessages.erd_editor_control_action_configuration){

            public void run() {
                UIUtils.showPreferencesFor((Shell)ERDEditorPart.this.getSite().getShell(), (Object)((Object)ERDEditorPart.this), (String[])new String[]{"org.jkiss.dbeaver.preferences.erd.general"});
            }
        };
        configAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        toolBarManager.add((IAction)configAction);
    }

    protected abstract void loadDiagram(boolean var1);

    public boolean isActiveTask() {
        return this.diagramLoadingJob != null && this.diagramLoadingJob.getState() == 4;
    }

    private class ChangeAttributePresentationAction
    extends Action {
        private final ERDViewStyle style;

        public ChangeAttributePresentationAction(ERDViewStyle style) {
            super("Show " + style.getTitle(), 2);
            this.style = style;
        }

        public boolean isChecked() {
            return ArrayUtils.contains((Object[])ERDViewStyle.getDefaultStyles(ERDActivator.getDefault().getPreferenceStore()), (Object)((Object)this.style));
        }

        public void run() {
            ERDEditorPart.this.getDiagram().setAttributeStyle(this.style, !this.isChecked());
            ERDEditorPart.this.refreshDiagram(true, false);
        }
    }

    private class ChangeAttributeVisibilityAction
    extends Action {
        private final boolean defStyle;
        private final ERDAttributeVisibility visibility;

        private ChangeAttributeVisibilityAction(boolean defStyle, ERDAttributeVisibility visibility) {
            super(String.valueOf(visibility.getTitle()), 2);
            this.defStyle = defStyle;
            this.visibility = visibility;
        }

        public boolean isChecked() {
            if (this.defStyle) {
                return this.visibility == ERDEditorPart.this.getDiagram().getAttributeVisibility();
            }
            Object[] objectArray = ((IStructuredSelection)ERDEditorPart.this.getGraphicalViewer().getSelection()).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EntityPart) {
                    ERDAttributeVisibility entityAV = ((EntityPart)object).getEntity().getAttributeVisibility();
                    if (entityAV == null) {
                        return this.visibility == ERDEditorPart.this.getDiagram().getAttributeVisibility();
                    }
                    if (entityAV == this.visibility) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        public void runWithEvent(Event event) {
            super.runWithEvent(event);
        }

        public void run() {
            EntityDiagram diagram = ERDEditorPart.this.getDiagram();
            if (this.defStyle) {
                diagram.setAttributeVisibility(this.visibility);
                for (ERDEntity entity : diagram.getEntities()) {
                    entity.reloadAttributes(diagram);
                }
            } else {
                Object[] objectArray = ((IStructuredSelection)ERDEditorPart.this.getGraphicalViewer().getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof EntityPart) {
                        ((EntityPart)object).getEntity().setAttributeVisibility(this.visibility);
                        UIUtils.asyncExec(() -> ((EntityPart)object).getEntity().reloadAttributes(diagram));
                    }
                    ++n2;
                }
            }
            UIUtils.asyncExec(() -> ERDEditorPart.this.getGraphicalViewer().setContents(diagram));
        }
    }

    private class ConfigPropertyListener
    implements IPropertyChangeListener {
        private ConfigPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ERDGraphicalViewer graphicalViewer = ERDEditorPart.this.getGraphicalViewer();
            if (graphicalViewer == null) {
                return;
            }
            if ("erd.grid.enabled".equals(event.getProperty())) {
                Boolean enabled = Boolean.valueOf(event.getNewValue().toString());
                graphicalViewer.setProperty("SnapToGrid.isEnabled", enabled);
                graphicalViewer.setProperty("SnapToGrid.isVisible", enabled);
            } else if ("erd.grid.width".equals(event.getProperty()) || "erd.grid.height".equals(event.getProperty())) {
                IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
                graphicalViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(store.getInt("erd.grid.width"), store.getInt("erd.grid.height")));
            }
        }
    }

    protected class ProgressControl
    extends ProgressPageControl {
        private Searcher searcher;

        private ProgressControl(Composite parent, int style) {
            super(parent, style);
            this.searcher = new Searcher();
        }

        protected boolean cancelProgress() {
            if (ERDEditorPart.this.diagramLoadingJob != null) {
                ERDEditorPart.this.diagramLoadingJob.cancel();
                return true;
            }
            return false;
        }

        public ProgressPageControl.ProgressVisualizer<EntityDiagram> createLoadVisualizer() {
            ERDEditorPart.this.getGraphicalControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
            return new LoadVisualizer();
        }

        public void fillCustomActions(IContributionManager toolBarManager) {
            ERDEditorPart.this.fillDefaultEditorContributions(toolBarManager);
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        private class LoadVisualizer
        extends ProgressPageControl.ProgressVisualizer<EntityDiagram> {
            private LoadVisualizer() {
                super((ProgressPageControl)ProgressControl.this);
            }

            public void visualizeLoading() {
                super.visualizeLoading();
            }

            public void completeLoading(EntityDiagram entityDiagram) {
                super.completeLoading((Object)entityDiagram);
                Control graphicalControl = ERDEditorPart.this.getGraphicalControl();
                if (graphicalControl == null) {
                    return;
                }
                graphicalControl.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
                ERDEditorPart.this.isLoaded = true;
                Control control = ERDEditorPart.this.getGraphicalViewer().getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                if (entityDiagram != null) {
                    List<String> errorMessages = entityDiagram.getErrorMessages();
                    if (!errorMessages.isEmpty()) {
                        ArrayList<Status> messageStatuses = new ArrayList<Status>(errorMessages.size());
                        for (String error : errorMessages) {
                            messageStatuses.add(new Status(4, DBeaverCore.getCorePluginID(), error));
                        }
                        MultiStatus status = new MultiStatus(DBeaverCore.getCorePluginID(), 0, messageStatuses.toArray(new IStatus[messageStatuses.size()]), null, null);
                        DBWorkbench.getPlatformUI().showError("Diagram loading errors", "Error(s) occurred during diagram loading. If these errors are recoverable then fix errors and then refresh/reopen diagram", (IStatus)status);
                    }
                    ProgressControl.this.setInfo(String.valueOf(entityDiagram.getEntityCount()) + " objects");
                } else {
                    ProgressControl.this.setInfo("Empty diagram due to error (see error log)");
                }
                ERDEditorPart.this.getCommandStack().flush();
                ERDEditorPart.this.getGraphicalViewer().setContents(entityDiagram);
                if (ERDEditorPart.this.zoomCombo != null) {
                    ERDEditorPart.this.zoomCombo.setZoomManager(ERDEditorPart.this.rootPart.getZoomManager());
                }
            }
        }
    }

    private class Searcher
    extends ObjectSearcher<DBPNamedObject> {
        private Searcher() {
        }

        protected void setInfo(String message) {
            ERDEditorPart.this.progressControl.setInfo(message);
        }

        protected Collection<DBPNamedObject> getContent() {
            return ERDEditorPart.this.getDiagramPart().getChildren();
        }

        protected void selectObject(DBPNamedObject object) {
            if (object == null) {
                ERDEditorPart.this.getGraphicalViewer().deselectAll();
            } else {
                ERDEditorPart.this.getGraphicalViewer().select((EditPart)object);
            }
        }

        protected void updateObject(DBPNamedObject object) {
        }

        protected void revealObject(DBPNamedObject object) {
            ERDEditorPart.this.getGraphicalViewer().reveal((EditPart)object);
        }
    }
}

