/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MonitorMemoryBlockDialog
extends TrayDialog
implements ModifyListener {
    private Combo expressionInput;
    private Text lengthInput;
    private String expression;
    private String length;
    private boolean needLength = true;
    private String fPrefillExp = null;
    private String fPrefillLength = null;
    private static final int LABEL_WIDTH = 210;

    public MonitorMemoryBlockDialog(Shell parentShell, IMemoryBlockRetrieval memRetrieval, String prefillExp, String prefillLength) {
        super(parentShell);
        if (memRetrieval instanceof IMemoryBlockRetrievalExtension) {
            this.needLength = false;
        }
        this.fPrefillExp = prefillExp;
        this.fPrefillLength = prefillLength;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        SWTFactory.createWrapLabel(comp, DebugUIMessages.MonitorMemoryBlockDialog_EnterExpressionToMonitor, 1, 210);
        this.expressionInput = SWTFactory.createCombo(comp, 2048, 1, MemoryViewUtil.getHistory());
        if (this.fPrefillExp != null) {
            this.expressionInput.setText(this.fPrefillExp);
        }
        this.expressionInput.addModifyListener((ModifyListener)this);
        if (this.needLength) {
            SWTFactory.createLabel(comp, DebugUIMessages.MonitorMemoryBlockDialog_NumberOfBytes, 1);
            this.lengthInput = SWTFactory.createSingleText(comp, 1);
            if (this.fPrefillLength != null) {
                this.lengthInput.setText(this.fPrefillLength);
            }
            this.lengthInput.addModifyListener((ModifyListener)this);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.MonitorMemoryBlockDialog_context");
        return comp;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DebugUIMessages.MonitorMemoryBlockDialog_MonitorMemory);
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLength() {
        return this.length;
    }

    protected void okPressed() {
        this.expression = this.expressionInput.getText();
        MemoryViewUtil.addHistory(this.expression);
        if (this.needLength) {
            this.length = this.lengthInput.getText();
        }
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        this.updateOKButtonState();
    }

    private void updateOKButtonState() {
        if (this.needLength) {
            String lengthText = this.lengthInput.getText();
            String input = this.expressionInput.getText();
            if (input == null || input.equals("") || lengthText == null || lengthText.equals("")) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control ret = super.createButtonBar(parent);
        if (this.needLength) {
            this.updateOKButtonState();
        } else {
            this.getButton(0).setEnabled(true);
        }
        return ret;
    }
}

