/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;

public class NavigatorHandlerObjectDelete
extends NavigatorHandlerObjectBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerObjectDelete.class);
    private IStructuredSelection structSelection;
    private Boolean deleteAll;
    private Map<String, Object> deleteOptions = new HashMap<String, Object>();
    private List<DBRRunnableWithProgress> tasksToExecute = new ArrayList<DBRRunnableWithProgress>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.structSelection = null;
        this.deleteAll = null;
        this.deleteOptions.clear();
        this.tasksToExecute.clear();
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.structSelection = (IStructuredSelection)selection;
            for (Object element : this.structSelection) {
                if (element instanceof DBNDatabaseNode) {
                    this.deleteObject(activeWorkbenchWindow, (DBNDatabaseNode)element);
                } else if (element instanceof DBNResource) {
                    this.deleteResource(activeWorkbenchWindow, (DBNResource)element);
                } else if (element instanceof DBNLocalFolder) {
                    this.deleteLocalFolder(activeWorkbenchWindow, (DBNLocalFolder)element);
                } else {
                    log.warn((Object)("Don't know how to delete element '" + element + "'"));
                }
                if (this.deleteAll != null && !this.deleteAll.booleanValue()) break;
            }
        }
        if (!this.tasksToExecute.isEmpty()) {
            TasksJob.runTasks((String)(this.tasksToExecute.size() > 1 ? "Delete " + this.tasksToExecute.size() + " objects" : "Delete object"), this.tasksToExecute);
            this.tasksToExecute.clear();
        }
        return null;
    }

    private void deleteLocalFolder(IWorkbenchWindow workbenchWindow, DBNLocalFolder localFolder) {
        ConfirmResult confirmResult = this.confirmObjectDelete(workbenchWindow, (DBNNode)localFolder, false, null, false);
        if (confirmResult == ConfirmResult.NO) {
            return;
        }
        localFolder.getDataSourceRegistry().removeFolder(localFolder.getFolder(), false);
        DBNModel.updateConfigAndRefreshDatabases((DBNNode)localFolder);
    }

    private boolean deleteResource(IWorkbenchWindow workbenchWindow, DBNResource resourceNode) {
        ConfirmResult confirmResult = this.confirmObjectDelete(workbenchWindow, (DBNNode)resourceNode, false, null, false);
        if (confirmResult == ConfirmResult.NO) {
            return false;
        }
        IResource resource = resourceNode.getResource();
        try {
            if (resource instanceof IFolder) {
                ((IFolder)resource).delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else if (resource instanceof IProject) {
                boolean deleteContent = UIUtils.confirmAction((Shell)workbenchWindow.getShell(), (String)"Delete project", (String)("Delete project '" + resource.getName() + "' contents?"));
                ((IProject)resource).delete(deleteContent, true, (IProgressMonitor)new NullProgressMonitor());
            } else if (resource != null) {
                resource.delete(3, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    private boolean deleteObject(IWorkbenchWindow workbenchWindow, DBNDatabaseNode node) {
        ConfirmResult confirmResult;
        NavigatorHandlerObjectBase.CommandTarget commandTarget;
        DBEObjectMaker objectMaker;
        block12: {
            boolean supportsCascade;
            block11: {
                try {
                    if (!(node.getParentNode() instanceof DBNContainer)) {
                        throw new DBException("Node '" + node + "' doesn't have a container");
                    }
                    DBNContainer container = (DBNContainer)node.getParentNode();
                    DBSObject object = node.getObject();
                    if (object == null) {
                        throw new DBException("Can't delete node with null object");
                    }
                    objectMaker = (DBEObjectMaker)DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(object.getClass(), DBEObjectMaker.class);
                    if (objectMaker == null) {
                        throw new DBException("Object maker not found for type '" + object.getClass().getName() + "'");
                    }
                    supportsCascade = (objectMaker.getMakerOptions(object.getDataSource()) & 8L) != 0L;
                    commandTarget = NavigatorHandlerObjectDelete.getCommandTarget(workbenchWindow, container, object.getClass(), false);
                    if (this.deleteAll == null || !this.deleteAll.booleanValue()) {
                        this.deleteOptions.clear();
                    }
                    confirmResult = ConfirmResult.YES;
                    if (object.isPersisted() && commandTarget.getEditor() == null) break block11;
                    if (this.deleteNewObject(workbenchWindow, node)) {
                        return true;
                    }
                    break block12;
                }
                catch (Throwable e) {
                    DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_error_dialog_delete_object_title, "Can't delete object '" + node.getNodeName() + "'", e);
                    return false;
                }
            }
            confirmResult = this.confirmObjectDelete(workbenchWindow, (DBNNode)node, supportsCascade, this.deleteOptions, commandTarget.getContext() != null && commandTarget.getEditor() == null);
            if (confirmResult != ConfirmResult.NO) break block12;
            return false;
        }
        objectMaker.deleteObject(commandTarget.getContext(), node.getObject(), this.deleteOptions);
        if (confirmResult == ConfirmResult.DETAILS && !NavigatorHandlerObjectDelete.showScript(workbenchWindow, commandTarget.getContext(), this.deleteOptions, UINavigatorMessages.actions_navigator_delete_script)) {
            commandTarget.getContext().resetChanges(true);
            return this.deleteObject(workbenchWindow, node);
        }
        if (commandTarget.getEditor() == null && commandTarget.getContext() != null) {
            NavigatorHandlerObjectBase.ObjectSaver deleter = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), this.deleteOptions);
            this.tasksToExecute.add(deleter);
        }
        return true;
    }

    private boolean deleteNewObject(IWorkbenchWindow workbenchWindow, DBNDatabaseNode node) throws DBException {
        IEditorReference[] iEditorReferenceArray = workbenchWindow.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDatabaseEditorInput editorInput;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editor = editorRef.getEditor(false);
            if (editor instanceof IDatabaseEditor && (editorInput = ((IDatabaseEditor)editor).getEditorInput()).getDatabaseObject() == node.getObject()) {
                ConfirmResult confirmResult = this.confirmObjectDelete(workbenchWindow, (DBNNode)node, false, null, false);
                if (confirmResult == ConfirmResult.NO) {
                    return true;
                }
                workbenchWindow.getActivePage().closeEditor(editor, false);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ConfirmResult confirmObjectDelete(IWorkbenchWindow workbenchWindow, DBNNode node, boolean supportsCascade, @Nullable Map<String, Object> deleteOptions, boolean viewScript) {
        if (this.deleteAll != null) {
            return this.deleteAll != false ? ConfirmResult.YES : ConfirmResult.NO;
        }
        DeleteConfirmDialog dialog = new DeleteConfirmDialog(workbenchWindow, node, supportsCascade, viewScript);
        int result = dialog.open();
        if (deleteOptions != null && supportsCascade && dialog.cascadeCheck) {
            deleteOptions.put("deleteCascade", Boolean.TRUE);
        }
        switch (result) {
            case 2: {
                return ConfirmResult.YES;
            }
            case 4: {
                this.deleteAll = true;
                return ConfirmResult.YES;
            }
            case 3: {
                return ConfirmResult.NO;
            }
            case -1: 
            case 1: {
                this.deleteAll = false;
                return ConfirmResult.NO;
            }
            case 13: {
                return ConfirmResult.DETAILS;
            }
        }
        log.warn((Object)("Unsupported confirmation dialog result: " + result));
        return ConfirmResult.NO;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (!updateUI) {
            return;
        }
    }

    static enum ConfirmResult {
        YES,
        NO,
        DETAILS;

    }

    private class DeleteConfirmDialog
    extends MessageDialog {
        private final boolean supportsCascade;
        private final boolean viewScript;
        private boolean cascadeCheck;

        DeleteConfirmDialog(IWorkbenchWindow workbenchWindow, DBNNode node, boolean supportsCascade, boolean viewScript) {
            super(workbenchWindow.getShell(), NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_title : UINavigatorMessages.confirm_entity_delete_title), (Object)node.getNodeType(), (Object)node.getNodeName()), DBeaverIcons.getImage((DBPImage)UIIcon.REJECT), NLS.bind((String)(node instanceof DBNLocalFolder ? UINavigatorMessages.confirm_local_folder_delete_message : UINavigatorMessages.confirm_entity_delete_message), (Object)node.getNodeType(), (Object)node.getNodeName()), 5, null, 0);
            this.supportsCascade = supportsCascade;
            this.viewScript = viewScript;
        }

        protected Control createCustomArea(Composite parent) {
            if (this.supportsCascade) {
                Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
                final Button cascadeCheckButton = UIUtils.createCheckbox((Composite)ph, (String)"Cascade delete", (String)"Delete all dependent/child objects", (boolean)false, (int)0);
                cascadeCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DeleteConfirmDialog.this.cascadeCheck = cascadeCheckButton.getSelection();
                    }
                });
            }
            return super.createCustomArea(parent);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
            if (NavigatorHandlerObjectDelete.this.structSelection.size() > 1) {
                this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            }
            if (this.viewScript) {
                this.createButton(parent, 13, UINavigatorMessages.actions_navigator_view_script_button, false);
            }
        }
    }
}

