/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerProjectCreate;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class NavigatorHandlerObjectCreateBase
extends NavigatorHandlerObjectBase {
    protected boolean createNewObject(IWorkbenchWindow workbenchWindow, DBNNode element, DBNDatabaseNode copyFrom) {
        try {
            DBNContainer container = null;
            if (element instanceof DBNContainer && !(element instanceof DBNDataSource)) {
                container = (DBNContainer)element;
            } else {
                DBNNode parentNode = element.getParentNode();
                if (parentNode instanceof DBNContainer) {
                    container = (DBNContainer)parentNode;
                }
            }
            if (container == null) {
                throw new DBException("Can't detect container for '" + element.getNodeName() + "'");
            }
            Class childType = container.getChildrenClass();
            if (childType == null) {
                throw new DBException("Can't determine child element type for container '" + container + "'");
            }
            if (childType == IProject.class) {
                return NavigatorHandlerProjectCreate.createNewProject(workbenchWindow);
            }
            DBSObject sourceObject = copyFrom == null ? null : copyFrom.getObject();
            DBEObjectManager objectManager = DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(childType);
            if (objectManager == null) {
                throw new DBException("Object manager not found for type '" + childType.getName() + "'");
            }
            DBEObjectMaker objectMaker = (DBEObjectMaker)objectManager;
            DBPDataSource dataSource = container instanceof DBNDatabaseNode ? ((DBNDatabaseNode)container).getDataSource() : null;
            boolean openEditor = dataSource != null && (objectMaker.getMakerOptions(dataSource) & 4L) != 0L;
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectCreateBase.getCommandTarget(workbenchWindow, container, childType, openEditor);
            Object parentObject = container.getValueObject();
            if (!(parentObject instanceof DBPObject)) {
                throw new DBException("Parent object type is not supported: " + parentObject);
            }
            this.createDatabaseObject(commandTarget, objectMaker, (DBPObject)parentObject, sourceObject);
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Create object", null, e);
            return false;
        }
        return true;
    }

    private <OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject> void createDatabaseObject(NavigatorHandlerObjectBase.CommandTarget commandTarget, DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, CONTAINER_TYPE parentObject, DBSObject sourceObject) throws DBException {
        ObjectCreator<OBJECT_TYPE, CONTAINER_TYPE> objectCreator = new ObjectCreator<OBJECT_TYPE, CONTAINER_TYPE>(objectMaker, commandTarget, parentObject, sourceObject);
        try {
            UIUtils.runInProgressService(objectCreator);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("New object", "Error creating new object", (Throwable)e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        CreateJob<DBSObject, CONTAINER_TYPE> job = new CreateJob<DBSObject, CONTAINER_TYPE>(commandTarget, objectMaker, parentObject, sourceObject, ((ObjectCreator)objectCreator).newObject);
        job.schedule();
    }

    static class CreateJob<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject>
    extends AbstractJob {
        private final NavigatorHandlerObjectBase.CommandTarget commandTarget;
        private final DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker;
        private final CONTAINER_TYPE parentObject;
        private final DBSObject sourceObject;
        private OBJECT_TYPE newObject;

        public CreateJob(NavigatorHandlerObjectBase.CommandTarget commandTarget, DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, CONTAINER_TYPE parentObject, DBSObject sourceObject, OBJECT_TYPE newObject) {
            super("Create new database object with " + objectMaker.getClass().getSimpleName());
            this.setUser(true);
            this.setSystem(false);
            this.commandTarget = commandTarget;
            this.objectMaker = objectMaker;
            this.parentObject = parentObject;
            this.sourceObject = sourceObject;
            this.newObject = newObject;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (this.newObject == null) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Save " + this.newObject.getClass().getSimpleName(), 3);
            try {
                if (this.parentObject instanceof DBSObject && (this.objectMaker.getMakerOptions(((DBSObject)this.parentObject).getDataSource()) & 1L) != 0L) {
                    monitor.subTask("Save object");
                    this.commandTarget.getContext().saveChanges(monitor, DBPScriptObject.EMPTY_OPTIONS);
                    monitor.worked(2);
                    if (this.newObject instanceof DBPRefreshableObject) {
                        monitor.subTask("Load object from server");
                        DBNDatabaseNode newChild = DBWorkbench.getPlatform().getNavigatorModel().findNode(this.newObject);
                        if (newChild != null) {
                            newChild.refreshNode(monitor, (Object)this);
                            this.newObject = newChild.getObject();
                        }
                        monitor.worked(1);
                    }
                }
                monitor.subTask("Obtain new object node");
                int i = 0;
                while (i < 50) {
                    if (monitor.isCanceled() || DBWorkbench.getPlatform().getNavigatorModel().findNode(this.newObject) != null) break;
                    RuntimeUtils.pause((int)100);
                    ++i;
                }
                monitor.worked(1);
                this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        UIUtils.syncExec(() -> this.openNewObject());
                    }
                });
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private void openNewObject() {
            block7: {
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                try {
                    DBNDatabaseNode newChild = DBWorkbench.getPlatform().getNavigatorModel().findNode(this.newObject);
                    if (newChild != null) {
                        DatabaseNavigatorView view = (DatabaseNavigatorView)UIUtils.findView((IWorkbenchWindow)workbenchWindow, DatabaseNavigatorView.class);
                        if (view != null) {
                            view.showNode((DBNNode)newChild);
                        }
                        boolean openEditor = this.parentObject instanceof DBSObject && (this.objectMaker.getMakerOptions(((DBSObject)this.parentObject).getDataSource()) & 4L) != 0L;
                        IDatabaseEditor editor = this.commandTarget.getEditor();
                        if (editor != null) {
                            workbenchWindow.getActivePage().activate((IWorkbenchPart)editor);
                        } else if (openEditor) {
                            DatabaseNodeEditorInput editorInput = new DatabaseNodeEditorInput(newChild, this.commandTarget.getContext());
                            workbenchWindow.getActivePage().openEditor((IEditorInput)editorInput, EntityEditor.class.getName());
                        }
                        break block7;
                    }
                    throw new DBException("Can't find node corresponding to new object");
                }
                catch (Throwable e) {
                    DBWorkbench.getPlatformUI().showError("Create object", null, e);
                }
            }
        }
    }

    private static class ObjectCreator<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject>
    implements DBRRunnableWithProgress {
        private final DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker;
        private final NavigatorHandlerObjectBase.CommandTarget commandTarget;
        private final CONTAINER_TYPE parentObject;
        private final DBSObject sourceObject;
        private OBJECT_TYPE newObject;

        public ObjectCreator(DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, NavigatorHandlerObjectBase.CommandTarget commandTarget, CONTAINER_TYPE parentObject, DBSObject sourceObject) {
            this.objectMaker = objectMaker;
            this.commandTarget = commandTarget;
            this.parentObject = parentObject;
            this.sourceObject = sourceObject;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.newObject = this.objectMaker.createNewObject(monitor, this.commandTarget.getContext(), this.parentObject, (Object)this.sourceObject);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

