/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DBVModel
extends DBVContainer {
    private static final String TAG_CONTAINER = "container";
    private static final String TAG_ENTITY = "entity";
    private static final String TAG_CONSTRAINT = "constraint";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_CUSTOM = "custom";
    private static final String TAG_PROPERTY = "property";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TYPE = "type";
    private static final String TAG_COLORS = "colors";
    private static final String TAG_COLOR = "color";
    private static final String ATTR_OPERATOR = "operator";
    private static final String ATTR_FOREGROUND = "foreground";
    private static final String ATTR_BACKGROUND = "background";
    private static final String TAG_VALUE = "value";
    private static final String TAG_TRANSFORM = "transform";
    private static final String TAG_INCLUDE = "include";
    private static final String TAG_EXCLUDE = "exclude";
    private DBPDataSourceContainer dataSourceContainer;

    public DBVModel(DBPDataSourceContainer dataSourceContainer) {
        super(null, "model");
        this.dataSourceContainer = dataSourceContainer;
    }

    public DBVModel(DBPDataSourceContainer dataSourceContainer, DBVModel source) {
        super(null, source);
        this.dataSourceContainer = dataSourceContainer;
    }

    @Override
    public DBSObjectContainer getRealContainer(DBRProgressMonitor monitor) throws DBException {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (dataSource instanceof DBSObjectContainer) {
            return (DBSObjectContainer)((Object)dataSource);
        }
        log.warn("Datasource '" + dataSource + "' is not an object container");
        return null;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSourceContainer.getDataSource();
    }

    public DBVEntity findEntity(DBSEntity entity, boolean createNew) {
        DBSObject[] path = DBUtils.getObjectPath(entity, false);
        if (path.length == 0) {
            log.warn("Empty entity path");
            return null;
        }
        if (path[0] != this.dataSourceContainer) {
            log.warn("Entity's root must be datasource container '" + this.dataSourceContainer.getName() + "'");
            return null;
        }
        DBVContainer container = this;
        int i = 1;
        while (i < path.length) {
            DBSObject item = path[i];
            if ((container = container.getContainer(item.getName(), createNew)) == null) {
                return null;
            }
            ++i;
        }
        return container.getEntity(entity.getName(), createNew);
    }

    public void serialize(XMLBuilder xml) throws IOException {
        DBVModel.serializeContainer(xml, this);
    }

    private static void serializeContainer(XMLBuilder xml, DBVContainer object) throws IOException {
        if (!object.hasValuableData()) {
            return;
        }
        xml.startElement(TAG_CONTAINER);
        xml.addAttribute(ATTR_NAME, object.getName());
        for (DBVContainer container : object.getContainers()) {
            DBVModel.serializeContainer(xml, container);
        }
        for (DBVEntity entity : object.getEntities()) {
            if (!entity.hasValuableData()) continue;
            DBVModel.serializeEntity(xml, entity);
        }
        xml.endElement();
    }

    private static void serializeEntity(XMLBuilder xml, DBVEntity entity) throws IOException {
        xml.startElement(TAG_ENTITY);
        xml.addAttribute(ATTR_NAME, entity.getName());
        if (!CommonUtils.isEmpty((String)entity.getDescriptionColumnNames())) {
            xml.addAttribute(ATTR_DESCRIPTION, entity.getDescriptionColumnNames());
        }
        if (!CommonUtils.isEmpty(entity.properties)) {
            for (Map.Entry<String, String> prop : entity.properties.entrySet()) {
                xml.startElement(TAG_PROPERTY);
                xml.addAttribute(ATTR_NAME, prop.getKey());
                xml.addAttribute("value", prop.getValue());
                xml.endElement();
            }
        }
        for (DBVEntityAttribute attr : CommonUtils.safeCollection(entity.entityAttributes)) {
            Throwable throwable = null;
            Iterator iterator = null;
            try (XMLBuilder.Element e3 = xml.startElement(TAG_ATTRIBUTE);){
                xml.addAttribute(ATTR_NAME, attr.getName());
                DBVTransformSettings transformSettings = attr.getTransformSettings();
                if (transformSettings == null || !transformSettings.hasValuableData()) continue;
                Throwable throwable2 = null;
                Object var9_14 = null;
                try (XMLBuilder.Element e4 = xml.startElement(TAG_TRANSFORM);){
                    XMLBuilder.Element e5;
                    Throwable throwable3;
                    Object object;
                    if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())) {
                        xml.addAttribute(ATTR_CUSTOM, transformSettings.getCustomTransformer());
                    }
                    for (String id : CommonUtils.safeCollection(transformSettings.getIncludedTransformers())) {
                        object = null;
                        throwable3 = null;
                        try {
                            e5 = xml.startElement(TAG_INCLUDE);
                            try {
                                xml.addAttribute(ATTR_ID, id);
                            }
                            finally {
                                if (e5 != null) {
                                    e5.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (object == null) {
                                object = throwable4;
                            } else if (object != throwable4) {
                                ((Throwable)object).addSuppressed(throwable4);
                            }
                            throw object;
                        }
                    }
                    for (String id : CommonUtils.safeCollection(transformSettings.getExcludedTransformers())) {
                        object = null;
                        throwable3 = null;
                        try {
                            e5 = xml.startElement(TAG_EXCLUDE);
                            try {
                                xml.addAttribute(ATTR_ID, id);
                            }
                            finally {
                                if (e5 != null) {
                                    e5.close();
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (object == null) {
                                object = throwable5;
                            } else if (object != throwable5) {
                                ((Throwable)object).addSuppressed(throwable5);
                            }
                            throw object;
                        }
                    }
                    Map<String, String> transformOptions = transformSettings.getTransformOptions();
                    if (transformOptions == null) continue;
                    for (Map.Entry entry : transformOptions.entrySet()) {
                        throwable3 = null;
                        Object var15_29 = null;
                        try (XMLBuilder.Element e52 = xml.startElement(TAG_PROPERTY);){
                            if (entry.getValue() == null) continue;
                            xml.addAttribute(ATTR_NAME, (String)entry.getKey());
                            xml.addAttribute("value", (String)entry.getValue());
                        }
                        catch (Throwable throwable6) {
                            if (throwable3 == null) {
                                throwable3 = throwable6;
                            } else if (throwable3 != throwable6) {
                                throwable3.addSuppressed(throwable6);
                            }
                            throw throwable3;
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        for (DBVEntityConstraint c : CommonUtils.safeCollection(entity.entityConstraints)) {
            if (!c.hasAttributes()) continue;
            xml.startElement(TAG_CONSTRAINT);
            xml.addAttribute(ATTR_NAME, c.getName());
            xml.addAttribute(ATTR_TYPE, c.getConstraintType().getName());
            for (DBVEntityConstraintColumn cc : CommonUtils.safeCollection(c.getAttributeReferences(null))) {
                xml.startElement(TAG_ATTRIBUTE);
                xml.addAttribute(ATTR_NAME, cc.getAttributeName());
                xml.endElement();
            }
            xml.endElement();
        }
        if (!CommonUtils.isEmpty(entity.colorOverrides)) {
            xml.startElement(TAG_COLORS);
            for (DBVColorOverride color : entity.colorOverrides) {
                xml.startElement(TAG_COLOR);
                xml.addAttribute(ATTR_NAME, color.getAttributeName());
                xml.addAttribute(ATTR_OPERATOR, color.getOperator().name());
                if (color.getColorForeground() != null) {
                    xml.addAttribute(ATTR_FOREGROUND, color.getColorForeground());
                }
                if (color.getColorBackground() != null) {
                    xml.addAttribute(ATTR_BACKGROUND, color.getColorBackground());
                }
                if (!ArrayUtils.isEmpty((Object[])color.getAttributeValues())) {
                    Object[] objectArray = color.getAttributeValues();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value = objectArray[n2];
                        if (value != null) {
                            xml.startElement("value");
                            xml.addText((CharSequence)GeneralUtils.serializeObject(value));
                            xml.endElement();
                        }
                        ++n2;
                    }
                }
                xml.endElement();
            }
            xml.endElement();
        }
        xml.endElement();
    }

    public SAXListener getModelParser() {
        return new ModelParser();
    }

    public void copyFrom(DBVModel model) {
        super.copyFrom(model);
    }

    class ModelParser
    implements SAXListener {
        private DBVContainer curContainer = null;
        private DBVEntity curEntity = null;
        private DBVEntityAttribute curAttribute = null;
        private DBVTransformSettings curTransformSettings = null;
        private DBVEntityConstraint curConstraint;
        private DBVColorOverride curColor;
        private boolean colorValue = false;

        ModelParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            switch (localName) {
                case "container": {
                    if (this.curContainer == null) {
                        this.curContainer = DBVModel.this;
                        break;
                    }
                    DBVContainer container = new DBVContainer(this.curContainer, atts.getValue(DBVModel.ATTR_NAME));
                    this.curContainer.addContainer(container);
                    this.curContainer = container;
                    break;
                }
                case "entity": {
                    this.curEntity = new DBVEntity(this.curContainer, atts.getValue(DBVModel.ATTR_NAME), atts.getValue(DBVModel.ATTR_DESCRIPTION));
                    this.curContainer.addEntity(this.curEntity);
                    break;
                }
                case "property": {
                    if (this.curTransformSettings != null) {
                        this.curTransformSettings.setTransformOption(atts.getValue(DBVModel.ATTR_NAME), atts.getValue("value"));
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setProperty(atts.getValue(DBVModel.ATTR_NAME), atts.getValue("value"));
                    break;
                }
                case "constraint": {
                    if (this.curEntity == null) break;
                    this.curConstraint = new DBVEntityConstraint(this.curEntity, DBSEntityConstraintType.VIRTUAL_KEY, atts.getValue(DBVModel.ATTR_NAME));
                    this.curEntity.addConstraint(this.curConstraint);
                    break;
                }
                case "attribute": {
                    if (this.curConstraint != null) {
                        this.curConstraint.addAttribute(atts.getValue(DBVModel.ATTR_NAME));
                        break;
                    }
                    if (this.curAttribute != null) {
                        DBVEntityAttribute childAttribute = new DBVEntityAttribute(this.curEntity, this.curAttribute, atts.getValue(DBVModel.ATTR_NAME));
                        this.curAttribute.addChild(childAttribute);
                        this.curAttribute = childAttribute;
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curAttribute = new DBVEntityAttribute(this.curEntity, null, atts.getValue(DBVModel.ATTR_NAME));
                    this.curEntity.addVirtualAttribute(this.curAttribute);
                    break;
                }
                case "transform": {
                    this.curTransformSettings = new DBVTransformSettings();
                    this.curTransformSettings.setCustomTransformer(atts.getValue(DBVModel.ATTR_CUSTOM));
                    if (this.curAttribute != null) {
                        this.curAttribute.setTransformSettings(this.curTransformSettings);
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setTransformSettings(this.curTransformSettings);
                    break;
                }
                case "exclude": 
                case "include": {
                    String transformerId = atts.getValue(DBVModel.ATTR_ID);
                    if (this.curTransformSettings == null || CommonUtils.isEmpty((String)transformerId)) break;
                    DBDAttributeTransformerDescriptor transformer = DBVModel.this.dataSourceContainer.getPlatform().getValueHandlerRegistry().getTransformer(transformerId);
                    if (transformer == null) {
                        log.warn("Transformer '" + transformerId + "' not found");
                        break;
                    }
                    this.curTransformSettings.enableTransformer(transformer, DBVModel.TAG_INCLUDE.equals(localName));
                    break;
                }
                case "color": {
                    if (this.curEntity == null) break;
                    try {
                        this.curColor = new DBVColorOverride(atts.getValue(DBVModel.ATTR_NAME), DBCLogicalOperator.valueOf(atts.getValue(DBVModel.ATTR_OPERATOR)), null, atts.getValue(DBVModel.ATTR_FOREGROUND), atts.getValue(DBVModel.ATTR_BACKGROUND));
                        this.curEntity.addColorOverride(this.curColor);
                    }
                    catch (Throwable e) {
                        log.warn("Error reading color settings", e);
                    }
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = true;
                }
            }
        }

        public void saxText(SAXReader reader, String data) {
            if (this.colorValue) {
                this.curColor.addAttributeValue(GeneralUtils.deserializeObject(data));
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
            switch (localName) {
                case "container": {
                    this.curContainer = this.curContainer.getParentObject();
                    break;
                }
                case "entity": {
                    this.curEntity = null;
                    break;
                }
                case "constraint": {
                    this.curConstraint = null;
                    break;
                }
                case "attribute": {
                    if (this.curAttribute == null) break;
                    this.curAttribute = this.curAttribute.getParent();
                    break;
                }
                case "transform": {
                    this.curTransformSettings = null;
                }
                case "color": {
                    this.curColor = null;
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = false;
                }
            }
        }
    }
}

