/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public abstract class AbstractTableConstraint<TABLE extends DBSTable>
implements DBSTableConstraint {
    private final TABLE table;
    private String name;
    protected String description;
    protected DBSEntityConstraintType constraintType;

    protected AbstractTableConstraint(TABLE table, String name, String description, DBSEntityConstraintType constraintType) {
        this.table = table;
        this.name = name;
        this.description = description;
        this.constraintType = constraintType;
    }

    protected AbstractTableConstraint(TABLE table, DBSEntityConstraint source) {
        this.table = table;
        this.name = source.getName();
        this.description = source.getDescription();
        this.constraintType = source.getConstraintType();
    }

    @Property(id="owner", viewable=true, order=2)
    public TABLE getTable() {
        return this.table;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @Property(viewable=true, order=3)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return this.constraintType;
    }

    @NotNull
    public TABLE getParentObject() {
        return this.table;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public String toString() {
        return this.getName() == null ? "<NONE>" : this.getName();
    }
}

