/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanAnalyser;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;

public class PostgreQueryPlaner
implements DBCQueryPlanner {
    private final GenericDataSource dataSource;

    public PostgreQueryPlaner(GenericDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public GenericDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBCException {
        PostgrePlanAnalyser plan = new PostgrePlanAnalyser(this.getPlanStyle() == DBCPlanStyle.QUERY, true, query);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return this.dataSource.isServerVersionAtLeast(9, 0) ? DBCPlanStyle.PLAN : DBCPlanStyle.QUERY;
    }
}

