/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final PostgreGeometryValueHandler INSTANCE = new PostgreGeometryValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, resultSet.getObject(index), false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Geometry) {
            statement.setObject(paramIndex, (Object)this.getStringFromGeometry(session, (Geometry)value), 1111);
        } else if (value.getClass().getName().equals("org.postgis.PGgeometry")) {
            statement.setObject(paramIndex, value, 1111);
        } else {
            statement.setObject(paramIndex, (Object)value.toString(), 1111);
        }
    }

    public Class<?> getValueObjectType(DBSTypedObject attribute) {
        return Geometry.class;
    }

    public Object getValueFromObject(DBCSession session, DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Geometry) {
            return object;
        }
        if (object instanceof String) {
            return this.makeGeometryFromString(session, (String)object);
        }
        if (object.getClass().getName().equals("org.postgis.PGgeometry")) {
            return this.makeGeometryFromPGGeometry(session, object);
        }
        return this.makeGeometryFromString(session, object.toString());
    }

    private Object makeGeometryFromPGGeometry(DBCSession session, Object pgGeometry) throws DBCException {
        try {
            return BeanUtils.invokeObjectMethod((Object)pgGeometry, (String)"getGeometry", null, null);
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getDataSource());
        }
    }

    private Object makeGeometryFromString(DBCSession session, String object) throws DBCException {
        if (CommonUtils.isEmpty((String)object)) {
            return null;
        }
        try {
            Class jtsGeometry = DBUtils.getDriverClass((DBPDataSource)session.getDataSource(), (String)"org.postgis.PGgeometry");
            return BeanUtils.invokeStaticMethod((Class)jtsGeometry, (String)"geomFromString", (Class[])new Class[]{String.class}, (Object[])new Object[]{object});
        }
        catch (Throwable e) {
            throw new DBCException(e, session.getDataSource());
        }
    }

    private String getStringFromGeometry(JDBCSession session, Geometry geometry) throws DBCException {
        try {
            Class jtsGeometry = DBUtils.getDriverClass((DBPDataSource)session.getDataSource(), (String)"org.postgis.PGgeometry");
            Object jtsg = jtsGeometry.getConstructor(Geometry.class).newInstance(geometry);
            return (String)BeanUtils.invokeObjectMethod(jtsg, (String)"getValue", null, null);
        }
        catch (Throwable e) {
            throw new DBCException(e, (DBPDataSource)session.getDataSource());
        }
    }
}

