/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKeyColumn;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;

public class PostgreTableForeignKey
extends PostgreTableConstraintBase
implements DBSTableForeignKey {
    private static final Log log = Log.getLog(PostgreTableForeignKey.class);
    private MatchType matchType;
    private DBSForeignKeyModifyRule updateRule;
    private DBSForeignKeyModifyRule deleteRule;
    private DBSEntityConstraint refConstraint;
    private final List<PostgreTableForeignKeyColumn> columns = new ArrayList<PostgreTableForeignKeyColumn>();
    private final PostgreTableBase refTable;

    public PostgreTableForeignKey(@NotNull PostgreTableBase table, @NotNull String name, @NotNull JDBCResultSet resultSet) throws DBException {
        super(table, name, DBSEntityConstraintType.FOREIGN_KEY, resultSet);
        try {
            this.matchType = MatchType.valueOf(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"confmatchtype"));
        }
        catch (Throwable e) {
            log.debug((Object)("Error reading FK match type: " + e.getMessage()));
        }
        this.updateRule = this.getRuleFromAction(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"confupdtype"));
        this.deleteRule = this.getRuleFromAction(JDBCUtils.safeGetString((ResultSet)resultSet, (String)"confdeltype"));
        DBRProgressMonitor monitor = resultSet.getSession().getProgressMonitor();
        long refSchemaId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"refnamespace");
        long refTableId = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"confrelid");
        this.refTable = table.getDatabase().findTable(monitor, refSchemaId, refTableId);
        if (this.refTable == null) {
            throw new DBException("Reference table " + refTableId + " not found");
        }
    }

    public PostgreTableForeignKey(@NotNull PostgreTableBase table, @NotNull DBSEntityConstraint refConstraint, @NotNull DBSForeignKeyModifyRule deleteRule, @NotNull DBSForeignKeyModifyRule updateRule) {
        super(table, null, DBSEntityConstraintType.FOREIGN_KEY);
        this.refConstraint = refConstraint;
        this.refTable = (PostgreTableBase)refConstraint.getParentObject();
        this.matchType = MatchType.s;
        this.updateRule = updateRule;
        this.deleteRule = deleteRule;
    }

    @NotNull
    private DBSForeignKeyModifyRule getRuleFromAction(String action) {
        switch (action) {
            case "a": {
                return DBSForeignKeyModifyRule.NO_ACTION;
            }
            case "r": {
                return DBSForeignKeyModifyRule.RESTRICT;
            }
            case "c": {
                return DBSForeignKeyModifyRule.CASCADE;
            }
            case "n": {
                return DBSForeignKeyModifyRule.SET_NULL;
            }
            case "d": {
                return DBSForeignKeyModifyRule.SET_DEFAULT;
            }
        }
        log.warn((Object)("Unsupported constraint action: " + action));
        return DBSForeignKeyModifyRule.NO_ACTION;
    }

    @Property(viewable=true, specific=true, order=50)
    public PostgreTableBase getAssociatedEntity() {
        return this.refTable;
    }

    @Property(id="reference", viewable=true, specific=true, order=51)
    @Nullable
    public DBSEntityConstraint getReferencedConstraint() {
        return this.refConstraint;
    }

    @Property(viewable=true, specific=true, order=54)
    public MatchType getMatchType() {
        return this.matchType;
    }

    @Property(viewable=true, specific=true, order=55)
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return this.deleteRule;
    }

    @Property(viewable=true, specific=true, order=56)
    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return this.updateRule;
    }

    @Nullable
    public List<PostgreTableForeignKeyColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    @Override
    void cacheAttributes(DBRProgressMonitor monitor, List<? extends PostgreTableConstraintColumn> children, boolean secondPass) {
        if (!secondPass) {
            return;
        }
        this.columns.clear();
        this.columns.addAll(children);
        ArrayList<PostgreAttribute> lst = new ArrayList<PostgreAttribute>(children.size());
        for (PostgreTableConstraintColumn postgreTableConstraintColumn : children) {
            lst.add(((PostgreTableForeignKeyColumn)postgreTableConstraintColumn).getReferencedColumn());
        }
        try {
            this.refConstraint = DBUtils.findEntityConstraint((DBRProgressMonitor)monitor, (DBSEntity)this.refTable, lst);
        }
        catch (DBException dBException) {
            log.error((Object)"Error finding reference constraint", (Throwable)dBException);
        }
        if (this.refConstraint == null) {
            log.warn((Object)("Can't find reference constraint for foreign key '" + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
        }
    }

    public void addColumn(PostgreTableForeignKeyColumn column) {
        this.columns.add(column);
    }

    public static enum MatchType implements DBPNamedObject
    {
        f("FULL"),
        p("PARTIAL"),
        s("SIMPLE"),
        u("UNKNOWN");

        private final String title;

        private MatchType(String title) {
            this.title = title;
        }

        public String getName() {
            return this.title;
        }
    }
}

