/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSourceInfo;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreStructureAssistant;
import org.jkiss.dbeaver.ext.postgresql.model.QueryTransformerFetchAll;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerPostgreSQL;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.ext.postgresql.model.jdbc.PostgreJdbcFactory;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanAnalyser;
import org.jkiss.dbeaver.ext.postgresql.model.session.PostgreSessionManager;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.AsyncServerOutputReader;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBSInstanceContainer,
DBCQueryPlanner,
IAdaptable {
    private static final Log log = Log.getLog(PostgreDataSource.class);
    private DatabaseCache databaseCache;
    private String activeDatabaseName;
    private PostgreServerExtension serverExtension;
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("\\n\\s*\\p{L}+\\s*: ([0-9]+)");

    public PostgreDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new PostgreDialect());
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.max-string-type-length": {
                return 0xA00000;
            }
            case "datasource.lob-require-transactions": {
                return true;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    protected void initializeRemoteInstance(DBRProgressMonitor monitor) throws DBException {
        ArrayList<PostgreDatabase> dbList;
        block56: {
            this.activeDatabaseName = this.getContainer().getConnectionConfiguration().getDatabaseName();
            if (CommonUtils.isEmpty((String)this.activeDatabaseName)) {
                this.activeDatabaseName = "postgres";
            }
            this.databaseCache = new DatabaseCache();
            DBPConnectionConfiguration configuration = this.getContainer().getActualConnectionConfiguration();
            boolean showNDD = CommonUtils.getBoolean((String)configuration.getProviderProperty("@dbeaver-show-non-default-db@"), (boolean)false);
            dbList = new ArrayList<PostgreDatabase>();
            if (!showNDD) {
                PostgreDatabase defDatabase = new PostgreDatabase(monitor, this, this.activeDatabaseName);
                dbList.add(defDatabase);
            } else {
                DBSObjectFilter catalogFilters;
                boolean showTemplates = CommonUtils.toBoolean((Object)configuration.getProviderProperty("@dbeaver-show-template-db@"));
                StringBuilder catalogQuery = new StringBuilder("SELECT db.oid,db.*\nFROM pg_catalog.pg_database db WHERE datallowconn ");
                if (!showTemplates) {
                    catalogQuery.append(" AND NOT datistemplate ");
                }
                if ((catalogFilters = this.getContainer().getObjectFilter(PostgreDatabase.class, null, false)) != null) {
                    JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"datname", (boolean)false);
                }
                catalogQuery.append("\nORDER BY db.datname");
                try {
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (Connection bootstrapConnection = this.openConnection(monitor, null, "Read PostgreSQL database list");){
                        Object var15_25;
                        Throwable throwable2;
                        Throwable throwable3 = null;
                        Object var12_18 = null;
                        try (PreparedStatement dbStat = bootstrapConnection.prepareStatement(catalogQuery.toString());){
                            if (catalogFilters != null) {
                                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
                            }
                            throwable2 = null;
                            var15_25 = null;
                            try (ResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.next()) {
                                    PostgreDatabase database = new PostgreDatabase(monitor, this, dbResult);
                                    dbList.add(database);
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                        if (this.activeDatabaseName != null) break block56;
                        throwable3 = null;
                        var12_18 = null;
                        try (PreparedStatement stat = bootstrapConnection.prepareStatement("SELECT current_database()");){
                            throwable2 = null;
                            var15_25 = null;
                            try (ResultSet rs = stat.executeQuery();){
                                if (rs.next()) {
                                    this.activeDatabaseName = JDBCUtils.safeGetString((ResultSet)rs, (int)1);
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable2 == null) {
                                    throwable2 = throwable6;
                                } else if (throwable2 != throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable3 == null) {
                                throwable3 = throwable7;
                            } else if (throwable3 != throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable8) {
                        if (throwable == null) {
                            throwable = throwable8;
                        } else if (throwable != throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException("Can't connect ot remote PostgreSQL server", (Throwable)e);
                }
            }
        }
        this.databaseCache.setCache(dbList);
        this.getDefaultInstance().checkInstanceConnection(monitor);
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(PostgreDataSourceProvider.getConnectionsProps());
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getDeclaredHandler("postgre_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(props, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        } else {
            this.getServerType().initDefaultSSLConfig(connectionInfo, props);
        }
        return props;
    }

    private void initSSL(Map<String, String> props, DBWHandlerConfiguration sslConfig) throws Exception {
        String factoryProp;
        String modeProp;
        String keyCertProp;
        String clientCertProp;
        props.put("ssl", "true");
        String rootCertProp = (String)sslConfig.getProperties().get("rootCert");
        if (!CommonUtils.isEmpty((String)rootCertProp)) {
            props.put("sslrootcert", rootCertProp);
        }
        if (!CommonUtils.isEmpty((String)(clientCertProp = (String)sslConfig.getProperties().get("clientCert")))) {
            props.put("sslcert", clientCertProp);
        }
        if (!CommonUtils.isEmpty((String)(keyCertProp = (String)sslConfig.getProperties().get("clientKey")))) {
            props.put("sslkey", keyCertProp);
        }
        if (!CommonUtils.isEmpty((String)(modeProp = (String)sslConfig.getProperties().get("sslMode")))) {
            props.put("sslmode", modeProp);
        }
        if (!CommonUtils.isEmpty((String)(factoryProp = (String)sslConfig.getProperties().get("sslFactory")))) {
            props.put("sslfactory", factoryProp);
        }
        props.put("sslpasswordcallback", DefaultCallbackHandler.class.getName());
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        PostgreSchema activeSchema;
        PostgreDatabase activeDatabase;
        if (setActiveObject && (activeDatabase = this.getDefaultObject()) != null && (activeSchema = activeDatabase.getDefaultObject()) != null) {
            String curDefSchema;
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.META, "Get context active schema");){
                    curDefSchema = JDBCUtils.queryString((JDBCSession)session, (String)"SELECT current_schema()", (Object[])new Object[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, (DBPDataSource)this.getDataSource());
            }
            if (curDefSchema == null || !curDefSchema.equals(activeSchema.getName())) {
                activeDatabase.setSearchPath(monitor, activeSchema, context);
            }
        }
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    public Collection<PostgreDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public PostgreDatabase getDatabase(String name) {
        return (PostgreDatabase)this.databaseCache.getCachedObject(name);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.getDefaultInstance().cacheDataTypes(monitor, true);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.shutdown(monitor);
        this.databaseCache.clearCache();
        this.activeDatabaseName = null;
        this.initializeRemoteInstance(monitor);
        this.initialize(monitor);
        return this;
    }

    public Collection<? extends PostgreDatabase> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases();
    }

    public PostgreDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getDatabase(childName);
    }

    public Class<? extends PostgreDatabase> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return PostgreDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public PostgreDatabase getDefaultObject() {
        return this.getDefaultInstance();
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        PostgreDatabase oldDatabase = this.getDefaultObject();
        if (!(object instanceof PostgreDatabase)) {
            throw new IllegalArgumentException("Invalid object type: " + object);
        }
        PostgreDatabase newDatabase = (PostgreDatabase)object;
        if (oldDatabase == newDatabase) {
            return;
        }
        this.activeDatabaseName = object.getName();
        this.getDefaultInstance().initializeMetaContext(monitor);
        this.getDefaultInstance().cacheDataTypes(monitor, false);
        if (oldDatabase != null) {
            DBUtils.fireObjectSelect((DBSObject)oldDatabase, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)newDatabase, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return true;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, JDBCRemoteInstance remoteInstance, @NotNull String purpose) throws DBCException {
        Connection pgConnection;
        DBPConnectionConfiguration conConfig = this.getContainer().getActualConnectionConfiguration();
        if (remoteInstance != null) {
            log.debug((Object)("Initiate connection to " + this.getServerType().getServerTypeName() + " database [" + remoteInstance.getName() + "@" + conConfig.getHostName() + "] for " + purpose));
        }
        if (remoteInstance instanceof PostgreDatabase && remoteInstance.getName() != null && !CommonUtils.equalObjects((Object)remoteInstance.getName(), (Object)conConfig.getDatabaseName())) {
            DBPConnectionConfiguration originalConfig = new DBPConnectionConfiguration(conConfig);
            try {
                conConfig.setDatabaseName(remoteInstance.getName());
                conConfig.setUrl(this.getContainer().getDriver().getDataSourceProvider().getConnectionURL(this.getContainer().getDriver(), conConfig));
                pgConnection = super.openConnection(monitor, remoteInstance, purpose);
            }
            finally {
                conConfig.setDatabaseName(originalConfig.getDatabaseName());
                conConfig.setUrl(originalConfig.getUrl());
            }
        } else {
            pgConnection = super.openConnection(monitor, remoteInstance, purpose);
        }
        if (this.getServerType().supportsClientInfo() && !this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                pgConnection.setClientInfo("ApplicationName", DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose));
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return pgConnection;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBCException {
        PostgrePlanAnalyser plan = new PostgrePlanAnalyser(this.getPlanStyle() == DBCPlanStyle.QUERY, this.getServerType().supportsExplainPlanVerbose(), query);
        if (this.getPlanStyle() == DBCPlanStyle.PLAN) {
            plan.explain(session);
        }
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return this.getServerType().supportsExplainPlanXML() ? DBCPlanStyle.PLAN : DBCPlanStyle.QUERY;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new PostgreStructureAssistant(this));
        }
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast(new AsyncServerOutputReader());
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new PostgreSessionManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this;
    }

    public Collection<PostgreDataType> getLocalDataTypes() {
        return this.getDefaultInstance().getLocalDataTypes();
    }

    public PostgreDataType getLocalDataType(String typeName) {
        return this.getDefaultInstance().getLocalDataType(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.getDefaultInstance().getLocalDataType(typeID);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return this.getDefaultInstance().getDefaultDataTypeName(dataKind);
    }

    @NotNull
    public PostgreDatabase getDefaultInstance() {
        PostgreDatabase defDatabase = (PostgreDatabase)this.databaseCache.getCachedObject(this.activeDatabaseName);
        if (defDatabase == null) {
            defDatabase = (PostgreDatabase)this.databaseCache.getCachedObject("postgres");
        }
        if (defDatabase == null) {
            List allDatabases = this.databaseCache.getCachedObjects();
            if (allDatabases.isEmpty()) {
                return null;
            }
            defDatabase = (PostgreDatabase)allDatabases.get(0);
        }
        return defDatabase;
    }

    @NotNull
    public List<PostgreDatabase> getAvailableInstances() {
        return this.databaseCache.getCachedObjects();
    }

    /*
     * Exception decompiling
     */
    public List<String> getTemplateDatabases(DBRProgressMonitor monitor) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PostgreServerExtension getServerType() {
        if (this.serverExtension == null) {
            PostgreServerType serverType = PostgreUtils.getServerType(this.getContainer().getDriver());
            try {
                this.serverExtension = serverType.createServerExtension(this);
            }
            catch (Throwable e) {
                log.error((Object)"Can't determine server type", e);
                this.serverExtension = new PostgreServerPostgreSQL(this);
            }
        }
        return this.serverExtension;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        Matcher matcher;
        String message;
        Throwable rootCause = GeneralUtils.getRootCause((Throwable)error);
        if (rootCause != null && "org.postgresql.util.PSQLException".equals(rootCause.getClass().getName())) {
            try {
                Object position;
                Object serverErrorMessage = BeanUtils.readObjectProperty((Object)rootCause, (String)"serverErrorMessage");
                if (serverErrorMessage != null && (position = BeanUtils.readObjectProperty((Object)serverErrorMessage, (String)"position")) instanceof Number) {
                    DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                    pos.position = ((Number)position).intValue();
                    return new DBPErrorAssistant.ErrorPosition[]{pos};
                }
            }
            catch (Throwable throwable) {}
        }
        if (!CommonUtils.isEmpty((String)(message = error.getMessage())) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.position = Integer.parseInt(matcher.group(1)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }

    @NotNull
    protected JDBCFactory createJdbcFactory() {
        return new PostgreJdbcFactory();
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(Throwable error) {
        String sqlState = SQLState.getStateFromException((Throwable)error);
        if (sqlState != null && "57P01".equals(sqlState)) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return super.discoverErrorType(error);
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        return new PostgreDataSourceInfo(this, metaData);
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        if (type == DBCQueryTransformType.FETCH_ALL_TABLE) {
            return new QueryTransformerFetchAll();
        }
        return null;
    }

    class DatabaseCache
    extends JDBCObjectLookupCache<PostgreDataSource, PostgreDatabase> {
        DatabaseCache() {
        }

        protected PostgreDatabase fetchObject(@NotNull JDBCSession session, @NotNull PostgreDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new PostgreDatabase(session.getProgressMonitor(), owner, (ResultSet)resultSet);
        }

        public JDBCStatement prepareLookupStatement(JDBCSession session, PostgreDataSource owner, PostgreDatabase object, String objectName) throws SQLException {
            boolean showNDD = CommonUtils.toBoolean((Object)PostgreDataSource.this.getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-show-non-default-db@"));
            boolean showTemplates = CommonUtils.toBoolean((Object)PostgreDataSource.this.getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-show-template-db@"));
            StringBuilder catalogQuery = new StringBuilder("SELECT db.oid,db.*\nFROM pg_catalog.pg_database db WHERE datallowconn ");
            if (object == null && !showTemplates) {
                catalogQuery.append(" AND NOT datistemplate ");
            }
            if (object != null) {
                catalogQuery.append("\nAND db.oid=?");
            } else if (objectName != null || !showNDD) {
                catalogQuery.append("\nAND db.datname=?");
            }
            DBSObjectFilter catalogFilters = owner.getContainer().getObjectFilter(PostgreDatabase.class, null, false);
            if (object == null && showNDD) {
                if (catalogFilters != null) {
                    JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"datname", (boolean)false);
                }
                catalogQuery.append("\nORDER BY db.datname");
            }
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (object != null) {
                dbStat.setLong(1, object.getObjectId());
            } else if (objectName != null || !showNDD) {
                dbStat.setString(1, objectName != null ? objectName : PostgreDataSource.this.activeDatabaseName);
            } else if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }
    }
}

