/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;
import org.jkiss.utils.CommonUtils;

public class PostgreConstraintManager
extends SQLConstraintManager<PostgreTableConstraintBase, PostgreTableBase> {
    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableConstraintBase> getObjectsCache(PostgreTableConstraintBase object) {
        return ((PostgreSchema)((PostgreTableBase)object.getTable()).getContainer()).constraintCache;
    }

    protected PostgreTableConstraintBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final PostgreTableBase parent, Object from) {
        return (PostgreTableConstraintBase)new UITask<PostgreTableConstraintBase>(){

            protected PostgreTableConstraintBase runTask() {
                EditConstraintPage editPage = new EditConstraintPage(PostgreMessages.edit_constraint_page_add_constraint, (DBSEntity)parent, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY, DBSEntityConstraintType.UNIQUE_KEY, DBSEntityConstraintType.CHECK});
                if (!editPage.edit()) {
                    return null;
                }
                PostgreTableConstraint constraint = new PostgreTableConstraint(parent, editPage.getConstraintName(), editPage.getConstraintType());
                if (constraint.getConstraintType().isCustom()) {
                    constraint.setSource(editPage.getConstraintExpression());
                } else {
                    int colIndex = 1;
                    for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                        constraint.addColumn(new PostgreTableConstraintColumn(constraint, (PostgreAttribute)tableColumn, colIndex++));
                    }
                }
                return constraint;
            }
        }.execute();
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreTableBase owner, DBECommandAbstract<PostgreTableConstraintBase> command, Map<String, Object> options) {
        PostgreTableConstraintBase constr = (PostgreTableConstraintBase)command.getObject();
        if (constr.isPersisted()) {
            try {
                String constrDDL = constr.getObjectDefinitionText(monitor, Collections.singletonMap("embedded.source", true));
                if (!CommonUtils.isEmpty((String)constrDDL)) {
                    return new StringBuilder(constrDDL);
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract constraint DDL", (Throwable)e);
            }
        }
        return super.getNestedDeclaration(monitor, (JDBCTable)owner, command, options);
    }

    @NotNull
    protected String getAddConstraintTypeClause(PostgreTableConstraintBase constraint) {
        if (constraint.getConstraintType() == DBSEntityConstraintType.UNIQUE_KEY) {
            return "UNIQUE";
        }
        return super.getAddConstraintTypeClause((JDBCTableConstraint)constraint);
    }

    protected void appendConstraintDefinition(StringBuilder decl, DBECommandAbstract<PostgreTableConstraintBase> command) {
        if (((PostgreTableConstraintBase)command.getObject()).getConstraintType() == DBSEntityConstraintType.CHECK) {
            decl.append(" (").append(((PostgreTableConstraint)command.getObject()).getSource()).append(")");
        } else {
            super.appendConstraintDefinition(decl, command);
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            PostgreConstraintManager.addConstraintCommentAction(actionList, (PostgreTableConstraintBase)command.getObject());
        }
    }

    static void addConstraintCommentAction(List<DBEPersistAction> actionList, PostgreTableConstraintBase constr) {
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "COMMENT ON CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)constr) + " ON " + ((PostgreTableBase)constr.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)constr, (String)constr.getDescription())));
    }

    protected String getDropConstraintPattern(PostgreTableConstraintBase constraint) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }
}

