/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.Pair;

public class SQLPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String SQL_PARTITIONING = "___sql_partitioning";
    public static final String CONTENT_TYPE_SQL_COMMENT = "sql_comment";
    public static final String CONTENT_TYPE_SQL_MULTILINE_COMMENT = "sql_multiline_comment";
    public static final String CONTENT_TYPE_SQL_STRING = "sql_character";
    public static final String CONTENT_TYPE_SQL_QUOTED = "sql_quoted";
    public static final String[] SQL_CONTENT_TYPES = new String[]{"__dftl_partition_content_type", "sql_comment", "sql_multiline_comment", "sql_character", "sql_quoted"};
    private final List<IPredicateRule> rules = new ArrayList<IPredicateRule>();
    private final IToken commentToken = new Token((Object)"sql_comment");
    private final IToken multilineCommentToken = new Token((Object)"sql_multiline_comment");
    private final IToken sqlStringToken = new Token((Object)"sql_character");
    private final IToken sqlQuotedToken = new Token((Object)"sql_quoted");

    private void setupRules() {
        IPredicateRule[] result = new IPredicateRule[this.rules.size()];
        this.rules.toArray(result);
        this.setPredicateRules(result);
    }

    private void initRules(SQLDialect dialect) {
        String[] singleLineComments;
        this.rules.add((IPredicateRule)new MultiLineRule("'", "'", this.sqlStringToken, dialect.getStringEscapeCharacter()));
        this.rules.add((IPredicateRule)new MultiLineRule("\"", "\"", this.sqlQuotedToken, dialect.getStringEscapeCharacter()));
        EmptyCommentRule wordRule = new EmptyCommentRule(this.multilineCommentToken);
        this.rules.add(wordRule);
        Pair multiLineComments = dialect.getMultiLineComments();
        if (multiLineComments != null) {
            this.rules.add((IPredicateRule)new MultiLineRule((String)multiLineComments.getFirst(), (String)multiLineComments.getSecond(), this.multilineCommentToken, '\u0000', true));
        }
        String[] stringArray = singleLineComments = dialect.getSingleLineComments();
        int n = singleLineComments.length;
        int n2 = 0;
        while (n2 < n) {
            String singleLineComment = stringArray[n2];
            this.rules.add((IPredicateRule)new EndOfLineRule(singleLineComment, this.commentToken));
            ++n2;
        }
    }

    public SQLPartitionScanner(SQLDialect dialect) {
        this.initRules(dialect);
        this.setupRules();
    }

    public String getScannedPartitionString() {
        try {
            return this.fDocument.get(this.fPartitionOffset, this.fOffset - this.fPartitionOffset);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static ITypedRegion[] getDocumentRegions(IDocument doc) {
        ITypedRegion[] regions = null;
        try {
            regions = TextUtilities.computePartitioning((IDocument)doc, (String)SQL_PARTITIONING, (int)0, (int)doc.getLength(), (boolean)false);
        }
        catch (BadLocationException badLocationException) {}
        return regions;
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken successToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.successToken = successToken;
            this.addWord("/**/", this.successToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.successToken;
        }
    }
}

