/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.scripts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class ScriptsHandlerImpl
extends AbstractResourceHandler {
    private static final Log log = Log.getLog(ScriptsHandlerImpl.class);

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "script folder";
        }
        return "script";
    }

    public String getResourceDescription(@NotNull IResource resource) {
        return SQLEditorUtils.getResourceDescription(resource);
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        DBNResource node = super.makeNavigatorNode(parentNode, resource);
        this.updateNavigatorNode(node, resource);
        return node;
    }

    public void updateNavigatorNode(@NotNull DBNResource node, @NotNull IResource resource) {
        super.updateNavigatorNode(node, resource);
        if (resource instanceof IFolder) {
            if (resource.getParent() instanceof IProject) {
                node.setResourceImage((DBPImage)UIIcon.SCRIPTS);
            }
        } else {
            node.setResourceImage((DBPImage)UIIcon.SQL_SCRIPT);
        }
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            FileEditorInput sqlInput = new FileEditorInput((IFile)resource);
            UIUtils.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)sqlInput, SQLEditor.class.getName());
        } else {
            super.openResource(resource);
        }
    }

    @Nullable
    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        if (resource.getResource() instanceof IFile) {
            DBPDataSourceContainer dataSource = EditorUtils.getFileDataSource((IFile)((IFile)resource.getResource()));
            return dataSource == null ? null : Collections.singletonList(dataSource);
        }
        return null;
    }

    @NotNull
    public String getResourceNodeName(@NotNull IResource resource) {
        return super.getResourceNodeName(resource);
    }
}

