/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.ManifestParser;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidManifest;
import com.android.xml.AndroidXPathFactory;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.annotation.ThreadSafe;
import org.xml.sax.InputSource;

@ThreadSafe
class DefaultManifestParser
implements ManifestParser {
    Optional<Object> mMinSdkVersion;
    Optional<Object> mTargetSdkVersion;
    Optional<Integer> mVersionCode;
    Optional<String> mPackage;
    Optional<String> mVersionName;

    DefaultManifestParser() {
    }

    @Override
    public synchronized String getPackage(File manifestFile) {
        if (this.mPackage == null) {
            this.mPackage = Optional.fromNullable((Object)DefaultManifestParser.getStringValue(manifestFile, "/manifest/@package"));
        }
        return (String)this.mPackage.orNull();
    }

    @Override
    public synchronized String getVersionName(File manifestFile) {
        if (this.mVersionName == null) {
            this.mVersionName = Optional.fromNullable((Object)DefaultManifestParser.getStringValue(manifestFile, "/manifest/@android:versionName"));
        }
        return (String)this.mVersionName.orNull();
    }

    @Override
    public synchronized int getVersionCode(File manifestFile) {
        if (this.mVersionCode == null) {
            this.mVersionCode = Optional.absent();
            try {
                String value = DefaultManifestParser.getStringValue(manifestFile, "/manifest/@android:versionCode");
                if (value != null) {
                    this.mVersionCode = Optional.of((Object)Integer.valueOf(value));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (Integer)this.mVersionCode.or((Object)-1);
    }

    @Override
    public synchronized Object getMinSdkVersion(File manifestFile) {
        if (this.mMinSdkVersion == null) {
            try {
                this.mMinSdkVersion = Optional.fromNullable((Object)AndroidManifest.getMinSdkVersion((IAbstractFile)new FileWrapper(manifestFile)));
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
            catch (StreamException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mMinSdkVersion.or((Object)1);
    }

    @Override
    public Object getTargetSdkVersion(File manifestFile) {
        if (this.mTargetSdkVersion == null) {
            try {
                this.mTargetSdkVersion = Optional.fromNullable((Object)AndroidManifest.getTargetSdkVersion((IAbstractFile)new FileWrapper(manifestFile)));
            }
            catch (XPathExpressionException e) {
                return new RuntimeException(e);
            }
            catch (StreamException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mTargetSdkVersion.or((Object)-1);
    }

    private static String getStringValue(File file, String xPath) {
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            InputSource source = new InputSource(XmlUtils.getUtfReader((File)file));
            return xpath.evaluate(xPath, source);
        }
        catch (XPathExpressionException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

