module CMSScanner
  # Generic Vulnerability
  class Vulnerability
    include References

    attr_reader :title, :type, :fixed_in

    # @param [ String ] title
    # @param [ Hash ] references
    # @option references [ Array<String>, String ] cve
    # @option references [ Array<String>, String ] secunia
    # @option references [ Array<String>, String ] osvdb
    # @option references [ Array<String>, String ] exploitdb
    # @option references [ Array<String> ] url URL(s) to related advisories etc
    # @option references [ Array<String>, String ] metasploit The related metasploit module(s)
    # @param [ String ] type
    # @param [ String ] fixed_in
    def initialize(title, references = {}, type = nil, fixed_in = nil)
      @title    = title
      @type     = type
      @fixed_in = fixed_in

      self.references = references
    end

    # param [ Vulnerability ] other
    #
    # @return [ Boolean ]
    def ==(other)
      title == other.title &&
        type == other.type &&
        references == other.references &&
        fixed_in == other.fixed_in
    end
  end
end
