"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function pathWithParams(path, additionalParams) {
    var searchParams = window.location.search
        .replace(/^\?/, '')
        .split('&')
        .filter(function (searchParam) { return searchParam; });
    if (additionalParams) {
        searchParams.push(additionalParams);
    }
    var joinedParams = searchParams.join('&');
    return "" + path + (joinedParams.length ? "?" + joinedParams : '');
}
exports.pathWithParams = pathWithParams;
function getURLParameter(parameterName) {
    return (window.location.search.split(parameterName + "=")[1] || '').split('&')[0];
}
exports.getURLParameter = getURLParameter;
function hasURLParameter(parameterName) {
    return window.location.search
        .split(/\?|&/)
        .map(function (parameter) { return parameter.split('=')[0]; })
        .some(function (key) { return key === parameterName; });
}
exports.hasURLParameter = hasURLParameter;
//# sourceMappingURL=UrlUtil.js.map