"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("@wireapp/commons");
var electron_1 = require("electron");
var environment = require('../../package.json').environment;
var isDevelopment = environment !== 'production';
var forceLogging = electron_1.remote && electron_1.remote.process.argv.includes('--enable-logging');
var LOGGER_NAMESPACE = '@wireapp/desktop';
exports.LOGGER_NAMESPACE = LOGGER_NAMESPACE;
var ENABLE_LOGGING = isDevelopment || forceLogging;
exports.ENABLE_LOGGING = ENABLE_LOGGING;
function getLogger(name) {
    var options = {
        namespace: LOGGER_NAMESPACE,
        separator: '/',
    };
    if (ENABLE_LOGGING) {
        options.forceEnable = true;
    }
    return commons_1.LogFactory.getLogger(name, options);
}
exports.getLogger = getLogger;
//# sourceMappingURL=getLogger.js.map