/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.availability.PsiAvailabilityService;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.breadcrumbs.BreadcrumbsUtil;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileBreadcrumbsCollector
extends FileBreadcrumbsCollector {
    private static final Logger LOG = Logger.getInstance(PsiFileBreadcrumbsCollector.class);
    private final Project myProject;

    public PsiFileBreadcrumbsCollector(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean handlesFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public void watchForChanges(final @NotNull VirtualFile file2, @NotNull Disposable disposable, final @NotNull Runnable changesHandler) {
        if (file2 == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(2);
        }
        if (changesHandler == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(3);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                PsiFile psiFile;
                VirtualFile changedFile;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFile virtualFile = changedFile = (psiFile = event.getFile()) == null ? null : psiFile.getVirtualFile();
                if (!Comparing.equal((Object)changedFile, (Object)file2)) {
                    return;
                }
                changesHandler.run();
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.propertyChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.propertyChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.propertyChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.propertyChanged(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.propertyChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/xml/breadcrumbs/PsiFileBreadcrumbsCollector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
    }

    @Override
    public void updateCrumbs(@NotNull VirtualFile virtualFile, @NotNull Editor editor, ProgressIndicator progressIndicator, @NotNull Consumer<Iterable<Crumb>> consumer) {
        if (virtualFile == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(6);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiAvailabilityService.getInstance(this.myProject).performWhenPsiAvailable(editor.getDocument(), () -> consumer.consume(this.collectBreadcrumbs(virtualFile, editor, offset)), progressIndicator);
    }

    private Iterable<Crumb> collectBreadcrumbs(VirtualFile file2, Editor editor, int offset) {
        BreadcrumbsProvider defaultInfoProvider = BreadcrumbsUtilEx.findProvider(editor, file2);
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs = PsiFileBreadcrumbsCollector.getLineElements(offset, file2, this.myProject, defaultInfoProvider, true);
        if (pairs == null) {
            return null;
        }
        ArrayList<Crumb> result2 = new ArrayList<Crumb>(pairs.size());
        CrumbPresentation[] presentations = PsiFileBreadcrumbsCollector.getCrumbPresentations(PsiFileBreadcrumbsCollector.toPsiElementArray(pairs));
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            CrumbPresentation presentation = null;
            if (presentations != null && 0 <= index && index < presentations.length) {
                presentation = presentations[index++];
            }
            result2.add(new PsiCrumb((PsiElement)pair.first, (BreadcrumbsProvider)pair.second, presentation));
        }
        return result2;
    }

    @Nullable
    private static CrumbPresentation[] getCrumbPresentations(PsiElement[] elements) {
        for (BreadcrumbsPresentationProvider provider : (BreadcrumbsPresentationProvider[])BreadcrumbsPresentationProvider.EP_NAME.getExtensions()) {
            CrumbPresentation[] presentations = provider.getCrumbPresentations(elements);
            if (presentations == null) continue;
            return presentations;
        }
        return null;
    }

    @Nullable
    private static Collection<Pair<PsiElement, BreadcrumbsProvider>> getLineElements(int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings) {
        PsiElement element = PsiFileBreadcrumbsCollector.findFirstBreadcrumbedElement(offset, file2, project, defaultInfoProvider, checkSettings);
        if (element == null) {
            return null;
        }
        LinkedList<Pair<PsiElement, BreadcrumbsProvider>> result2 = new LinkedList<Pair<PsiElement, BreadcrumbsProvider>>();
        while (element != null) {
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element, defaultInfoProvider, checkSettings);
            if (provider != null && provider.acceptElement(element)) {
                result2.addFirst((Pair<PsiElement, BreadcrumbsProvider>)Pair.create((Object)element, (Object)provider));
            }
            if (!((element = PsiFileBreadcrumbsCollector.getParent(element, provider)) instanceof PsiDirectory)) continue;
            break;
        }
        return result2;
    }

    @Nullable
    private static PsiElement findFirstBreadcrumbedElement(int offset, VirtualFile file2, Project project, BreadcrumbsProvider defaultInfoProvider, boolean checkSettings) {
        if (file2 == null || !file2.isValid() || file2.isDirectory()) {
            return null;
        }
        PriorityQueue leafs = new PriorityQueue(3, (o1, o2) -> {
            TextRange range1 = o1.getTextRange();
            if (range1 == null) {
                LOG.error(o1 + " returned null range");
                return 1;
            }
            TextRange range2 = o2.getTextRange();
            if (range2 == null) {
                LOG.error(o2 + " returned null range");
                return -1;
            }
            return range2.getStartOffset() - range1.getStartOffset();
        });
        FileViewProvider viewProvider = BreadcrumbsUtilEx.findViewProvider(file2, project);
        if (viewProvider == null) {
            return null;
        }
        for (Language language : viewProvider.getLanguages()) {
            ContainerUtil.addIfNotNull(leafs, (Object)viewProvider.findElementAt(offset, language));
        }
        while (!leafs.isEmpty()) {
            PsiElement element = (PsiElement)leafs.remove();
            if (!element.isValid()) continue;
            BreadcrumbsProvider provider = PsiFileBreadcrumbsCollector.findProviderForElement(element, defaultInfoProvider, checkSettings);
            if (provider != null && provider.acceptElement(element)) {
                return element;
            }
            if (element instanceof PsiFile) continue;
            ContainerUtil.addIfNotNull(leafs, (Object)PsiFileBreadcrumbsCollector.getParent(element, provider));
        }
        return null;
    }

    @Nullable
    private static PsiElement getParent(@NotNull PsiElement element, @Nullable BreadcrumbsProvider provider) {
        if (element == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(7);
        }
        return provider != null ? provider.getParent(element) : element.getParent();
    }

    @Nullable
    private static BreadcrumbsProvider findProviderForElement(@NotNull PsiElement element, BreadcrumbsProvider defaultProvider, boolean checkSettings) {
        if (element == null) {
            PsiFileBreadcrumbsCollector.$$$reportNull$$$0(8);
        }
        Language language = element.getLanguage();
        if (checkSettings && !EditorSettingsExternalizable.getInstance().isBreadcrumbsShownFor(language.getID())) {
            return defaultProvider;
        }
        BreadcrumbsProvider provider = BreadcrumbsUtil.getInfoProvider((Language)language);
        return provider == null ? defaultProvider : provider;
    }

    private static PsiElement[] toPsiElementArray(Collection<? extends Pair<PsiElement, BreadcrumbsProvider>> pairs) {
        PsiElement[] elements = new PsiElement[pairs.size()];
        int index = 0;
        for (Pair<PsiElement, BreadcrumbsProvider> pair : pairs) {
            elements[index++] = (PsiElement)pair.first;
        }
        return elements;
    }

    @Nullable
    public static PsiElement[] getLinePsiElements(int offset, VirtualFile file2, Project project, BreadcrumbsProvider infoProvider) {
        Collection<Pair<PsiElement, BreadcrumbsProvider>> pairs = PsiFileBreadcrumbsCollector.getLineElements(offset, file2, project, infoProvider, false);
        return pairs == null ? null : PsiFileBreadcrumbsCollector.toPsiElementArray(pairs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/breadcrumbs/PsiFileBreadcrumbsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handlesFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "watchForChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCrumbs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findProviderForElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

