/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

class NonBlockingReadActionImpl<T>
implements NonBlockingReadAction<T> {
    @Nullable
    private final Pair<ModalityState, Consumer<T>> myEdtFinish;
    @Nullable
    private final DumbService myRequireSmartMode;
    private final BooleanSupplier myExpireCondition;
    private final Callable<T> myComputation;

    NonBlockingReadActionImpl(@Nullable Pair<ModalityState, Consumer<T>> edtFinish, @Nullable DumbService requireSmartMode, @NotNull BooleanSupplier expireCondition, @NotNull Callable<T> computation) {
        if (expireCondition == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(0);
        }
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(1);
        }
        this.myEdtFinish = edtFinish;
        this.myRequireSmartMode = requireSmartMode;
        this.myExpireCondition = expireCondition;
        this.myComputation = computation;
    }

    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(2);
        }
        return new NonBlockingReadActionImpl<T>(this.myEdtFinish, DumbService.getInstance((Project)project), this.myExpireCondition, this.myComputation).expireWhen(() -> ((Project)project).isDisposed());
    }

    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        if (expireCondition == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(3);
        }
        return new NonBlockingReadActionImpl<T>(this.myEdtFinish, this.myRequireSmartMode, () -> this.myExpireCondition.getAsBoolean() || expireCondition.getAsBoolean(), this.myComputation);
    }

    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<T> uiThreadAction) {
        if (modality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(4);
        }
        if (uiThreadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(5);
        }
        return new NonBlockingReadActionImpl<T>(Pair.create((Object)modality, uiThreadAction), this.myRequireSmartMode, this.myExpireCondition, this.myComputation);
    }

    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        if (backgroundThreadExecutor == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(6);
        }
        AsyncPromise promise2 = new AsyncPromise();
        new Submission(promise2, backgroundThreadExecutor).transferToBgThread();
        return promise2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expireCondition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiThreadAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundThreadExecutor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inSmartMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expireWhen";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "finishOnUiThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "submit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class Submission {
        private final AsyncPromise<? super T> promise;
        @NotNull
        private final Executor backendExecutor;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality;

        Submission(@NotNull AsyncPromise<? super T> promise2, Executor backgroundThreadExecutor) {
            if (backgroundThreadExecutor == null) {
                Submission.$$$reportNull$$$0(0);
            }
            this.creationModality = ModalityState.defaultModalityState();
            this.promise = promise2;
            this.backendExecutor = backgroundThreadExecutor;
            promise2.onError(__ -> {
                ProgressIndicator indicator = this.currentIndicator;
                if (indicator != null) {
                    indicator.cancel();
                }
            });
        }

        void transferToBgThread() {
            this.backendExecutor.execute(() -> {
                try {
                    EmptyProgressIndicator indicator = new EmptyProgressIndicator(this.creationModality);
                    this.currentIndicator = indicator;
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.lambda$null$1((ProgressIndicator)indicator), (ProgressIndicator)indicator);
                }
                finally {
                    this.currentIndicator = null;
                }
                if (Promises.isPending(this.promise)) {
                    this.rescheduleLater();
                }
            });
        }

        private void rescheduleLater() {
            if (NonBlockingReadActionImpl.this.myRequireSmartMode != null) {
                NonBlockingReadActionImpl.this.myRequireSmartMode.runWhenSmart(this::transferToBgThread);
            } else {
                ApplicationManager.getApplication().invokeLater(this::transferToBgThread, ModalityState.any());
            }
        }

        void insideReadAction(ProgressIndicator indicator) {
            block5: {
                try {
                    if (this.checkObsolete() || !this.constraintsAreSatisfied()) {
                        return;
                    }
                    Object result2 = NonBlockingReadActionImpl.this.myComputation.call();
                    if (NonBlockingReadActionImpl.this.myEdtFinish != null) {
                        this.safeTransferToEdt(result2, NonBlockingReadActionImpl.this.myEdtFinish, indicator);
                    } else {
                        this.promise.setResult(result2);
                    }
                }
                catch (Throwable e) {
                    if (indicator.isCanceled()) break block5;
                    this.promise.setError(e);
                }
            }
        }

        private boolean constraintsAreSatisfied() {
            return NonBlockingReadActionImpl.this.myRequireSmartMode == null || !NonBlockingReadActionImpl.this.myRequireSmartMode.isDumb();
        }

        private boolean checkObsolete() {
            if (NonBlockingReadActionImpl.this.myExpireCondition.getAsBoolean()) {
                this.promise.cancel();
                return true;
            }
            return false;
        }

        void safeTransferToEdt(T result2, Pair<? extends ModalityState, ? extends Consumer<T>> edtFinish, ProgressIndicator indicator) {
            if (Promises.isRejected(this.promise)) {
                return;
            }
            Semaphore semaphore = new Semaphore(1);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.checkObsolete()) {
                    semaphore.up();
                    return;
                }
                this.promise.setResult(result2);
                semaphore.up();
                if (this.promise.isSucceeded()) {
                    ((Consumer)edtFinish.second).accept(result2);
                }
            }, (ModalityState)edtFinish.first);
            while (!semaphore.waitFor(10L)) {
                if (!indicator.isCanceled()) continue;
                throw new ProcessCanceledException();
            }
        }

        private /* synthetic */ void lambda$null$1(ProgressIndicator indicator) {
            this.insideReadAction(indicator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundThreadExecutor", "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission", "<init>"));
        }
    }
}

