/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;

class URLHandlersBundleURLConnection
extends URLConnection {
    private Felix m_framework;
    private BundleRevision m_targetRevision;
    private int m_classPathIdx = -1;
    private int m_contentLength;
    private long m_contentTime;
    private String m_contentType;
    private InputStream m_is;

    public URLHandlersBundleURLConnection(URL url) {
        super(url);
    }

    public URLHandlersBundleURLConnection(URL url, Felix framework) throws IOException {
        super(url);
        Object tmp;
        String path = url.getPath();
        if (path == null || path.length() == 0 || path.equals("/")) {
            throw new IOException("Resource does not exist: " + url);
        }
        this.m_framework = framework;
        if (this.m_framework == null && (tmp = URLHandlers.getFrameworkFromContext()) instanceof Felix) {
            this.m_framework = (Felix)tmp;
        }
        if (this.m_framework == null) {
            throw new IOException("Unable to find framework for URL: " + url);
        }
        long bundleId = Util.getBundleIdFromRevisionId(url.getHost());
        Bundle bundle = this.m_framework.getBundle(bundleId);
        if (bundle == null) {
            throw new IOException("No bundle associated with resource: " + url);
        }
        this.m_contentTime = bundle.getLastModified();
        BundleRevisions revisions = bundle.adapt(BundleRevisions.class);
        if (revisions == null || revisions.getRevisions().isEmpty()) {
            throw new IOException("Resource does not exist: " + url);
        }
        for (BundleRevision br : revisions.getRevisions()) {
            if (!((BundleRevisionImpl)br).getId().equals(url.getHost())) continue;
            this.m_targetRevision = br;
            break;
        }
        if (this.m_targetRevision == null) {
            this.m_targetRevision = revisions.getRevisions().get(0);
        }
        this.m_classPathIdx = url.getPort();
        if (this.m_classPathIdx < 0) {
            this.m_classPathIdx = 0;
        }
        if (!((BundleRevisionImpl)this.m_targetRevision).hasInputStream(this.m_classPathIdx, url.getPath())) {
            URL newurl;
            BundleWiring wiring = this.m_targetRevision.getWiring();
            ClassLoader cl = wiring != null ? wiring.getClassLoader() : null;
            URL uRL = newurl = cl != null ? cl.getResource(url.getPath()) : null;
            if (newurl == null) {
                throw new IOException("Resource does not exist: " + url);
            }
            this.m_classPathIdx = newurl.getPort();
        }
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            if (this.m_targetRevision == null || this.m_classPathIdx < 0) {
                throw new IOException("Resource does not exist: " + this.url);
            }
            this.m_is = ((BundleRevisionImpl)this.m_targetRevision).getInputStream(this.m_classPathIdx, this.url.getPath());
            this.m_contentLength = this.m_is == null ? 0 : this.m_is.available();
            this.m_contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.m_is;
    }

    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return -1;
        }
        return this.m_contentLength;
    }

    public long getLastModified() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return 0L;
        }
        if (this.m_contentTime != -1L) {
            return this.m_contentTime;
        }
        return 0L;
    }

    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return null;
        }
        return this.m_contentType;
    }

    public Permission getPermission() {
        return null;
    }

    URL getLocalURL() {
        if (this.m_targetRevision == null || this.m_classPathIdx < 0) {
            return this.url;
        }
        return ((BundleRevisionImpl)this.m_targetRevision).getLocalURL(this.m_classPathIdx, this.url.getPath());
    }
}

