/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.protege.editor.core.ui.view.button.ViewButtonUI;

public class ViewBanner
extends JPanel {
    private final JPanel toolBarPanel;
    private final JPanel labelPanel;
    private final JLabel label = new JLabel();
    private final JToolBar toolBar = new JToolBar();
    private final Color foregroundColor = Color.WHITE;
    private Color backgroundColor;
    private String labelText;
    private Color defaultBackgroundColor;

    public ViewBanner(@Nonnull String labelText, @Nonnull Color bannerColor) {
        this.labelText = (String)Preconditions.checkNotNull((Object)labelText);
        this.defaultBackgroundColor = (Color)Preconditions.checkNotNull((Object)bannerColor);
        this.backgroundColor = bannerColor;
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(this.backgroundColor);
        this.labelPanel = new JPanel(new BorderLayout());
        this.add((Component)this.labelPanel, "North");
        this.labelPanel.setBackground(null);
        this.labelPanel.setOpaque(true);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.label.setForeground(this.foregroundColor);
        this.setText("");
        this.toolBar.setBorderPainted(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setOpaque(false);
        this.toolBarPanel = new JPanel(new BorderLayout());
        this.toolBarPanel.add((Component)this.toolBar, "East");
        this.toolBarPanel.setOpaque(true);
        this.toolBarPanel.setBackground(this.backgroundColor);
        this.labelPanel.add((Component)this.toolBarPanel, "East");
        this.labelPanel.add((Component)this.label, "West");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public void setText(@Nonnull String text) {
        this.label.setForeground(this.foregroundColor);
        this.label.setText(this.labelText + ": " + text);
    }

    public void setBannerColor(Color color) {
        this.backgroundColor = color;
        this.labelPanel.setBackground(this.backgroundColor);
        this.toolBarPanel.setBackground(this.backgroundColor);
        this.revalidate();
    }

    public void setPinned(boolean pinned) {
        if (pinned) {
            this.setBannerColor(Color.GRAY);
        } else {
            this.setBannerColor(this.defaultBackgroundColor);
        }
    }

    public void removeAllActions() {
        this.toolBar.removeAll();
    }

    public void addAction(@Nonnull String name, @Nonnull Icon icon, final @Nonnull Runnable runnable) {
        this.addAction(new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                runnable.run();
            }
        });
    }

    public void addAction(@Nonnull Action action) {
        String name = (String)action.getValue("Name");
        action.putValue("Name", "");
        action.putValue("ShortDescription", name);
        JButton button = new JButton(action){

            @Override
            public void updateUI() {
            }
        };
        button.setFocusable(false);
        this.toolBar.add(button);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            button.setPreferredSize(new Dimension(icon.getIconWidth() + 2, icon.getIconHeight()));
            button.setOpaque(false);
            button.setUI(new ViewButtonUI());
            button.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        }
    }
}

