#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.7.1
id: pandoc-2.7.1-FbEiwdLaPlmKoWq4Q4sjwh
key: pandoc-2.7.1-FbEiwdLaPlmKoWq4Q4sjwh
license: GPL-2.0-only
copyright: (c) 2006-2018 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
author: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: https://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook, JATS,
    MediaWiki markup, DokuWiki markup, TWiki markup,
    TikiWiki markup, Creole 1.0, Haddock markup, OPML,
    Emacs Org-Mode, Emacs Muse, txt2tags, ipynb (Jupyter
    notebooks), Vimwiki, Word Docx, ODT, EPUB, FictionBook2,
    roff man, and Textile, and it can write Markdown,
    reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt, DocBook,
    JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    PowerPoint pptx, RTF, MediaWiki, DokuWiki, ZimWiki, Textile,
    roff man, roff ms, plain text, Emacs Org-Mode,
    AsciiDoc, Haddock markup, EPUB (v2 and v3), ipynb,
    FictionBook2, InDesign ICML, Muse, LaTeX beamer slides,
    and several kinds of HTML/JavaScript slide shows
    (S5, Slidy, Slideous, DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
abi: 5fe996a72dcd10f021a8c6ce4d91353e
exposed: True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.DokuWiki Text.Pandoc.Readers.EPUB
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Odt
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Vimwiki Text.Pandoc.SelfContained
    Text.Pandoc.Shared Text.Pandoc.Templates Text.Pandoc.UTF8
    Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.Ipynb
    Text.Pandoc.Writers.JATS Text.Pandoc.Writers.LaTeX
    Text.Pandoc.Writers.Man Text.Pandoc.Writers.Markdown
    Text.Pandoc.Writers.Math Text.Pandoc.Writers.MediaWiki
    Text.Pandoc.Writers.Ms Text.Pandoc.Writers.Muse
    Text.Pandoc.Writers.Native Text.Pandoc.Writers.ODT
    Text.Pandoc.Writers.OOXML Text.Pandoc.Writers.OPML
    Text.Pandoc.Writers.OpenDocument Text.Pandoc.Writers.Org
    Text.Pandoc.Writers.Powerpoint Text.Pandoc.Writers.RST
    Text.Pandoc.Writers.RTF Text.Pandoc.Writers.Shared
    Text.Pandoc.Writers.TEI Text.Pandoc.Writers.Texinfo
    Text.Pandoc.Writers.Textile Text.Pandoc.Writers.ZimWiki
    Text.Pandoc.XML
hidden-modules: Text.Pandoc.App.CommandLineOptions
                Text.Pandoc.App.FormatHeuristics Text.Pandoc.App.Opt
                Text.Pandoc.App.OutputSettings Text.Pandoc.Filter.JSON
                Text.Pandoc.Filter.Lua Text.Pandoc.Filter.Path
                Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
                Text.Pandoc.Readers.Docx.Parse Text.Pandoc.Readers.Docx.Util
                Text.Pandoc.Readers.Docx.StyleMap Text.Pandoc.Readers.Docx.Fields
                Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.Lang
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Roff
                Text.Pandoc.Writers.Roff
                Text.Pandoc.Writers.Powerpoint.Presentation
                Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.Global Text.Pandoc.Lua.Init
                Text.Pandoc.Lua.Marshaling Text.Pandoc.Lua.Marshaling.AST
                Text.Pandoc.Lua.Marshaling.AnyValue
                Text.Pandoc.Lua.Marshaling.CommonState
                Text.Pandoc.Lua.Marshaling.ReaderOptions
                Text.Pandoc.Lua.Module.MediaBag Text.Pandoc.Lua.Module.Pandoc
                Text.Pandoc.Lua.Module.Utils Text.Pandoc.Lua.Packages
                Text.Pandoc.Lua.Util Text.Pandoc.CSS Text.Pandoc.CSV
                Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Translations
                Text.Pandoc.Slides Paths_pandoc
import-dirs: /usr/lib/ghc-8.6.4/site-local/pandoc-2.7.1
library-dirs: /usr/lib/ghc-8.6.4/site-local/pandoc-2.7.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.7.1-FbEiwdLaPlmKoWq4Q4sjwh
depends:
    Glob-0.10.0-14GRnAxrpa520qabOGkfDr
    HTTP-4000.3.13-GOlpEl7k74dDgnW3L98FwN
    HsYAML-0.1.1.3-CZwOAqq0PGhF0wuM0juU0O
    JuicyPixels-3.3.3-IhezgPVvveh12qZ19Vtshl
    SHA-1.6.4.4-1GMMHy6WdrlGpMrtGTWHUv
    aeson-1.4.2.0-QHLwhPMHVB663aXnGqoMq
    aeson-pretty-0.8.7-DxY5A687y6y356D4oJ8MGA base-4.12.0.0
    base64-bytestring-1.0.0.2-EJ1mkGsqs004EmS9lh2uZC binary-0.8.6.0
    blaze-html-0.9.1.1-A8LR7w4yS96GtRVO7i7OSl
    blaze-markup-0.8.2.2-IwLwNWRUxfsEuYbkQ0Gv5Q bytestring-0.10.8.2
    case-insensitive-1.2.0.11-F6T6GvbsLJXGLQlCHITWZu
    cmark-gfm-0.1.8-CpZzso6t8VbJNHXpyyxfZL containers-0.6.0.1
    data-default-0.7.1.1-3C0tdSCD1lzIk8WkrvBOoZ deepseq-1.4.4.0
    directory-1.3.3.0 doctemplates-0.2.2.1-2b0AKWSAHMk6Jafm2JCTOy
    exceptions-0.10.1-7nkghZ77rTO8NZKanvk3XU filepath-1.4.2.1
    haddock-library-1.7.0-WOZd7yalWlG1siytN885s
    hslua-1.0.2-7qYUI7LLgN8AwSwv0KlCQ5
    hslua-module-text-0.2.0-LDVM5b7BRJc82PtKyKrCAE
    http-client-0.6.2-LkdikXUur819X7odXhCFpW
    http-client-tls-0.3.5.3-JYqdRFVMkT9EtGJ46325uO
    http-types-0.12.3-IdIFkPvozmRFdXetXaEgxE
    ipynb-0.1-2xSXsVgSy3A7taLXk2b4ws mtl-2.2.2
    network-2.8.0.0-58b93NZ1Nmb3T9F5Ys3Y7W
    network-uri-2.6.1.0-K75fCYvLQE41EntOQ30cqK
    pandoc-types-1.17.5.4-6coIUqfAq074o6GB1kIQ4N parsec-3.1.13.0
    process-1.6.5.0 random-1.1-3ypV4EIycgb35PKjTYYr5q
    safe-0.3.17-43oyx4B630gDZMbTh3Ttji
    skylighting-0.7.7-FQboPfcH4jyCr0BJ8xdHGz
    split-0.2.3.3-DmDMlgWSMW26OczFIiZ5Gr syb-0.7-KRW1LCxdMiCJrmhxCvzo37
    tagsoup-0.14.7-8jQ2M3XvdSaFmtlOslDJPe
    temporary-1.3-CEDKPgoVKCHF00YNO7o77i
    texmath-0.11.2.2-WtiYD40MJMHra5B7Z4GyT text-1.2.3.1 time-1.8.0.2
    unicode-transforms-0.3.5-Fz3EZHFdCO2JA30k1ZdjUR unix-2.7.2.2
    unordered-containers-0.2.10.0-5bnYBnE7Vkj9Kd62fWith8
    vector-0.12.0.2-AoZ9EwUsgIW1yrOc105QXH
    xml-1.3.14-ESp8cJy4XJ8BJKfvGeNymT
    zip-archive-0.4-DkStgrFwCud2BIIGeFSbUj
    zlib-0.6.2-3orZ4PtYssfHtZIGrJhHYA
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

