/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.util.SQLTypeUtil;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.SQLType;

class DbSchemaEntityMember
extends EntityMember {
    private boolean isPrimaryKey;
    private boolean isAutoIncrement;
    private SQLType sqlType;
    private Integer length;
    private Integer precision;
    private Integer scale;
    private ColumnElement columnElement;

    public DbSchemaEntityMember(ColumnElement element) {
        this.columnElement = element;
        this.sqlType = SQLType.getSQLType(element.getType());
        this.setMemberName(DbSchemaEntityMember.makeFieldName(element.getName().getName()));
        this.isPrimaryKey = false;
        this.isAutoIncrement = element.isAutoIncrement();
        this.setMemberType(this.sqlType.getMemberType(element));
        if (element.isCharacterType()) {
            this.length = element.getLength();
        }
        if (element.isNumericType()) {
            this.precision = element.getPrecision();
            this.scale = element.getScale();
        }
    }

    @Override
    public boolean isNullable() {
        return this.columnElement.isNullable();
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    @Override
    public void setPrimaryKey(boolean isPk, boolean isPkField) {
        this.isPrimaryKey = isPk;
        if (isPkField) {
            this.setMemberType(this.getRespectiveNonPrimitiveType());
        }
    }

    private String getRespectiveNonPrimitiveType() {
        String type = this.getMemberType();
        if ("int".equals(type)) {
            return Integer.class.getName();
        }
        if ("long".equals(type)) {
            return Long.class.getName();
        }
        if ("short".equals(type)) {
            return Short.class.getName();
        }
        if ("byte".equals(type)) {
            return Byte.class.getName();
        }
        if ("double".equals(type)) {
            return Double.class.getName();
        }
        if ("float".equals(type)) {
            return Float.class.getName();
        }
        if ("char".equals(type)) {
            return Character.class.getName();
        }
        return this.sqlType.getFirstNonPrimitiveType();
    }

    private ColumnElement getColumnElement() {
        return this.columnElement;
    }

    @Override
    public boolean supportsFinder() {
        return this.sqlType.supportsFinder();
    }

    @Override
    public String getColumnName() {
        return this.getColumnElement().getName().getName();
    }

    @Override
    public String getTableName() {
        return this.getColumnElement().getDeclaringTable().getName().getName();
    }

    @Override
    public boolean isLobType() {
        return SQLTypeUtil.isLob((int)this.getColumnElement().getType());
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }
}

