/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.AbstractObject;

public class Breakpoint
extends AbstractObject {
    public static final String PROP_LOCATION = "location";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JSONObject location;

    Breakpoint(JSONObject object, WebKitDebugging webkit) {
        super(object, webkit);
    }

    public String getBreakpointID() {
        return (String)this.getObject().get((Object)"breakpointId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getBreakpointLocation() {
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            JSONArray locations;
            if (this.location == null && !(locations = (JSONArray)this.getObject().get((Object)"locations")).isEmpty()) {
                this.location = (JSONObject)locations.get(0);
            }
            return this.location;
        }
    }

    public long getLineNumber() {
        JSONObject location = this.getBreakpointLocation();
        if (location != null) {
            return (Long)location.get((Object)"lineNumber");
        }
        return -1L;
    }

    public long getColumnNumber() {
        JSONObject location = this.getBreakpointLocation();
        Long col = null;
        if (location != null) {
            col = (Long)location.get((Object)"columnNumber");
        }
        if (col == null) {
            return 0L;
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyResolved(JSONObject location) {
        JSONObject oldLocation;
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            oldLocation = this.location;
            this.location = location;
        }
        this.pcs.firePropertyChange(PROP_LOCATION, oldLocation, location);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }
}

