/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.TestEntry;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class UpdateTrackingFileOwnerQuery
implements FileOwnerQueryImplementation {
    public Project getOwner(URI file) {
        if (!ModuleList.existKnownEntries()) {
            return null;
        }
        if (file.getScheme().equals("file")) {
            return this.getOwner(Utilities.toFile((URI)file));
        }
        return null;
    }

    public Project getOwner(FileObject file) {
        if (!ModuleList.existKnownEntries()) {
            return null;
        }
        File f = FileUtil.toFile((FileObject)file);
        if (f != null) {
            return this.getOwner(f);
        }
        return null;
    }

    private Project getOwner(File file) {
        Project p;
        for (ModuleEntry entry : ModuleList.getKnownEntries(file)) {
            FileObject sourcedirFO;
            File sourcedir = entry.getSourceLocation();
            if (sourcedir == null || (sourcedirFO = FileUtil.toFileObject((File)sourcedir)) == null) continue;
            try {
                Project p2 = ProjectManager.getDefault().findProject(sourcedirFO);
                if (p2 == null) continue;
                return p2;
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        TestEntry test = TestEntry.get(file);
        if (test != null && (p = test.getProject()) != null) {
            return p;
        }
        return null;
    }
}

