/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.options.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.options.ui.Bundle;
import org.openide.awt.Mnemonics;

public final class ProfilerOptionsPanel
extends JPanel
implements ActionListener {
    private JButton oomeDetectionChooseDirButton;
    private JButton resetConfirmationsButton;
    private JCheckBox cpuLiveResultsCheckbox;
    private JCheckBox enableHeapWalkerAnalysisCheckbox;
    private JCheckBox memoryLiveResultsCheckbox;
    private JComboBox oomeCombo;
    private JComboBox openThreadsViewCombo;
    private JLabel onlyThreadsEnabledLabel;
    private JComboBox openLocksViewCombo;
    private JLabel onlyContentionEnabledLabel;
    private JComboBox takingSnapshotCombo;
    private JComboBox telemetryOverviewCombo;
    private JExtendedSpinner portNoSpinner;
    private JTextField oomeDetectionDirTextField;

    public ProfilerOptionsPanel() {
        this.initComponents();
    }

    public JavaPlatform getSelectedJavaPlatform() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resetConfirmationsButton) {
            ProfilerIDESettings.getInstance().clearDoNotShowAgainMap();
            this.resetConfirmationsButton.setEnabled(false);
        } else if (e.getSource() == this.oomeDetectionChooseDirButton) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(this.oomeDetectionDirTextField.getText()));
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogType(0);
            chooser.setDialogTitle(Bundle.ProfilerOptionsPanel_ChooseDumpDirCaption());
            if (chooser.showOpenDialog(SwingUtilities.getRoot(this)) == 0) {
                this.oomeDetectionDirTextField.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    public void applySettings(ProfilerIDESettings pis) {
        pis.setPortNo(((Number)this.portNoSpinner.getValue()).intValue());
        pis.setDisplayLiveResultsCPU(this.cpuLiveResultsCheckbox.isSelected());
        pis.setDisplayLiveResultsMemory(this.memoryLiveResultsCheckbox.isSelected());
        Object takingSnapshotSelected = this.takingSnapshotCombo.getSelectedItem();
        pis.setAutoOpenSnapshot(Bundle.ProfilerOptionsPanel_OpenSnapshotRadioText().equals(takingSnapshotSelected) || Bundle.ProfilerOptionsPanel_OpenSaveSnapshotRadioText().equals(takingSnapshotSelected));
        pis.setAutoSaveSnapshot(Bundle.ProfilerOptionsPanel_SaveSnapshotRadioText().equals(takingSnapshotSelected) || Bundle.ProfilerOptionsPanel_OpenSaveSnapshotRadioText().equals(takingSnapshotSelected));
        Object oomeSelected = this.oomeCombo.getSelectedItem();
        if (Bundle.ProfilerOptionsPanel_OomeNothingText().equals(oomeSelected)) {
            pis.setOOMDetectionMode(0);
        } else if (Bundle.ProfilerOptionsPanel_OomeProjectText().equals(oomeSelected)) {
            pis.setOOMDetectionMode(1);
        } else if (Bundle.ProfilerOptionsPanel_OomeTempText().equals(oomeSelected)) {
            pis.setOOMDetectionMode(2);
        } else if (Bundle.ProfilerOptionsPanel_OomeCustomText().equals(oomeSelected)) {
            pis.setOOMDetectionMode(3);
        }
        pis.setCustomHeapdumpPath(this.oomeDetectionDirTextField.getText());
        pis.setHeapWalkerAnalysisEnabled(this.enableHeapWalkerAnalysisCheckbox.isSelected());
        if (Bundle.ProfilerOptionsPanel_KeyOpenAlways().equals(this.telemetryOverviewCombo.getSelectedItem())) {
            pis.setTelemetryOverviewBehavior(1);
        } else if (Bundle.ProfilerOptionsPanel_KeyOpenMonitoring().equals(this.telemetryOverviewCombo.getSelectedItem())) {
            pis.setTelemetryOverviewBehavior(2);
        } else {
            pis.setTelemetryOverviewBehavior(3);
        }
        if (Bundle.ProfilerOptionsPanel_KeyOpenAlways().equals(this.openThreadsViewCombo.getSelectedItem())) {
            pis.setThreadsViewBehavior(1);
        } else if (Bundle.ProfilerOptionsPanel_KeyOpenMonitoring().equals(this.openThreadsViewCombo.getSelectedItem())) {
            pis.setThreadsViewBehavior(2);
        } else {
            pis.setThreadsViewBehavior(3);
        }
        if (Bundle.ProfilerOptionsPanel_KeyOpenAlways().equals(this.openLocksViewCombo.getSelectedItem())) {
            pis.setLockContentionViewBehavior(1);
        } else if (Bundle.ProfilerOptionsPanel_KeyOpenMonitoring().equals(this.openLocksViewCombo.getSelectedItem())) {
            pis.setLockContentionViewBehavior(2);
        } else {
            pis.setLockContentionViewBehavior(3);
        }
    }

    public boolean currentSettingsEquals(ProfilerIDESettings settings) {
        if (((Number)this.portNoSpinner.getValue()).intValue() != settings.getPortNo()) {
            return false;
        }
        if (this.cpuLiveResultsCheckbox.isSelected() != settings.getDisplayLiveResultsCPU()) {
            return false;
        }
        if (this.memoryLiveResultsCheckbox.isSelected() != settings.getDisplayLiveResultsMemory()) {
            return false;
        }
        if (settings.getAutoOpenSnapshot() && settings.getAutoSaveSnapshot() && !Bundle.ProfilerOptionsPanel_OpenSaveSnapshotRadioText().equals(this.takingSnapshotCombo.getSelectedItem())) {
            return false;
        }
        if (settings.getAutoOpenSnapshot() && !Bundle.ProfilerOptionsPanel_OpenSnapshotRadioText().equals(this.takingSnapshotCombo.getSelectedItem())) {
            return false;
        }
        if (settings.getAutoSaveSnapshot() && !Bundle.ProfilerOptionsPanel_SaveSnapshotRadioText().equals(this.takingSnapshotCombo.getSelectedItem())) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 0 && !Bundle.ProfilerOptionsPanel_OomeNothingText().equals(this.oomeCombo.getSelectedItem())) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 1 && !Bundle.ProfilerOptionsPanel_OomeProjectText().equals(this.oomeCombo.getSelectedItem())) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 2 && !Bundle.ProfilerOptionsPanel_OomeTempText().equals(this.oomeCombo.getSelectedItem())) {
            return false;
        }
        if (settings.getOOMDetectionMode() == 3 && !Bundle.ProfilerOptionsPanel_OomeCustomText().equals(this.oomeCombo.getSelectedItem())) {
            return false;
        }
        if (!this.oomeDetectionDirTextField.getText().equals(settings.getCustomHeapdumpPath())) {
            return false;
        }
        if (Bundle.ProfilerOptionsPanel_KeyOpenAlways().equals(this.telemetryOverviewCombo.getSelectedItem()) ? settings.getTelemetryOverviewBehavior() != 1 : (Bundle.ProfilerOptionsPanel_KeyOpenMonitoring().equals(this.telemetryOverviewCombo.getSelectedItem()) ? settings.getTelemetryOverviewBehavior() != 2 : Bundle.ProfilerOptionsPanel_KeyOpenNever().equals(this.telemetryOverviewCombo.getSelectedItem()) && settings.getTelemetryOverviewBehavior() != 3)) {
            return false;
        }
        if (Bundle.ProfilerOptionsPanel_KeyOpenAlways().equals(this.openThreadsViewCombo.getSelectedItem()) ? settings.getThreadsViewBehavior() != 1 : (Bundle.ProfilerOptionsPanel_KeyOpenMonitoring().equals(this.openThreadsViewCombo.getSelectedItem()) ? settings.getThreadsViewBehavior() != 2 : Bundle.ProfilerOptionsPanel_KeyOpenNever().equals(this.openThreadsViewCombo.getSelectedItem()) && settings.getThreadsViewBehavior() != 3)) {
            return false;
        }
        if (Bundle.ProfilerOptionsPanel_KeyOpenAlways().equals(this.openLocksViewCombo.getSelectedItem()) ? settings.getLockContentionViewBehavior() != 1 : (Bundle.ProfilerOptionsPanel_KeyOpenMonitoring().equals(this.openLocksViewCombo.getSelectedItem()) ? settings.getLockContentionViewBehavior() != 2 : Bundle.ProfilerOptionsPanel_KeyOpenNever().equals(this.openLocksViewCombo.getSelectedItem()) && settings.getLockContentionViewBehavior() != 3)) {
            return false;
        }
        return settings.getHeapWalkerAnalysisEnabled() == this.enableHeapWalkerAnalysisCheckbox.isSelected();
    }

    public void init(ProfilerIDESettings pis) {
        this.resetConfirmationsButton.setEnabled(true);
        this.portNoSpinner.setValue((Object)pis.getPortNo());
        this.cpuLiveResultsCheckbox.setSelected(pis.getDisplayLiveResultsCPU());
        this.memoryLiveResultsCheckbox.setSelected(pis.getDisplayLiveResultsMemory());
        if (pis.getAutoOpenSnapshot() && pis.getAutoSaveSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_OpenSaveSnapshotRadioText());
        } else if (pis.getAutoOpenSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_OpenSnapshotRadioText());
        } else if (pis.getAutoSaveSnapshot()) {
            this.takingSnapshotCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_SaveSnapshotRadioText());
        }
        if (pis.getOOMDetectionMode() == 0) {
            this.oomeCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_OomeNothingText());
        } else if (pis.getOOMDetectionMode() == 1) {
            this.oomeCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_OomeProjectText());
        } else if (pis.getOOMDetectionMode() == 2) {
            this.oomeCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_OomeTempText());
        } else if (pis.getOOMDetectionMode() == 3) {
            this.oomeCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_OomeCustomText());
        }
        this.oomeDetectionDirTextField.setText(pis.getCustomHeapdumpPath());
        this.enableHeapWalkerAnalysisCheckbox.setSelected(pis.getHeapWalkerAnalysisEnabled());
        switch (pis.getTelemetryOverviewBehavior()) {
            case 1: {
                this.telemetryOverviewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenAlways());
                break;
            }
            case 2: {
                this.telemetryOverviewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenMonitoring());
                break;
            }
            default: {
                this.telemetryOverviewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenNever());
            }
        }
        switch (pis.getThreadsViewBehavior()) {
            case 1: {
                this.openThreadsViewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenAlways());
                break;
            }
            case 2: {
                this.openThreadsViewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenMonitoring());
                break;
            }
            default: {
                this.openThreadsViewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenNever());
            }
        }
        switch (pis.getLockContentionViewBehavior()) {
            case 1: {
                this.openLocksViewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenAlways());
                break;
            }
            case 2: {
                this.openLocksViewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenMonitoring());
                break;
            }
            default: {
                this.openLocksViewCombo.setSelectedItem(Bundle.ProfilerOptionsPanel_KeyOpenNever());
            }
        }
        this.updateEnabling();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup oomeRadiosGroup = new ButtonGroup();
        CategorySeparator generalSeparator = new CategorySeparator(Bundle.ProfilerOptionsPanel_EngineSettingsBorderText(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 6);
        this.add((Component)generalSeparator, gridBagConstraints);
        JLabel portNoLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)portNoLabel, (String)Bundle.ProfilerOptionsPanel_CommPortLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)portNoLabel, gridBagConstraints);
        this.portNoSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        portNoLabel.setLabelFor((Component)this.portNoSpinner);
        if (this.portNoSpinner.getAccessibleContext() != null) {
            this.portNoSpinner.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_PortNoSpinnerAccessDescr());
        }
        this.portNoSpinner.fixAccessibility();
        this.portNoSpinner.setModel((SpinnerModel)new SpinnerNumberModel(5140, 1, 65535, 1));
        this.portNoSpinner.setPreferredSize(new Dimension(this.portNoSpinner.getPreferredSize().width, new JComboBox<E>().getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.portNoSpinner, gridBagConstraints);
        CategorySeparator profilingStartSeparator = new CategorySeparator(Bundle.ProfilerOptionsPanel_WindowsSettingsBorderText(), true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 0, 0, 6);
        this.add((Component)profilingStartSeparator, gridBagConstraints);
        JLabel telemetryOverviewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)telemetryOverviewLabel, (String)Bundle.ProfilerOptionsPanel_TelemetryOverviewLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)telemetryOverviewLabel, gridBagConstraints);
        this.telemetryOverviewCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        telemetryOverviewLabel.setLabelFor(this.telemetryOverviewCombo);
        this.telemetryOverviewCombo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_TelemetryOverviewComboAccessDescr());
        this.telemetryOverviewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.ProfilerOptionsPanel_KeyOpenAlways(), Bundle.ProfilerOptionsPanel_KeyOpenMonitoring(), Bundle.ProfilerOptionsPanel_KeyOpenNever()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.telemetryOverviewCombo, gridBagConstraints);
        JLabel openThreadsViewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)openThreadsViewLabel, (String)Bundle.ProfilerOptionsPanel_ThreadsViewLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)openThreadsViewLabel, gridBagConstraints);
        this.openThreadsViewCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void fireActionEvent() {
                ProfilerOptionsPanel.this.onlyThreadsEnabledLabel.setVisible(!Bundle.ProfilerOptionsPanel_KeyOpenNever().equals(this.getSelectedItem()));
            }
        };
        openThreadsViewLabel.setLabelFor(this.openThreadsViewCombo);
        this.openThreadsViewCombo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_ThreadsViewComboAccessDescr() + Bundle.ProfilerOptionsPanel_ThreadsViewHintText());
        this.openThreadsViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.ProfilerOptionsPanel_KeyOpenAlways(), Bundle.ProfilerOptionsPanel_KeyOpenMonitoring(), Bundle.ProfilerOptionsPanel_KeyOpenNever()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.openThreadsViewCombo, gridBagConstraints);
        this.onlyThreadsEnabledLabel = new JLabel(Bundle.ProfilerOptionsPanel_IfThreadsMonitoringEnabledHint());
        this.onlyThreadsEnabledLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.onlyThreadsEnabledLabel, gridBagConstraints);
        JLabel openLocksViewLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)openLocksViewLabel, (String)Bundle.ProfilerOptionsPanel_LocksViewLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)openLocksViewLabel, gridBagConstraints);
        this.openLocksViewCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            protected void fireActionEvent() {
                ProfilerOptionsPanel.this.onlyContentionEnabledLabel.setVisible(!Bundle.ProfilerOptionsPanel_KeyOpenNever().equals(this.getSelectedItem()));
            }
        };
        openLocksViewLabel.setLabelFor(this.openLocksViewCombo);
        this.openLocksViewCombo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_LocksViewComboAccessDescr() + Bundle.ProfilerOptionsPanel_LocksViewHintText());
        this.openLocksViewCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.ProfilerOptionsPanel_KeyOpenAlways(), Bundle.ProfilerOptionsPanel_KeyOpenMonitoring(), Bundle.ProfilerOptionsPanel_KeyOpenNever()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.openLocksViewCombo, gridBagConstraints);
        this.onlyContentionEnabledLabel = new JLabel(Bundle.ProfilerOptionsPanel_IfLockContentionMonitoringEnabledHint());
        this.onlyContentionEnabledLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.onlyContentionEnabledLabel, gridBagConstraints);
        int maxWidth = Math.max(this.telemetryOverviewCombo.getPreferredSize().width, this.openThreadsViewCombo.getPreferredSize().width);
        maxWidth = Math.max(maxWidth, this.openLocksViewCombo.getPreferredSize().width) + 15;
        int maxHeight = Math.max(this.telemetryOverviewCombo.getPreferredSize().height, this.openThreadsViewCombo.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.openLocksViewCombo.getPreferredSize().height);
        this.telemetryOverviewCombo.setPreferredSize(new Dimension(maxWidth, maxHeight));
        this.openThreadsViewCombo.setPreferredSize(new Dimension(maxWidth, maxHeight));
        this.openLocksViewCombo.setPreferredSize(new Dimension(maxWidth, maxHeight));
        JLabel liveResultsLabel = new JLabel(Bundle.ProfilerOptionsPanel_LiveResultsLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)liveResultsLabel, gridBagConstraints);
        JPanel liveResultsPanel = new JPanel();
        liveResultsPanel.setLayout(new GridLayout(1, 2, 0, 0));
        this.cpuLiveResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.cpuLiveResultsCheckbox, (String)Bundle.ProfilerOptionsPanel_CpuChckBoxText());
        this.cpuLiveResultsCheckbox.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_CpuLiveResultsCheckboxAccessDescr());
        liveResultsPanel.add(this.cpuLiveResultsCheckbox);
        this.memoryLiveResultsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.memoryLiveResultsCheckbox, (String)Bundle.ProfilerOptionsPanel_MemoryChckBoxText());
        this.memoryLiveResultsCheckbox.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_MemoryLiveResultsCheckboxAccessDescr());
        liveResultsPanel.add(this.memoryLiveResultsCheckbox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)liveResultsPanel, gridBagConstraints);
        CategorySeparator miscellaneousSeparator = new CategorySeparator(Bundle.ProfilerOptionsPanel_SnapshotsSettingsBorderText(), true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)miscellaneousSeparator, gridBagConstraints);
        JLabel takingSnapshotLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)takingSnapshotLabel, (String)Bundle.ProfilerOptionsPanel_TakingSnapshotLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)takingSnapshotLabel, gridBagConstraints);
        this.takingSnapshotCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        takingSnapshotLabel.setLabelFor(this.takingSnapshotCombo);
        this.takingSnapshotCombo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_TakingSnapshotComboAccessDescr());
        this.takingSnapshotCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.ProfilerOptionsPanel_OpenSnapshotRadioText(), Bundle.ProfilerOptionsPanel_SaveSnapshotRadioText(), Bundle.ProfilerOptionsPanel_OpenSaveSnapshotRadioText()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.takingSnapshotCombo, gridBagConstraints);
        JLabel oomeDetectionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)oomeDetectionLabel, (String)Bundle.ProfilerOptionsPanel_OomeBorderText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)oomeDetectionLabel, gridBagConstraints);
        this.oomeCombo = new JComboBox(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        oomeDetectionLabel.setLabelFor(this.oomeCombo);
        this.oomeCombo.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_OomeComboAccessDescr());
        this.oomeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProfilerOptionsPanel.this.updateEnabling();
            }
        });
        this.oomeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.ProfilerOptionsPanel_OomeNothingText(), Bundle.ProfilerOptionsPanel_OomeProjectText(), Bundle.ProfilerOptionsPanel_OomeTempText(), Bundle.ProfilerOptionsPanel_OomeCustomText()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.oomeCombo, gridBagConstraints);
        int maxWidth1 = Math.max(this.takingSnapshotCombo.getPreferredSize().width, this.oomeCombo.getPreferredSize().width);
        int maxHeight1 = Math.max(this.takingSnapshotCombo.getPreferredSize().height, this.oomeCombo.getPreferredSize().height);
        this.takingSnapshotCombo.setPreferredSize(new Dimension(maxWidth1, maxHeight1));
        this.oomeCombo.setPreferredSize(new Dimension(maxWidth1, maxHeight1));
        JPanel oomeDetectionPanel = new JPanel(new GridBagLayout());
        this.oomeDetectionDirTextField = new JTextField(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, ((ProfilerOptionsPanel)ProfilerOptionsPanel.this).oomeDetectionChooseDirButton.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
            }
        };
        this.oomeDetectionDirTextField.getAccessibleContext().setAccessibleName(Bundle.ProfilerOptionsPanel_OomeCustomAccessDescr());
        this.oomeDetectionDirTextField.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_OomeCustomTextfieldAccessDescr());
        this.oomeDetectionDirTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        oomeDetectionPanel.add((Component)this.oomeDetectionDirTextField, gridBagConstraints);
        this.oomeDetectionChooseDirButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.oomeDetectionChooseDirButton, (String)"&...");
        this.oomeDetectionChooseDirButton.getAccessibleContext().setAccessibleName(Bundle.ProfilerOptionsPanel_OomeCustomButtonAccessName());
        this.oomeDetectionChooseDirButton.addActionListener(this);
        this.oomeDetectionChooseDirButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.anchor = 17;
        oomeDetectionPanel.add((Component)this.oomeDetectionChooseDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)oomeDetectionPanel, gridBagConstraints);
        JLabel heapWalkerLabel = new JLabel(Bundle.ProfilerOptionsPanel_HeapWalkerLabelText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)heapWalkerLabel, gridBagConstraints);
        this.enableHeapWalkerAnalysisCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.enableHeapWalkerAnalysisCheckbox, (String)Bundle.ProfilerOptionsPanel_EnableAnalysisCheckbox());
        this.enableHeapWalkerAnalysisCheckbox.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_EnableAnalysisCheckbox());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)this.enableHeapWalkerAnalysisCheckbox, gridBagConstraints);
        JPanel resetConfirmationsPanel = new JPanel(new GridBagLayout());
        JTextArea resetConfirmationsArea = new JTextArea(Bundle.ProfilerOptionsPanel_ResetHintText()){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = 1;
                return size;
            }
        };
        resetConfirmationsArea.setOpaque(false);
        resetConfirmationsArea.setWrapStyleWord(true);
        resetConfirmationsArea.setLineWrap(true);
        resetConfirmationsArea.setEnabled(false);
        resetConfirmationsArea.setFont(UIManager.getFont("Label.font"));
        resetConfirmationsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        resetConfirmationsArea.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        resetConfirmationsPanel.add((Component)resetConfirmationsArea, gridBagConstraints);
        this.resetConfirmationsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.resetConfirmationsButton, (String)Bundle.ProfilerOptionsPanel_ResetButtonName());
        this.resetConfirmationsButton.getAccessibleContext().setAccessibleDescription(Bundle.ProfilerOptionsPanel_ResetHintText());
        this.resetConfirmationsButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        resetConfirmationsPanel.add((Component)this.resetConfirmationsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 6);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)resetConfirmationsPanel, gridBagConstraints);
    }

    private void updateEnabling() {
        boolean customOOMEdirSelected = Bundle.ProfilerOptionsPanel_OomeCustomText().equals(this.oomeCombo.getSelectedItem());
        this.oomeDetectionDirTextField.setEnabled(customOOMEdirSelected);
        this.oomeDetectionChooseDirButton.setEnabled(customOOMEdirSelected);
    }

    private static class CategorySeparator
    extends JPanel {
        private JLabel captionLabel;
        private JSeparator captionSeparator;
        private boolean addSpaceBefore;

        public CategorySeparator(String caption, boolean addSpaceBefore) {
            this.addSpaceBefore = addSpaceBefore;
            this.initComponents();
            this.captionLabel.setText(caption);
        }

        private void initComponents() {
            GridBagConstraints constraints;
            this.setLayout(new GridBagLayout());
            if (this.addSpaceBefore) {
                JLabel emptyLabel = new JLabel(" ");
                constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.anchor = 17;
                constraints.fill = 1;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)emptyLabel, constraints);
            }
            this.captionLabel = new JLabel();
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = this.addSpaceBefore ? 1 : 0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.captionLabel, constraints);
            this.captionSeparator = new JSeparator();
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = this.addSpaceBefore ? 1 : 0;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 10;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)this.captionSeparator, constraints);
        }
    }
}

