/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.Bundle;
import org.netbeans.modules.mercurial.ui.diff.ImportDiffAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ApplyDiffPatchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ApplyDiffPatch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(Bundle.ACSD_ApplyDiffPatchBrowseFolder(), null);
        fileChooser.setDialogTitle(Bundle.ApplyDiffPatchBrowse_title());
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(0);
        fileChooser.setApproveButtonMnemonic(Bundle.ApplyDiffPatch_Apply().charAt(0));
        fileChooser.setApproveButtonText(Bundle.ApplyDiffPatch_Apply());
        fileChooser.setCurrentDirectory(new File(HgModuleConfig.getDefault().getImportFolder()));
        FileFilter patchFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("diff") || f.getName().endsWith("patch") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Bundle.CTL_PatchDialog_FileFilter();
            }
        };
        fileChooser.addChoosableFileFilter(patchFilter);
        fileChooser.setFileFilter(patchFilter);
        DialogDescriptor dd = new DialogDescriptor((Object)fileChooser, Bundle.ApplyDiffPatchBrowse_title());
        dd.setOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        fileChooser.addActionListener(new ActionListener((JFileChooser)fileChooser, root, roots, dialog){
            final /* synthetic */ JFileChooser val$fileChooser;
            final /* synthetic */ File val$root;
            final /* synthetic */ File[] val$roots;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$fileChooser = jFileChooser;
                this.val$root = file;
                this.val$roots = fileArray;
                this.val$dialog = dialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    final File patchFile = this.val$fileChooser.getSelectedFile();
                    final RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.val$root);
                    new HgProgressSupport(){

                        @Override
                        protected void perform() {
                            if (ApplyDiffPatchAction.isNetBeansPatch(patchFile)) {
                                PatchAction.performPatch((File)patchFile, (File)val$roots[0]);
                            } else {
                                new ImportDiffAction.ImportDiffProgressSupport(val$root, patchFile, false, ImportDiffAction.ImportDiffProgressSupport.Kind.PATCH).start(rp, val$root, Bundle.MSG_ApplyDiffPatch_importingPatch());
                            }
                        }
                    }.start(rp, this.val$root, Bundle.MSG_ApplyDiffPatch_checkingFile());
                }
                this.val$dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNetBeansPatch(File patchFile) {
        try (BufferedReader reader = Files.newBufferedReader(patchFile.toPath(), Charset.forName("UTF-8"));){
            boolean netbeansPatch = false;
            boolean cont = true;
            String line = reader.readLine();
            while (line != null && cont) {
                if (!line.trim().isEmpty()) {
                    if (line.startsWith("#")) {
                        if ((line = line.substring(1).trim()).startsWith("NetBeans IDE HG Patch")) {
                            netbeansPatch = true;
                            cont = false;
                        }
                    } else {
                        cont = false;
                    }
                }
                line = reader.readLine();
            }
            boolean bl = netbeansPatch;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

