/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.spi.SPIAccessorImpl;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.commons.LogUtils;

public final class RepositoryInfo {
    private static final Logger LOG = Logger.getLogger(RepositoryInfo.class.getName());
    private static final String DELIMITER = "<=>";
    private final Map<String, String> map = new HashMap<String, String>();
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_CONNECTOR_ID = "connectorId";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_DISPLAY_NAME = "displayName";
    private static final String PROPERTY_TOOLTIP = "tooltip";
    private static final String PROPERTY_USERNAME = "username";
    private static final String PROPERTY_HTTP_USERNAME = "httpUsername";

    private RepositoryInfo(Map<String, String> properties) {
        this.logMap("create RepositoryInfo for ", properties);
        this.map.putAll(properties);
    }

    public RepositoryInfo(String id, String connectorId, String url, String displayName, String tooltip) {
        LOG.log(Level.FINER, "create RepositoryInfo for [id={0},connectorId={1},url={2},displayName={3},tooltip={4}]", new Object[]{id, connectorId, url, displayName, tooltip});
        this.map.put(PROPERTY_ID, id);
        this.map.put(PROPERTY_CONNECTOR_ID, connectorId);
        this.map.put(PROPERTY_DISPLAY_NAME, displayName);
        this.map.put(PROPERTY_TOOLTIP, tooltip);
        this.map.put(PROPERTY_URL, url);
    }

    public RepositoryInfo(String id, String connectorId, String url, String displayName, String tooltip, String user, String httpUser, char[] password, char[] httpPassword) {
        LOG.log(Level.FINER, "create RepositoryInfo for [id={0},connectorId={1},url={2},displayName={3},tooltip={4},user={5},httpUser={6},password={7},httpPassword={8}]", new Object[]{id, connectorId, url, displayName, tooltip, user, httpUser, LogUtils.getPasswordLog((char[])password), LogUtils.getPasswordLog((char[])httpPassword)});
        this.map.put(PROPERTY_ID, id);
        this.map.put(PROPERTY_CONNECTOR_ID, connectorId);
        this.map.put(PROPERTY_DISPLAY_NAME, displayName);
        this.map.put(PROPERTY_TOOLTIP, tooltip);
        this.map.put(PROPERTY_URL, url);
        this.map.put(PROPERTY_USERNAME, user);
        this.map.put(PROPERTY_HTTP_USERNAME, httpUser);
        this.storePasswords(password, httpPassword);
    }

    public String getDisplayName() {
        return this.map.get(PROPERTY_DISPLAY_NAME);
    }

    public char[] getHttpPassword() {
        if (RepositoryInfo.isNbRepository(this.map)) {
            return new char[0];
        }
        char[] httpPassword = BugtrackingUtil.readPassword(null, "http", this.getHttpUsername(), this.getUrl());
        LOG.log(Level.FINER, "read httpPassword={0}", LogUtils.getPasswordLog((char[])httpPassword));
        return httpPassword;
    }

    public String getID() {
        return this.map.get(PROPERTY_ID);
    }

    public String getConnectorId() {
        return this.map.get(PROPERTY_CONNECTOR_ID);
    }

    public String getUrl() {
        return this.map.get(PROPERTY_URL);
    }

    public char[] getPassword() {
        if (RepositoryInfo.isNbRepository(this.map)) {
            char[] password = NBBugzillaUtils.getNBPassword();
            LOG.log(Level.FINER, "read netbeans password={0}", LogUtils.getPasswordLog((char[])password));
            return password;
        }
        char[] password = BugtrackingUtil.readPassword(null, null, this.getUsername(), this.getUrl());
        LOG.log(Level.FINER, "read password={0}", LogUtils.getPasswordLog((char[])password));
        return password;
    }

    public String getTooltip() {
        return this.map.get(PROPERTY_TOOLTIP);
    }

    public String getUsername() {
        return this.map.get(PROPERTY_USERNAME);
    }

    public String getHttpUsername() {
        return this.map.get(PROPERTY_HTTP_USERNAME);
    }

    public String getValue(String key) {
        return this.map.get(key);
    }

    public void putValue(String key, String value) {
        this.map.put(key, value);
    }

    static RepositoryInfo read(Preferences preferences, String key) {
        String str = preferences.get(key, "");
        if (str.equals("")) {
            return null;
        }
        Map<String, String> m = RepositoryInfo.fromString(str);
        if (RepositoryInfo.isNbRepository(m)) {
            m.put(PROPERTY_USERNAME, NBBugzillaUtils.getNBUsername());
        }
        return new RepositoryInfo(m);
    }

    void store(Preferences preferences, String key) {
        boolean isNetbeans = RepositoryInfo.isNbRepository(this.map);
        preferences.put(key, this.getStringValue(isNetbeans));
        if (isNetbeans) {
            NBBugzillaUtils.saveNBUsername((String)this.getUsername());
        }
    }

    private String getStringValue(boolean dropUser) {
        ArrayList<String> l = new ArrayList<String>(this.map.keySet());
        Collections.sort(l);
        StringBuilder sb = new StringBuilder();
        sb.append(PROPERTY_ID);
        sb.append(DELIMITER);
        sb.append(this.map.get(PROPERTY_ID));
        for (String key : l) {
            String value;
            if (key.equals(PROPERTY_ID)) continue;
            sb.append(DELIMITER);
            sb.append(key);
            sb.append(DELIMITER);
            if (dropUser && key.equals(PROPERTY_USERNAME) || (value = this.map.get(key)) == null) continue;
            sb.append(value);
        }
        return sb.toString();
    }

    private static Map<String, String> fromString(String string) {
        String[] values = string.split(DELIMITER);
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < values.length; i += 2) {
            String key = values[i];
            String value = i < values.length - 1 ? values[i + 1] : "";
            m.put(key, value);
        }
        return m;
    }

    private void storePasswords(char[] password, char[] httpPassword) throws MissingResourceException {
        if (RepositoryInfo.isNbRepository(this.map)) {
            LOG.log(Level.FINER, "storing netbeans password={0}", LogUtils.getPasswordLog((char[])password));
            NBBugzillaUtils.saveNBPassword((char[])password);
        } else {
            LOG.log(Level.FINER, "storing password={0}, httpPassword={1}", new Object[]{LogUtils.getPasswordLog((char[])password), LogUtils.getPasswordLog((char[])httpPassword)});
            BugtrackingUtil.savePassword(password, null, this.getUsername(), this.getUrl());
            BugtrackingUtil.savePassword(httpPassword, "http", this.getHttpUsername(), this.getUrl());
        }
    }

    private static boolean isNbRepository(Map<String, String> map) {
        String url = map.get(PROPERTY_URL);
        return url != null ? NBBugzillaUtils.isNbRepository((String)url) : false;
    }

    private void logMap(String prefix, Map<String, String> properties) {
        if (!LOG.isLoggable(Level.FINER)) {
            return;
        }
        HashMap<String, String> m = new HashMap<String, String>(properties);
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append("[");
        sb.append(PROPERTY_ID);
        sb.append("=");
        sb.append(m.get(PROPERTY_ID));
        sb.append(",");
        m.remove(PROPERTY_ID);
        Object[] keys = m.keySet().toArray(new String[m.size()]);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            sb.append((String)key);
            sb.append("=");
            sb.append(m.get(key));
            if (i >= keys.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        LOG.finer(sb.toString());
    }

    static {
        SPIAccessorImpl.createAccesor();
    }
}

