/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.team.commons.LogUtils;

public final class Issue {
    public static final String EVENT_ISSUE_DATA_CHANGED = "issue.data_changed";
    public static final String EVENT_STATUS_CHANGED = "issue.status_changed";
    private final IssueImpl impl;

    Issue(IssueImpl impl) {
        this.impl = impl;
    }

    public String getID() {
        return this.impl.getID();
    }

    public String getTooltip() {
        return this.impl.getTooltip();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    public boolean refresh() {
        return this.impl.refresh();
    }

    public String getDisplayName() {
        return this.impl.getDisplayName();
    }

    public String getShortenedDisplayName() {
        return this.impl.getShortenedDisplayName();
    }

    public void open() {
        this.impl.open();
    }

    public String getSummary() {
        return this.impl.getSummary();
    }

    public boolean isFinished() {
        return this.impl.isFinished();
    }

    public Status getStatus() {
        IssueStatusProvider.Status status = this.impl.getStatus();
        if (status == null) {
            return Status.SEEN;
        }
        switch (status) {
            case SEEN: {
                return Status.SEEN;
            }
            case INCOMING_NEW: {
                return Status.INCOMING_NEW;
            }
            case INCOMING_MODIFIED: {
                return Status.INCOMING_MODIFIED;
            }
            case OUTGOING_NEW: {
                return Status.OUTGOING_NEW;
            }
            case OUTGOING_MODIFIED: {
                return Status.OUTGOING_MODIFIED;
            }
            case CONFLICT: {
                return Status.CONFLICT;
            }
        }
        throw new IllegalStateException("Unexpected status value " + (Object)((Object)status));
    }

    public boolean canAttachFiles() {
        return this.impl.getRepositoryImpl().canAttachFiles();
    }

    public void attachFile(File file, String description, boolean isPatch) {
        this.impl.attachFile(file, description, isPatch);
    }

    public void addComment(String comment, boolean close) {
        LogUtils.logBugtrackingUsage((String)this.impl.getRepositoryImpl().getConnectorId(), (String)"COMMIT_HOOK");
        this.impl.addComment(comment, close);
    }

    public Repository getRepository() {
        return this.impl.getRepositoryImpl().getRepository();
    }

    IssueImpl getImpl() {
        return this.impl;
    }

    public static enum Status {
        INCOMING_NEW,
        INCOMING_MODIFIED,
        OUTGOING_NEW,
        OUTGOING_MODIFIED,
        CONFLICT,
        SEEN;

    }
}

